/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internationalization.modelelements;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.commands.AddEAnnotationDetailCommand;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.commands.RemoveEAnnotationDetailCommand;
import org.eclipse.papyrus.infra.emf.commands.RemoveFromResourcecommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.internationalization.common.command.UseInternationalizationPreferenceCommand;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationAnnotationResourceUtils;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationPreferenceModel;
import org.eclipse.papyrus.infra.internationalization.ui.Activator;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationPreferenceModelUtils;

public class UseInternationalizationObservableValue
extends AbstractObservableValue<Boolean> {
    private EditingDomain domain;

    public UseInternationalizationObservableValue(EditingDomain domain) {
        this.domain = domain;
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected Boolean doGetValue() {
        if (!InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            return false;
        }
        InternationalizationPreferenceModel model = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
        return InternationalizationPreferencesUtils.getInternationalizationPreference((URI)model.getPrivateResourceURI());
    }

    protected void doSetValue(Boolean value) {
        Command command = this.getSetCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    protected Command getSetCommand(Boolean value) {
        TransactionalEditingDomain domainForResource;
        boolean needCreateAnnotation = true;
        InternationalizationPreferenceModel model = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
        Resource resource = model.getResource();
        EAnnotation annotation = InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)resource);
        CompoundCommand compoundCommand = new CompoundCommand("Create internationalization command");
        if (annotation != null) {
            if (annotation.getDetails().containsKey((Object)"use")) {
                try {
                    domainForResource = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)resource);
                    compoundCommand.append((Command)new RemoveEAnnotationDetailCommand(domainForResource, annotation, "use"));
                    if (1 == annotation.getDetails().size()) {
                        compoundCommand.append((Command)new RemoveFromResourcecommand(domainForResource, resource, (EObject)annotation));
                    } else {
                        needCreateAnnotation = false;
                    }
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                compoundCommand.append((Command)new UseInternationalizationPreferenceCommand(model.getPrivateResourceURI(), false));
            } else {
                needCreateAnnotation = false;
            }
        }
        if (value.booleanValue()) {
            if (needCreateAnnotation) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Internationalization");
                annotation.getDetails().put((Object)"use", (Object)Boolean.toString(value));
                compoundCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AddToResourceCommand(((ModelSet)resource.getResourceSet()).getTransactionalEditingDomain(), resource, (EObject)annotation)));
            } else {
                try {
                    domainForResource = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)resource);
                    compoundCommand.append((Command)new AddEAnnotationDetailCommand(domainForResource, annotation, "use", Boolean.toString(value)));
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            compoundCommand.append((Command)new UseInternationalizationPreferenceCommand(model.getPrivateResourceURI(), value.booleanValue()));
        }
        return !compoundCommand.getCommandList().isEmpty() ? compoundCommand : UnexecutableCommand.INSTANCE;
    }
}

