/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.papyrusgmfgenextension.popupaction;

import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelOffsetAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.Action;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.SetVisualIDWithUnusedValue;
import org.eclipse.ui.IViewPart;

public class AddGenLinkStereotypeDisplayBehavior
extends Action {
    public static final String STEREOTYPE_LABEL_POLICY_KEY = "org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy.STEREOTYPE_LABEL_POLICY";
    public static final String STEREOTYPE_LABEL_POLICY_CLASS = "org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy";
    public static final String DEFAULT_GETTER_NAME = "getAppliedStereotypeLabel";
    public static final String DEFAULT_EDITPART_NAME_SUFFIX = "AppliedStereotypeEditPart";
    public static final String DEFAULT_EDITPOLICY_NAME_SUFFIX = "AppliedStereotypeItemSemanticEditPolicy";
    public static final String DEFAULT_WRAPPING_LABEL_CLASS = "org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel";
    public static final int DEFAULT_OFFSET_X = 0;
    public static final int DEFAULT_OFFSET_Y = 60;
    public static final String DEFAULT_PARSER_PATTERN = "<<{0}>>";
    public static final String APPLIED_STEREOTYPE_CUSTOM_PARSER_CLASS = "org.eclipse.papyrus.diagram.common.parser.stereotype.AppliedStereotypeParser";
    public static final String GEN_CLASS_RT_CLASS = "Node";
    public static final String GEN_CLASS_FACET_META_FEATURE = "NamedElement";
    public static final String GEN_FEATURE_FACET_META_FEATURE = "name";
    public static final String URI_NOTATION_GENMODEL = "org.eclipse.gmf.runtime.notation/model/notation.genmodel";
    public static final String URI_UML_GENMODEL = "org.eclipse.uml2.uml/model/UML.genmodel";

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        for (EObject eObject : this.getSelectedEObject()) {
            if (!(eObject instanceof GenLink)) continue;
            if (!this.hasCustomBehavior((GenCommonBase)((GenLink)eObject), STEREOTYPE_LABEL_POLICY_KEY)) {
                this.addCustomBehavior((GenCommonBase)((GenLink)eObject), STEREOTYPE_LABEL_POLICY_KEY, STEREOTYPE_LABEL_POLICY_CLASS);
            }
            if (this.hasCustomLabel((GenLink)eObject)) continue;
            this.addCustomLabel((GenLink)eObject);
        }
    }

    private void addCustomLabel(GenLink genlink) {
        GenLinkLabel label = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        label.setEditPartClassName(String.valueOf(genlink.getClassNamePrefix()) + DEFAULT_EDITPART_NAME_SUFFIX);
        label.setItemSemanticEditPolicyClassName(String.valueOf(genlink.getClassNamePrefix()) + DEFAULT_EDITPOLICY_NAME_SUFFIX);
        label.setAlignment(LinkLabelAlignment.MIDDLE_LITERAL);
        label.setReadOnly(true);
        int visualID = SetVisualIDWithUnusedValue.getNewVisualID(genlink.eResource(), GenLinkLabel.class);
        label.setVisualID(visualID);
        URI uri_notation = URI.createPlatformPluginURI((String)URI_NOTATION_GENMODEL, (boolean)false);
        Resource notation = genlink.eResource().getResourceSet().getResource(uri_notation, true);
        label.setDiagramRunTimeClass(this.findGenClass(notation, GEN_CLASS_RT_CLASS));
        ParentAssignedViewmap viewmap = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
        viewmap.setGetterName(DEFAULT_GETTER_NAME);
        viewmap.setFigureQualifiedClassName(DEFAULT_WRAPPING_LABEL_CLASS);
        LabelOffsetAttributes offset = GMFGenFactory.eINSTANCE.createLabelOffsetAttributes();
        offset.setX(0);
        offset.setY(60);
        FeatureLabelModelFacet facet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
        facet.setEditPattern(DEFAULT_PARSER_PATTERN);
        facet.setEditorPattern(DEFAULT_PARSER_PATTERN);
        facet.setViewPattern(DEFAULT_PARSER_PATTERN);
        URI uri_uml = URI.createPlatformPluginURI((String)URI_UML_GENMODEL, (boolean)false);
        Resource uml = genlink.eResource().getResourceSet().getResource(uri_uml, true);
        facet.getMetaFeatures().add((Object)this.findGenFeature(uml, GEN_CLASS_FACET_META_FEATURE, GEN_FEATURE_FACET_META_FEATURE));
        facet.setParser((GenParserImplementation)this.findCustomParser(genlink.getDiagram().getEditorGen(), APPLIED_STEREOTYPE_CUSTOM_PARSER_CLASS));
        viewmap.getAttributes().add((Object)offset);
        label.setViewmap((Viewmap)viewmap);
        label.setModelFacet((LabelModelFacet)facet);
        genlink.getLabels().add((Object)label);
    }

    private boolean hasCustomLabel(GenLink genlink) {
        boolean hasCustomLabel = false;
        String expectedName = String.valueOf(genlink.getClassNamePrefix()) + DEFAULT_EDITPART_NAME_SUFFIX;
        Iterator it = genlink.getLabels().iterator();
        while (it.hasNext() && !hasCustomLabel) {
            GenLinkLabel genLinkLabel = (GenLinkLabel)it.next();
            if (!expectedName.equals(genLinkLabel.getEditPartClassName())) continue;
            hasCustomLabel = true;
        }
        return hasCustomLabel;
    }

    private CustomParser findCustomParser(GenEditorGenerator genEditor, String name) {
        CustomParser customParser = null;
        Iterator it = genEditor.getLabelParsers().getImplementations().iterator();
        while (it.hasNext() && customParser == null) {
            CustomParser current;
            GenParserImplementation parserImpl = (GenParserImplementation)it.next();
            if (!(parserImpl instanceof CustomParser) || !name.equals((current = (CustomParser)parserImpl).getQualifiedName())) continue;
            customParser = current;
        }
        if (customParser == null) {
            customParser = GMFGenFactory.eINSTANCE.createCustomParser();
            customParser.setQualifiedName(APPLIED_STEREOTYPE_CUSTOM_PARSER_CLASS);
            customParser.setGenerateBoilerplate(false);
            genEditor.getLabelParsers().getImplementations().add((Object)customParser);
        }
        return customParser;
    }
}

