/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.parser;

import java.util.LinkedList;
import java.util.List;
import lpg.runtime.ILexStream;
import lpg.runtime.LexParser;
import lpg.runtime.LexStream;
import lpg.runtime.LpgLexStream;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.PrsStream;
import lpg.runtime.RuleAction;
import org.eclipse.papyrus.gmf.internal.xpand.parser.XpandKWLexer;
import org.eclipse.papyrus.gmf.internal.xpand.parser.XpandLexerprs;
import org.eclipse.papyrus.gmf.internal.xpand.parser.XpandLexersym;
import org.eclipse.papyrus.gmf.internal.xpand.parser.XpandParsersym;
import org.eclipse.papyrus.gmf.internal.xpand.util.ParserException;

public class XpandLexer
extends LpgLexStream
implements XpandParsersym,
XpandLexersym,
RuleAction {
    private static ParseTable prs = new XpandLexerprs();
    private PrsStream prsStream;
    private final LexParser lexParser = new LexParser((ILexStream)this, prs, (RuleAction)this);
    private XpandKWLexer kwLexer;
    private final int[] tokenKind = new int[]{101, 101, 101, 101, 101, 101, 101, 101, 101, 74, 90, 101, 99, 91, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 68, 76, 92, 95, 80, 94, 96, 93, 88, 89, 73, 71, 87, 20, 13, 72, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 69, 81, 70, 12, 15, 86, 77, 47, 48, 49, 16, 11, 50, 51, 52, 53, 54, 55, 56, 17, 18, 57, 58, 59, 19, 60, 61, 62, 63, 64, 65, 66, 67, 84, 98, 85, 97, 46, 78, 21, 22, 23, 24, 14, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 82, 75, 83, 79, 102, 106};
    private final List<ParserException.ErrorLocationInfo> errors = new LinkedList<ParserException.ErrorLocationInfo>();

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getFirstToken();
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public XpandLexer(char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
    }

    public XpandLexer(char[] input_chars, String filename) {
        this(input_chars, filename, 4);
    }

    public String[] orderedExportedSymbols() {
        return XpandParsersym.orderedTerminalSymbols;
    }

    public LexStream getLexStream() {
        return this;
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public void lexer(PrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, PrsStream prsStream) {
        if (this.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.prsStream = prsStream;
        this.resetErrors();
        prsStream.makeToken(0, 0, 0);
        this.lexParser.parseCharacters(monitor);
        int i = this.getStreamIndex();
        prsStream.makeToken(i, i, 69);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public void initialize(char[] content, String filename) {
        super.initialize(content, filename);
        if (this.kwLexer == null) {
            this.kwLexer = new XpandKWLexer(this.getInputChars(), 3);
        } else {
            this.kwLexer.setInputChars(this.getInputChars());
        }
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.makeToken(startOffset, endOffset, kind);
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        super.getPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.makeToken(startOffset, endOffset, kwKind);
    }

    public final int getKind(int i) {
        char c;
        char c2 = c = i >= this.getStreamLength() ? (char)'\uffff' : (char)this.getCharValue(i);
        return c < '\u0080' ? this.tokenKind[c] : (c == '\uffff' ? 106 : XpandLexer.getNonAsciiKind(c));
    }

    private static final int getNonAsciiKind(char c) {
        if (c == '\u00ab') {
            return 104;
        }
        if (c == '\u00bb') {
            return 100;
        }
        if (c == '\u00b4') {
            return 105;
        }
        return 102;
    }

    public ParserException.ErrorLocationInfo[] getErrors() {
        return this.errors.toArray(new ParserException.ErrorLocationInfo[this.errors.size()]);
    }

    private void resetErrors() {
        this.errors.clear();
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(errorCode);
        sb.append(") ");
        if (errorInfo != null) {
            int i = 0;
            while (i < errorInfo.length) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(errorInfo[i]);
                ++i;
            }
        }
        this.errors.add(new ParserException.ErrorLocationInfo(sb.toString(), this.getLine(leftToken), this.getColumn(leftToken), this.getEndLine(rightToken), this.getEndColumn(rightToken)));
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(6);
                break;
            }
            case 3: {
                this.makeToken(6);
                break;
            }
            case 4: {
                this.makeToken(6);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.makeToken(26);
                break;
            }
            case 9: {
                this.makeComment(106);
                break;
            }
            case 10: {
                this.makeComment(107);
                break;
            }
            case 11: {
                this.skipToken();
                break;
            }
            case 12: {
                this.makeToken(37);
                break;
            }
            case 13: {
                this.makeToken(5);
                break;
            }
            case 14: {
                this.makeToken(2);
                break;
            }
            case 15: {
                this.makeToken(41);
                break;
            }
            case 16: {
                this.makeToken(1);
                break;
            }
            case 17: {
                this.makeToken(4);
                break;
            }
            case 18: {
                this.makeToken(47);
                break;
            }
            case 19: {
                this.makeToken(48);
                break;
            }
            case 20: {
                this.makeToken(38);
                break;
            }
            case 21: {
                this.makeToken(49);
                break;
            }
            case 22: {
                this.makeToken(50);
                break;
            }
            case 23: {
                this.makeToken(51);
                break;
            }
            case 24: {
                this.makeToken(43);
                break;
            }
            case 25: {
                this.makeToken(70);
                break;
            }
            case 26: {
                this.makeToken(58);
                break;
            }
            case 27: {
                this.makeToken(56);
                break;
            }
            case 28: {
                this.makeToken(44);
                break;
            }
            case 29: {
                this.makeToken(39);
                break;
            }
            case 30: {
                this.makeToken(21);
                break;
            }
            case 31: {
                this.makeToken(52);
                break;
            }
            case 32: {
                this.makeToken(40);
                break;
            }
            case 33: {
                this.makeToken(61);
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                this.makeToken(45);
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                this.makeToken(71);
                break;
            }
            case 38: {
                this.makeToken(25);
                break;
            }
            case 263: {
                this.makeToken(62);
                break;
            }
            case 264: {
                this.makeToken(103);
                break;
            }
            case 265: {
                this.makeToken(46);
                break;
            }
            case 266: {
                this.makeToken(104);
                break;
            }
            case 267: {
                this.makeToken(105);
                break;
            }
            case 274: {
                this.makeToken(6);
                break;
            }
            case 278: {
                this.makeToken(187);
                break;
            }
            case 279: {
                this.makeToken(188);
                break;
            }
            case 280: {
                this.makeToken(189);
                break;
            }
            case 281: {
                this.makeToken(190);
                break;
            }
            case 282: {
                this.makeToken(191);
                break;
            }
            case 283: {
                this.makeToken(192);
                break;
            }
            case 284: {
                this.makeToken(93);
                break;
            }
            case 285: {
                this.makeToken(24);
                break;
            }
            case 295: {
                this.skipToken();
                break;
            }
        }
    }
}

