/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Template;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.Variable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandAnalyzable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandEvaluatable;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.DeclaredParameter;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.TypeHelper;

public abstract class AbstractDefinition
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    protected final TypeHelper type;
    protected final DeclaredParameter[] params;
    private final Statement[] body;
    protected Template owner = null;

    public AbstractDefinition(int start, int end, int line, TypeCS type, DeclaredParameter[] params, Statement[] body) {
        super(start, end, line);
        this.type = new TypeHelper(type);
        this.params = params;
        this.body = body;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public void setOwner(Template owner) {
        this.owner = owner;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier thisType = this.type.getTypeForName(ctx);
        if (thisType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't find " + this.type.getName(), this));
        }
        ctx = ctx.cloneWithVariable(new Variable("this", thisType, null));
        Variable[] vars = new Variable[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            EClassifier paramType = this.params[i].getTypeForName(ctx);
            if (paramType == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't find " + this.params[i].getTypeName(), this));
                paramType = EcorePackage.eINSTANCE.getEObject();
            }
            String name = this.params[i].getVarName();
            vars[i] = new Variable(name, paramType, null);
            ++i;
        }
        ctx = ctx.cloneWithVariable(vars);
        i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluate(ExecutionContext ctx) {
        ctx = ctx.cloneWithResource(this.owner);
        int i = 0;
        while (i < this.body.length) {
            this.body[i].evaluate(ctx);
            ++i;
        }
    }

    public TypeHelper getType() {
        return this.type;
    }

    public DeclaredParameter[] getParemeters() {
        return this.params;
    }
}

