/******************************************************************************
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/ 
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors: 
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *****************************************************************************/
package org.eclipse.papyrus.gmf.internal.xpand.parser;

public interface XpandLexersym {
    public final static int
      Char_CtlCharNotWS = 101,
      Char_LF = 90,
      Char_CR = 91,
      Char_HT = 74,
      Char_FF = 99,
      Char_a = 21,
      Char_b = 22,
      Char_c = 23,
      Char_d = 24,
      Char_e = 14,
      Char_f = 25,
      Char_g = 26,
      Char_h = 27,
      Char_i = 28,
      Char_j = 29,
      Char_k = 30,
      Char_l = 31,
      Char_m = 32,
      Char_n = 33,
      Char_o = 34,
      Char_p = 35,
      Char_q = 36,
      Char_r = 37,
      Char_s = 38,
      Char_t = 39,
      Char_u = 40,
      Char_v = 41,
      Char_w = 42,
      Char_x = 43,
      Char_y = 44,
      Char_z = 45,
      Char__ = 46,
      Char_A = 47,
      Char_B = 48,
      Char_C = 49,
      Char_D = 16,
      Char_E = 11,
      Char_F = 50,
      Char_G = 51,
      Char_H = 52,
      Char_I = 53,
      Char_J = 54,
      Char_K = 55,
      Char_L = 56,
      Char_M = 17,
      Char_N = 18,
      Char_O = 57,
      Char_P = 58,
      Char_Q = 59,
      Char_R = 19,
      Char_S = 60,
      Char_T = 61,
      Char_U = 62,
      Char_V = 63,
      Char_W = 64,
      Char_X = 65,
      Char_Y = 66,
      Char_Z = 67,
      Char_0 = 1,
      Char_1 = 2,
      Char_2 = 3,
      Char_3 = 4,
      Char_4 = 5,
      Char_5 = 6,
      Char_6 = 7,
      Char_7 = 8,
      Char_8 = 9,
      Char_9 = 10,
      Char_AfterASCIINotAcute = 103,
      Char_Space = 68,
      Char_DoubleQuote = 92,
      Char_SingleQuote = 93,
      Char_Percent = 94,
      Char_VerticalBar = 75,
      Char_Exclamation = 76,
      Char_AtSign = 77,
      Char_BackQuote = 78,
      Char_Acute = 105,
      Char_Tilde = 79,
      Char_Sharp = 95,
      Char_DollarSign = 80,
      Char_Ampersand = 96,
      Char_Caret = 97,
      Char_Colon = 69,
      Char_SemiColon = 81,
      Char_BackSlash = 98,
      Char_LeftBrace = 82,
      Char_RightBrace = 83,
      Char_LeftBracket = 84,
      Char_RightBracket = 85,
      Char_QuestionMark = 86,
      Char_Comma = 87,
      Char_Dot = 13,
      Char_LessThan = 70,
      Char_GreaterThan = 15,
      Char_Plus = 71,
      Char_Minus = 20,
      Char_Slash = 72,
      Char_Star = 73,
      Char_LeftParen = 88,
      Char_RightParen = 89,
      Char_Equal = 12,
      Char_AfterASCII = 102,
      Char_LG = 104,
      Char_RG = 100,
      Char_EOF = 106;

    public final static String orderedTerminalSymbols[] = {
                 "",
                 "0",
                 "1",
                 "2",
                 "3",
                 "4",
                 "5",
                 "6",
                 "7",
                 "8",
                 "9",
                 "E",
                 "Equal",
                 "Dot",
                 "e",
                 "GreaterThan",
                 "D",
                 "M",
                 "N",
                 "R",
                 "Minus",
                 "a",
                 "b",
                 "c",
                 "d",
                 "f",
                 "g",
                 "h",
                 "i",
                 "j",
                 "k",
                 "l",
                 "m",
                 "n",
                 "o",
                 "p",
                 "q",
                 "r",
                 "s",
                 "t",
                 "u",
                 "v",
                 "w",
                 "x",
                 "y",
                 "z",
                 "_",
                 "A",
                 "B",
                 "C",
                 "F",
                 "G",
                 "H",
                 "I",
                 "J",
                 "K",
                 "L",
                 "O",
                 "P",
                 "Q",
                 "S",
                 "T",
                 "U",
                 "V",
                 "W",
                 "X",
                 "Y",
                 "Z",
                 "Space",
                 "Colon",
                 "LessThan",
                 "Plus",
                 "Slash",
                 "Star",
                 "HT",
                 "VerticalBar",
                 "Exclamation",
                 "AtSign",
                 "BackQuote",
                 "Tilde",
                 "DollarSign",
                 "SemiColon",
                 "LeftBrace",
                 "RightBrace",
                 "LeftBracket",
                 "RightBracket",
                 "QuestionMark",
                 "Comma",
                 "LeftParen",
                 "RightParen",
                 "LF",
                 "CR",
                 "DoubleQuote",
                 "SingleQuote",
                 "Percent",
                 "Sharp",
                 "Ampersand",
                 "Caret",
                 "BackSlash",
                 "FF",
                 "RG",
                 "CtlCharNotWS",
                 "AfterASCII",
                 "AfterASCIINotAcute",
                 "LG",
                 "Acute",
                 "EOF"
             };

    public final static int numTokenKinds = orderedTerminalSymbols.length;
    public final static boolean isValidForParser = true;
}
