/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.graphdef.codegen;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.papyrus.gmf.common.UnexpectedBehaviourException;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.papyrus.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.papyrus.gmf.graphdef.codegen.StandaloneEmitters;
import org.eclipse.papyrus.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.papyrus.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.papyrus.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.papyrus.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.papyrus.gmf.internal.common.codegen.TextMerger;

public class StandaloneGenerator
extends GeneratorBase {
    protected final Config myArgs;
    private final TextEmitter myFigureGenerator;
    private final StandaloneEmitters myAuxiliaryGenerators;
    private boolean mySkipPluginStructire;
    protected Processor myProcessor;
    private final Map<String, FigureDescriptor> myCallbackFigures = new LinkedHashMap<String, FigureDescriptor>();

    public StandaloneGenerator(Processor p, Config config) {
        this(p, config, null);
    }

    public StandaloneGenerator(Processor p, Config config, URL[] dynamicTemplates) {
        String accessor;
        MapModeCodeGenStrategy strategy;
        assert (p != null && config != null);
        this.myArgs = config;
        this.myProcessor = p;
        String pluginActivatorFQN = StandaloneGenerator.composePluginActivatorClassFQN(config);
        if (config.getMapMode() == MapModeCodeGenStrategy.DYNAMIC) {
            strategy = MapModeCodeGenStrategy.DYNAMIC;
            accessor = String.valueOf(pluginActivatorFQN) + ".getDefault().";
        } else {
            strategy = config.getMapMode() == null ? MapModeCodeGenStrategy.STATIC : config.getMapMode();
            accessor = null;
        }
        this.myFigureGenerator = new FigureGenerator(config.getRuntimeToken(), this.getPackageName(), strategy, accessor, false, dynamicTemplates);
        this.myAuxiliaryGenerators = new StandaloneEmitters(strategy, dynamicTemplates);
    }

    public void setSkipPluginStructure(boolean skipManifest) {
        this.mySkipPluginStructire = skipManifest;
    }

    protected void setupProgressMonitor() {
    }

    protected TextMerger createMergeService() {
        return new DefaultTextMerger(new JControlModel());
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        this.initializeEditorProject(this.myArgs.getPluginID(), null);
        if (!this.mySkipPluginStructire) {
            this.generatePluginStructure();
        }
        try {
            this.generateTopLevelFigures();
            this.generatePluginActivator();
        }
        catch (IllegalStateException e) {
            throw new UnexpectedBehaviourException((Throwable)e);
        }
    }

    protected void generatePluginActivator() throws UnexpectedBehaviourException, InterruptedException {
        Object[] args = new Object[]{this.myArgs, new ImportUtil(this.myArgs.getPluginActivatorPackageName(), this.myArgs.getPluginActivatorClassName()), new ArrayList<String>(this.myCallbackFigures.keySet())};
        this.doGenerateJavaClass(this.myAuxiliaryGenerators.getPluginActivatorEmitter(), this.myArgs.getPluginActivatorPackageName(), this.myArgs.getPluginActivatorClassName(), args);
    }

    protected void generatePluginStructure() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myAuxiliaryGenerators.getBuildPropertiesEmitter(), (IPath)new Path("build.properties"), new Object[]{this.myArgs});
        this.doGenerateFile(this.myAuxiliaryGenerators.getManifestMFEmitter(), (IPath)new Path("META-INF/MANIFEST.MF"), new Object[]{this.myArgs, this.myProcessor.getRequiredBundles()});
        this.doGenerateFile(this.myAuxiliaryGenerators.getPluginPropertiesEmitter(), (IPath)new Path("plugin.properties"), new Object[]{this.myArgs});
    }

    private void generateTopLevelFigures() throws InterruptedException {
        this.myCallbackFigures.clear();
        this.myProcessor.go(new ProcessorCallback(){

            @Override
            public String visitFigure(FigureDescriptor f) throws InterruptedException {
                return StandaloneGenerator.this.visitFigure(f);
            }
        }, this.myArgs);
    }

    private String visitFigure(FigureDescriptor figureDescriptor) throws InterruptedException {
        if (figureDescriptor.getName() == null) {
            throw new IllegalArgumentException("FigureDescriptor needs a name");
        }
        String compilationUnitName = CodeGenUtil.validJavaIdentifier((String)CodeGenUtil.capName((String)figureDescriptor.getName()));
        this.doGenerateJavaClass(this.myFigureGenerator, this.getPackageName(), compilationUnitName, new Object[]{figureDescriptor});
        String qualifiedName = StandaloneGenerator.composeFQN(this.getPackageName(), compilationUnitName);
        this.myCallbackFigures.put(qualifiedName, figureDescriptor);
        return qualifiedName;
    }

    private String getPackageName() {
        return this.myArgs.getMainPackageName();
    }

    private static String composePluginActivatorClassFQN(Config config) {
        String packageName = config.getPluginActivatorPackageName();
        String className = config.getPluginActivatorClassName();
        return StandaloneGenerator.composeFQN(packageName, className);
    }

    private static String composeFQN(String packageName, String className) {
        return packageName == null || "".equals(packageName) ? className : String.valueOf(packageName) + "." + className;
    }

    public static interface Config {
        public String getPluginID();

        public String getPluginFriendlyName();

        public String getPluginProviderName();

        public String getMainPackageName();

        public String getPluginActivatorClassName();

        public String getPluginActivatorPackageName();

        public MapModeCodeGenStrategy getMapMode();

        public String getRuntimeToken();
    }

    public static class ConfigImpl
    implements Config {
        private final String myPluginId;
        private final String myMainPackageName;
        private final String myPluginFriendlyName;
        private final String myPluginProviderName;
        private final String myPluginActivatorClassName;
        private final String myPluginActivatorPackageName;
        private final MapModeCodeGenStrategy myMapMode;
        private final String myRuntimeToken;

        public ConfigImpl(String pluginId, String mainPackageName) {
            this(pluginId, mainPackageName, MapModeCodeGenStrategy.DYNAMIC, null);
        }

        public ConfigImpl(String pluginId, String mainPackageName, MapModeCodeGenStrategy mapMode, String runtimeToken) {
            this(pluginId, mainPackageName, pluginId, "", "PluginActivator", String.valueOf(mainPackageName == null ? "" : String.valueOf(mainPackageName) + ".") + "activator", mapMode, runtimeToken);
        }

        public ConfigImpl(String pluginId, String mainPackageName, String pluginFriendlyName, String pluginProviderName, String pluginActivatorClassName, String pluginActivatorPackageName, MapModeCodeGenStrategy mapMode, String runtimeToken) {
            this.myPluginId = pluginId;
            this.myMainPackageName = mainPackageName == null ? "" : mainPackageName;
            this.myPluginFriendlyName = pluginFriendlyName;
            this.myPluginProviderName = pluginProviderName;
            this.myPluginActivatorClassName = pluginActivatorClassName;
            this.myPluginActivatorPackageName = pluginActivatorPackageName;
            this.myMapMode = mapMode;
            this.myRuntimeToken = runtimeToken;
        }

        @Override
        public String getMainPackageName() {
            return this.myMainPackageName;
        }

        @Override
        public String getPluginFriendlyName() {
            return this.myPluginFriendlyName;
        }

        @Override
        public String getPluginID() {
            return this.myPluginId;
        }

        @Override
        public String getPluginProviderName() {
            return this.myPluginProviderName;
        }

        @Override
        public String getPluginActivatorClassName() {
            return this.myPluginActivatorClassName;
        }

        @Override
        public String getPluginActivatorPackageName() {
            return this.myPluginActivatorPackageName;
        }

        @Override
        public MapModeCodeGenStrategy getMapMode() {
            return this.myMapMode;
        }

        @Override
        public String getRuntimeToken() {
            return this.myRuntimeToken;
        }
    }

    public static abstract class Processor {
        public abstract void go(ProcessorCallback var1, Config var2) throws InterruptedException;

        public String[] getRequiredBundles() {
            return new String[0];
        }
    }

    public static interface ProcessorCallback {
        public String visitFigure(FigureDescriptor var1) throws InterruptedException;
    }
}

