/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.editor.Editor;
import xpt.editor.ValidationMarker;
import xpt.editor.VisualIDRegistry;

/**
 * FIXME: [MG] monolithic template with most of the code "same-generated".
 * Unfortunately, a lot of the logic is based around «IF editorGen.application == null» and we don't have a good ways to deal with taht in GMFT-runtimw
 */
@Singleton
@SuppressWarnings("all")
public class ValidationDecoratorProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private Editor xptEditor;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private ValidationMarker xptValidationMarker;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _validationDecoratorProviderClassName = it.getValidationDecoratorProviderClassName();
    _builder.append(_validationDecoratorProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getProvidersPackageName();
    _builder.append(_providersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence ValidationDecoratorProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("extends org.eclipse.gmf.runtime.common.core.service.AbstractProvider");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static final String KEY = \"validationStatus\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private static final String MARKER_TYPE = ");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".ID +");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("\".");
        String _validationDiagnosticMarkerType = it.getValidationDiagnosticMarkerType();
        _builder.append(_validationDiagnosticMarkerType, "\t\t\t");
        _builder.append("\"; ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append(_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private static MarkerObserver fileObserver;");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static java.util.Map/*<String, List<IDecorator>>*/ allDecorators = new java.util.HashMap();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void createDecorators(org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget decoratorTarget) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.EditPart editPart = (org.eclipse.gef.EditPart) decoratorTarget.getAdapter(org.eclipse.gef.EditPart.class);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart ||");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("editPart instanceof org.eclipse.gef.editparts.AbstractConnectionEditPart) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Object model = editPart.getModel();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if ((model instanceof org.eclipse.gmf.runtime.notation.View)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) model;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (!(view instanceof org.eclipse.gmf.runtime.notation.Edge) && !view.isSetElement()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gef.EditDomain ed = editPart.getViewer().getEditDomain();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!(ed instanceof org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (((org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain) ed).getEditorPart() instanceof");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _qualifiedClassName_1 = this.xptEditor.qualifiedClassName(it.getEditorGen().getEditor());
    _builder.append(_qualifiedClassName_1, "\t\t\t\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("decoratorTarget.installDecorator(KEY, new StatusDecorator(decoratorTarget));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean provides(org.eclipse.gmf.runtime.common.core.service.IOperation operation) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!(operation instanceof org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget decoratorTarget =");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("((org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation) operation).getDecoratorTarget();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) decoratorTarget.getAdapter(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return view != null && ");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t\t");
    _builder.append(".equals(");
    CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t\t");
    _builder.append("(view));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static void refreshDecorators(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("refreshDecorators(org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.getIdStr(view), view.getDiagram());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static void refreshDecorators(String viewId, org.eclipse.gmf.runtime.notation.Diagram diagram) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final java.util.List decorators = viewId != null ? (java.util.List) allDecorators.get(viewId) : null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (decorators == null || decorators.isEmpty() || diagram == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.gmf.runtime.notation.Diagram fdiagram = diagram;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.ui.PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(fdiagram).runExclusive(new Runnable() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("for (java.util.Iterator it = decorators.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator decorator =");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator) it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("decorator.refresh();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_2, "\t\t\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("\"Decorator refresh failure\", e); ");
    CharSequence _nonNLS_2 = this._common.nonNLS(1);
    _builder.append(_nonNLS_2, "\t\t\t\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static class StatusDecorator extends org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private String viewId;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public StatusDecorator(org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget decoratorTarget) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super(decoratorTarget);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("final org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) getDecoratorTarget().getAdapter(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(view).runExclusive(new Runnable() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("StatusDecorator.this.viewId = view != null ?");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.getIdStr(view) : null;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_3, "\t\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("\"ViewID access failure\", e); ");
    CharSequence _nonNLS_3 = this._common.nonNLS(1);
    _builder.append(_nonNLS_3, "\t\t\t\t\t\t");
    _builder.append("\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void refresh() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("removeDecoration();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) getDecoratorTarget().getAdapter(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (view == null || view.eResource() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gef.EditPart editPart = (org.eclipse.gef.EditPart) getDecoratorTarget().getAdapter(org.eclipse.gef.EditPart.class);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (editPart == null || editPart.getViewer() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// query for all the validation markers of the current resource");
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(_application_1, null);
      if (_equals_1) {
        _builder.append("\t\t\t");
        _builder.append("String elementId = org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.getIdStr(view);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (elementId == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("int severity = org.eclipse.core.resources.IMarker.SEVERITY_INFO;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.resources.IMarker foundMarker = null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.resources.IResource resource = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(view.eResource());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (resource == null || !resource.exists()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.resources.IMarker[] markers = null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("markers = resource.findMarkers(MARKER_TYPE, true, org.eclipse.core.resources.IResource.DEPTH_INFINITE);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (org.eclipse.core.runtime.CoreException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName_4, "\t\t\t\t");
        _builder.append(".getInstance().logError(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t");
        _builder.append("\"Validation markers refresh failure\", e); ");
        CharSequence _nonNLS_4 = this._common.nonNLS(1);
        _builder.append(_nonNLS_4, "\t\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t\t\t");
        _builder.append("int severity = org.eclipse.core.runtime.IStatus.INFO;");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_5 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_5, "\t\t\t");
        _builder.append(" foundMarker = null;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_6 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_6, "\t\t\t");
        _builder.append("[] markers =");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_7 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_7, "\t\t\t\t\t");
        _builder.append(".getMarkers(editPart.getViewer(), viewId);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("if (markers == null || markers.length == 0) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.draw2d.Label toolTip = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (int i = 0; i < markers.length; i++) {");
    _builder.newLine();
    {
      GenApplication _application_2 = it.getEditorGen().getApplication();
      boolean _equals_2 = Objects.equal(_application_2, null);
      if (_equals_2) {
        _builder.append("\t\t\t\t");
        _builder.append("org.eclipse.core.resources.IMarker marker = markers[i];");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("String attribute = marker.getAttribute(org.eclipse.gmf.runtime.common.ui.resources.IMarker.ELEMENT_ID, \"\"); ");
        CharSequence _nonNLS_5 = this._common.nonNLS(1);
        _builder.append(_nonNLS_5, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (attribute.equals(elementId)) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("\t");
        _builder.append("int nextSeverity = marker.getAttribute(org.eclipse.core.resources.IMarker.SEVERITY,");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.resources.IMarker.SEVERITY_INFO);\t\t\t\t\t");
        _builder.newLine();
      } else {
        _builder.append("\t\t\t\t");
        CharSequence _qualifiedClassName_8 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_8, "\t\t\t\t");
        _builder.append(" marker = markers[i];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("int nextSeverity = marker.getStatusSeverity();");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.swt.graphics.Image nextImage = getImage(nextSeverity);\t ");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (foundMarker == null) {\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("foundMarker = marker;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("toolTip = new org.eclipse.draw2d.Label(");
    _builder.newLine();
    {
      GenApplication _application_3 = it.getEditorGen().getApplication();
      boolean _equals_3 = Objects.equal(_application_3, null);
      if (_equals_3) {
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("marker.getAttribute(org.eclipse.core.resources.IMarker.MESSAGE, \"\"), ");
        CharSequence _nonNLS_6 = this._common.nonNLS(1);
        _builder.append(_nonNLS_6, "\t\t\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("marker.getMessage(),");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("nextImage);\t\t\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if (toolTip.getChildren().isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.draw2d.Label comositeLabel = new org.eclipse.draw2d.Label();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.draw2d.FlowLayout fl = new org.eclipse.draw2d.FlowLayout(false);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("fl.setMinorSpacing(0);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("comositeLabel.setLayoutManager(fl);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("comositeLabel.add(toolTip);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("toolTip = comositeLabel;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("toolTip.add(new org.eclipse.draw2d.Label(");
    _builder.newLine();
    {
      GenApplication _application_4 = it.getEditorGen().getApplication();
      boolean _equals_4 = Objects.equal(_application_4, null);
      if (_equals_4) {
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("marker.getAttribute(org.eclipse.core.resources.IMarker.MESSAGE, \"\"),  ");
        CharSequence _nonNLS_7 = this._common.nonNLS(1);
        _builder.append(_nonNLS_7, "\t\t\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("marker.getMessage(),");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("nextImage));");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("severity = (nextSeverity > severity) ? nextSeverity : severity;\t\t\t\t\t");
    _builder.newLine();
    {
      GenApplication _application_5 = it.getEditorGen().getApplication();
      boolean _equals_5 = Objects.equal(_application_5, null);
      if (_equals_5) {
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (foundMarker == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// add decoration");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (editPart instanceof org.eclipse.gef.GraphicalEditPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (view instanceof org.eclipse.gmf.runtime.notation.Edge) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("setDecoration(getDecoratorTarget().addConnectionDecoration(getImage(severity), 50, true));\t\t\t\t\t\t\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("int margin = -1;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (editPart instanceof org.eclipse.gef.GraphicalEditPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("margin = org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil.getMapMode(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("((org.eclipse.gef.GraphicalEditPart) editPart).getFigure()).DPtoLP(margin);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("setDecoration(getDecoratorTarget().addShapeDecoration(getImage(severity),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget.Direction.NORTH_EAST, margin, true));\t\t\t\t\t\t\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("getDecoration().setToolTip(toolTip);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.swt.graphics.Image getImage(int severity) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("String imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_ERROR_TSK;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("switch (severity) {");
    _builder.newLine();
    {
      GenApplication _application_6 = it.getEditorGen().getApplication();
      boolean _equals_6 = Objects.equal(_application_6, null);
      if (_equals_6) {
        _builder.append("\t\t\t");
        _builder.append("case org.eclipse.core.resources.IMarker.SEVERITY_ERROR:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_ERROR_TSK;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("case org.eclipse.core.resources.IMarker.SEVERITY_WARNING:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_WARN_TSK;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
      } else {
        _builder.append("\t\t\t");
        _builder.append("case org.eclipse.core.runtime.IStatus.ERROR:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_ERROR_TSK;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("case org.eclipse.core.runtime.IStatus.WARNING:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_WARN_TSK;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("default:");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("imageName = org.eclipse.ui.ISharedImages.IMG_OBJS_INFO_TSK;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return org.eclipse.ui.PlatformUI.getWorkbench().getSharedImages().getImage(imageName);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void activate() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (viewId == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// add self to global decorators registry");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("java.util.List list = (java.util.List) allDecorators.get(viewId);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (list == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("list = new java.util.ArrayList(2);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("list.add(this);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("allDecorators.put(viewId, list);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else if (!list.contains(this)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("list.add(this);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_7 = it.getEditorGen().getApplication();
      boolean _equals_7 = Objects.equal(_application_7, null);
      if (_equals_7) {
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// start listening to changes in resources");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) getDecoratorTarget().getAdapter(");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View.class);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (view == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagramView = view.getDiagram();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (diagramView == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (fileObserver == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager.getInstance().addFileObserver(");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t");
        _builder.append("fileObserver = new MarkerObserver(diagramView));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_14 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_14, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void deactivate() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (viewId == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// remove self from global decorators registry");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("java.util.List list = (java.util.List) allDecorators.get(viewId);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (list != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("list.remove(this);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (list.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("allDecorators.remove(viewId);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_8 = it.getEditorGen().getApplication();
      boolean _equals_8 = Objects.equal(_application_8, null);
      if (_equals_8) {
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// stop listening to changes in resources if there are no more decorators");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (fileObserver != null && allDecorators.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager.getInstance().removeFileObserver(fileObserver);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("fileObserver = null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("super.deactivate();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_9 = it.getEditorGen().getApplication();
      boolean _equals_9 = Objects.equal(_application_9, null);
      if (_equals_9) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_15 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_15, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("static class MarkerObserver implements org.eclipse.gmf.runtime.common.ui.resources.IFileObserver {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_16 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_16, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.runtime.notation.Diagram diagram;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_17 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_17, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("private MarkerObserver(org.eclipse.gmf.runtime.notation.Diagram diagram) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("this.diagram = diagram;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_18 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_18, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleFileRenamed(org.eclipse.core.resources.IFile oldFile, org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_19 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_19, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleFileMoved(org.eclipse.core.resources.IFile oldFile, org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_20 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_20, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleFileDeleted(org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_21 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_21, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleFileChanged(org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_22 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_22, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleMarkerAdded(org.eclipse.core.resources.IMarker marker) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("if (marker.getAttribute(org.eclipse.gmf.runtime.common.ui.resources.IMarker.ELEMENT_ID, null) != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("handleMarkerChanged(marker);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_23 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_23, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleMarkerDeleted(org.eclipse.core.resources.IMarker marker, java.util.Map attributes) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("String viewId = (String) attributes.get(org.eclipse.gmf.runtime.common.ui.resources.IMarker.ELEMENT_ID);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("refreshDecorators(viewId, diagram);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_24 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_24, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void handleMarkerChanged(org.eclipse.core.resources.IMarker marker) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("if (!MARKER_TYPE.equals(getType(marker))) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("String viewId = marker.getAttribute(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.common.ui.resources.IMarker.ELEMENT_ID, \"\"); ");
        CharSequence _nonNLS_8 = this._common.nonNLS(1);
        _builder.append(_nonNLS_8, "\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("refreshDecorators(viewId, diagram);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _generatedMemberComment_25 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_25, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("private String getType(org.eclipse.core.resources.IMarker marker) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("return marker.getType();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("} catch (org.eclipse.core.runtime.CoreException e) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_9 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName_9, "\t\t\t\t");
        _builder.append(".getInstance().logError(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("\"Validation marker refresh failure\", e); ");
        CharSequence _nonNLS_9 = this._common.nonNLS(1);
        _builder.append(_nonNLS_9, "\t\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("return \"\"; ");
        CharSequence _nonNLS_10 = this._common.nonNLS(1);
        _builder.append(_nonNLS_10, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
