/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.navigator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class DomainNavigatorContentProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private NavigatorContentProvider xptNavigatorContentProvider;
  
  @Inject
  private DomainNavigatorItem xptDomainNavigatorItem;
  
  public CharSequence className(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _domainContentProviderClassName = it.getDomainContentProviderClassName();
    _builder.append(_domainContentProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence DomainNavigatorContentProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" implements org.eclipse.ui.navigator.ICommonContentProvider {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iContentProvider = this.xptNavigatorContentProvider.iContentProvider(it);
    _builder.append(_iContentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iStructuredContentProvider = this.xptNavigatorContentProvider.iStructuredContentProvider(it);
    _builder.append(_iStructuredContentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iMementoAware = this.xptNavigatorContentProvider.iMementoAware(it);
    _builder.append(_iMementoAware, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iCommonContentProvider = this.xptNavigatorContentProvider.iCommonContentProvider(it);
    _builder.append(_iCommonContentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iTreeContentProvider = this.iTreeContentProvider(it);
    _builder.append(_iTreeContentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider myAdapterFctoryContentProvier;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _attributes = this.xptNavigatorContentProvider.attributes(it);
    _builder.append(_attributes);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence constructor(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("myAdapterFctoryContentProvier = new org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().getItemProvidersAdapterFactory());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _initCommonAttributes = this.xptNavigatorContentProvider.initCommonAttributes(it);
    _builder.append(_initCommonAttributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence iTreeContentProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _children = this.getChildren(it);
    _builder.append(_children);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _wrapEObjects = this.wrapEObjects(it);
    _builder.append(_wrapEObjects);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _parent = this.xptNavigatorContentProvider.getParent(it);
    _builder.append(_parent);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _hasChildren = this.xptNavigatorContentProvider.hasChildren(it);
    _builder.append(_hasChildren);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getChildren(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public Object[] getChildren(Object parentElement) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (parentElement instanceof org.eclipse.core.resources.IFile) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _fileResource = this.xptNavigatorContentProvider.getFileResource(it);
    _builder.append(_fileResource, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return wrapEObjects(myAdapterFctoryContentProvier.getChildren(resource), parentElement);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (parentElement instanceof ");
    CharSequence _qualifiedClassName = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return wrapEObjects(myAdapterFctoryContentProvier.getChildren(((");
    CharSequence _qualifiedClassName_1 = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(") parentElement).getEObject()), parentElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _otherChildren = this.getOtherChildren(it);
    _builder.append(_otherChildren, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getOtherChildren(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return EMPTY_ARRAY;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence wrapEObjects(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public Object[] wrapEObjects(Object[] objects, Object parentElement) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.Collection result = new java.util.ArrayList();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (int i = 0; i < objects.length; i++) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (objects[i] instanceof org.eclipse.emf.ecore.EObject) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result.add(new ");
    CharSequence _qualifiedClassName = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append("((org.eclipse.emf.ecore.EObject) objects[i], parentElement, myAdapterFctoryContentProvier));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return result.toArray();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
