/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - API extracted to GMF-T runtime, migrated to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.expressions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class OCLExpressionFactory {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private AbstractExpression xptAbstractExpression;
  
  public CharSequence className(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    String _expressionsPackageName = it.getContainer().getExpressionsPackageName();
    _builder.append(_expressionsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence OCLExpressionFactory(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getContainer().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initInterpreterFactory = this.initInterpreterFactory(it);
    _builder.append(_initInterpreterFactory, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("This is factory method, callers are responsible to keep reference to the return value if they want to reuse parsed expression");
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static ");
    CharSequence _qualifiedClassName = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" getExpression(String body, org.eclipse.emf.ecore.EClassifier context, java.util.Map<String, org.eclipse.emf.ecore.EClassifier> environment) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return new Expression(body, context, environment);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("This method will become private in the next release");
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static ");
    CharSequence _qualifiedClassName_1 = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(" getExpression(String body, org.eclipse.emf.ecore.EClassifier context) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return getExpression(body, context, java.util.Collections.<String, org.eclipse.emf.ecore.EClassifier>emptyMap());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static class Expression extends ");
    CharSequence _qualifiedClassName_2 = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private final org.eclipse.ocl.ecore.OCL oclInstance;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.ocl.ecore.OCLExpression oclExpression;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public Expression(String body, org.eclipse.emf.ecore.EClassifier context, java.util.Map<String, org.eclipse.emf.ecore.EClassifier> environment) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super(body, context);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("oclInstance = org.eclipse.ocl.ecore.OCL.newInstance();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("initCustomEnv(oclInstance.getEnvironment(), environment);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ocl.ecore.OCL.Helper oclHelper = oclInstance.createOCLHelper();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("oclHelper.setContext(context());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("oclExpression = oclHelper.createQuery(body());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setStatus(org.eclipse.core.runtime.IStatus.OK, null, null);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} catch (org.eclipse.ocl.ParserException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setStatus(org.eclipse.core.runtime.IStatus.ERROR, e.getMessage(), e);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("@SuppressWarnings(\"rawtypes\")");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("protected Object doEvaluate(Object context, java.util.Map env) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (oclExpression == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// on the first call, both evalEnvironment and extentMap are clear, for later we have finally, below.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ocl.EvaluationEnvironment<?,?,?,?,?>  evalEnv = oclInstance.getEvaluationEnvironment();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// initialize environment");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (Object nextKey : env.keySet()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("evalEnv.replace((String) nextKey, env.get(nextKey));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Object result = oclInstance.evaluate(context, oclExpression);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return oclInstance.isInvalid(result) ? null : result;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} finally {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("evalEnv.clear();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("oclInstance.setExtentMap(null); // clear allInstances cache, and get the oclInstance ready for the next call");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private static void initCustomEnv(org.eclipse.ocl.Environment<?,org.eclipse.emf.ecore.EClassifier,?,?,?,org.eclipse.emf.ecore.EParameter,?,?,?,?,?,?> ecoreEnv, java.util.Map<String, org.eclipse.emf.ecore.EClassifier> environment) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _initializeEnvironment = this.initializeEnvironment(it, "ecoreEnv");
    _builder.append(_initializeEnvironment, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("for (String varName : environment.keySet()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EClassifier varType = environment.get(varName);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("ecoreEnv.addElement(varName, createVar(ecoreEnv, varName, varType), false);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private static org.eclipse.ocl.ecore.Variable createVar(org.eclipse.ocl.Environment<?,org.eclipse.emf.ecore.EClassifier,?,?,?,?,?,?,?,?,?,?> ecoreEnv, String name, org.eclipse.emf.ecore.EClassifier type) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ocl.ecore.Variable var = org.eclipse.ocl.ecore.EcoreFactory.eINSTANCE.createVariable();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("var.setName(name);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("var.setType(ecoreEnv.getUMLReflection().getOCLType(type));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return var;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Clients may override if they don't need
   */
  public CharSequence initializeEnvironment(final GenExpressionInterpreter it, final String environmentVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Use EObject as implicit root class for any object, to allow eContainer() and other EObject operations from OCL expressions");
    _builder.newLine();
    _builder.append("org.eclipse.ocl.options.ParsingOptions.setOption(");
    _builder.append(environmentVar);
    _builder.append(", org.eclipse.ocl.options.ParsingOptions.implicitRootClass(");
    _builder.append(environmentVar);
    _builder.append("), org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEObject());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additions(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  /**
   * just to avoid identical piece of template in the RegexpExpressionFactory
   */
  public CharSequence initInterpreterFactory(final GenExpressionInterpreter it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private final ");
    CharSequence _qualifiedClassName = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append("[] expressions; ");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private final String [] expressionBodies;\t");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    String _className = it.getClassName();
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.expressions = new ");
    CharSequence _qualifiedClassName_1 = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append("[");
    int _size = it.getExpressions().size();
    _builder.append(_size, "\t");
    _builder.append("];");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.expressionBodies = new String[] {");
    _builder.newLine();
    {
      EList<ValueExpression> _expressions = it.getExpressions();
      for(final ValueExpression e : _expressions) {
        _builder.append("\t\t\t");
        String _bodyString = e.getBodyString();
        _builder.append(_bodyString, "\t\t\t");
        _builder.append(", ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3);
    _builder.newLineIfNotEmpty();
    _builder.append("private static ");
    String _className_1 = it.getClassName();
    _builder.append(_className_1);
    _builder.append(" getInstance() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _className_2 = it.getClassName();
    _builder.append(_className_2, "\t");
    _builder.append(" instance = ");
    CharSequence _instanceAccess = this.xptActivator.instanceAccess(it.getContainer().getEditorGen());
    _builder.append(_instanceAccess, "\t");
    _builder.append(".get");
    String _className_3 = it.getClassName();
    _builder.append(_className_3, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (instance == null) {\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _instanceAccess_1 = this.xptActivator.instanceAccess(it.getContainer().getEditorGen());
    _builder.append(_instanceAccess_1, "\t\t");
    _builder.append(".set");
    String _className_4 = it.getClassName();
    _builder.append(_className_4, "\t\t");
    _builder.append("(instance = new ");
    String _className_5 = it.getClassName();
    _builder.append(_className_5, "\t\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return instance;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String getExpressionBody(int index) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getInstance().expressionBodies[index];");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5);
    _builder.newLineIfNotEmpty();
    _builder.append("public static ");
    CharSequence _qualifiedClassName_2 = this.xptAbstractExpression.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_2);
    _builder.append(" getExpression(int index, org.eclipse.emf.ecore.EClassifier context, java.util.Map<String, org.eclipse.emf.ecore.EClassifier> environment) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _className_6 = it.getClassName();
    _builder.append(_className_6, "\t");
    _builder.append(" cached = getInstance();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (index < 0 || index >= cached.expressions.length) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new IllegalArgumentException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (cached.expressions[index] == null) {\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("cached.expressions[index] = getExpression(cached.expressionBodies[index], context, environment == null ? java.util.Collections.<String, org.eclipse.emf.ecore.EClassifier>emptyMap() : environment);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return cached.expressions[index];");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
