/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class GenDiagram_qvto {
  public boolean standaloneDomainModel(final GenDiagram genDiagram) {
    return ((!genDiagram.getEditorGen().isSameFileForDiagramAndModel()) && (!Objects.equal(genDiagram.getDomainDiagramElement(), null)));
  }
  
  public boolean hasDocumentRoot(final GenDiagram genDiagram) {
    GenClass _documentRoot = this.getDocumentRoot(genDiagram);
    return (!Objects.equal(_documentRoot, null));
  }
  
  public GenClass getDocumentRoot(final GenDiagram genDiagram) {
    GenClass _domainDiagramElement = genDiagram.getDomainDiagramElement();
    boolean _equals = Objects.equal(_domainDiagramElement, null);
    if (_equals) {
      return null;
    }
    return genDiagram.getDomainDiagramElement().getGenPackage().getDocumentRoot();
  }
  
  public GenFeature getDocumentRootSetFeature(final GenDiagram genDiagram) {
    GenClass root = this.getDocumentRoot(genDiagram);
    boolean _equals = Objects.equal(root, null);
    if (_equals) {
      return null;
    }
    final Function1<GenFeature, Boolean> _function = new Function1<GenFeature, Boolean>() {
      @Override
      public Boolean apply(final GenFeature f) {
        return Boolean.valueOf(GenDiagram_qvto.this.isDocRootSetFeature(f, genDiagram.getDomainDiagramElement().getEcoreClass()));
      }
    };
    return IterableExtensions.<GenFeature>findFirst(root.getGenFeatures(), _function);
  }
  
  public boolean isDocRootSetFeature(final GenFeature gf, final EClass eType) {
    return ((((((!gf.isListType()) && 
      (!Objects.equal(gf.getEcoreFeature(), null))) && 
      gf.getEcoreFeature().isChangeable()) && 
      (gf.getEcoreFeature().getUpperBound() == ETypedElement.UNSPECIFIED_MULTIPLICITY)) && 
      Objects.equal(gf.getEcoreFeature().eClass().getName(), "EReference")) && 
      ((EClass) gf.getEcoreFeature().getEType()).isSuperTypeOf(eType));
  }
}
