/**
 * Copyright (c) 2007-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Dmitry Stadnik (Borland) - creation logic was moved in commands
 *    Michael Golubev (Borland) - [243151] explicit source/target for links
 *    							- #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.QualifiedClassNameProvider;
import xpt.diagram.commands.ReorientLinkCommand;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

/**
 * Start  		start of link creation.
 * 				User click to this editpart and start dragging with link tool.
 * Complete 	end of the command
 * 				User points to this editpart as a link target and release mouse button.
 * 
 * Outgoing 	the node is link source
 * 				This element could be a source for this type of link.
 * Incoming		the node is link destination
 * 				This element could be a target for this type of link.
 * 
 * Parameters:
 * 
 * 	diagram 	GenDiagram used to collect all defined links
 * 
 * 	this		Instance of GenLinkEnd for the element link could be creates to/from.
 * 				This could be GenNode or GenLink in case of links to links,
 *              in the latter case it is assumed that its a TypeLink (so its model facet is LinkTypeModelFacet),
 *              because RefLinks don't have underlying semantic identity
 */
@Singleton
@SuppressWarnings("all")
public class linkCommands {
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private ReorientLinkCommand xptReorientLinkCommand;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  public CharSequence aaa() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("aaa");
    return _builder;
  }
  
  public CharSequence linkCommands(final GenLinkEnd it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = IterableExtensions.size(this._utils_qvto.getAllPotentialLinks(it));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _createLinkCommands = this.createLinkCommands(it);
        _builder.append(_createLinkCommands);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      int _size_1 = IterableExtensions.size(this._utils_qvto.getReroutableTypeLinks(it));
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        CharSequence _reorientTypeLinkCommands = this.reorientTypeLinkCommands(it);
        _builder.append(_reorientTypeLinkCommands);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      int _size_2 = IterableExtensions.size(this._utils_qvto.getReroutableRefLinks(it));
      boolean _greaterThan_2 = (_size_2 > 0);
      if (_greaterThan_2) {
        CharSequence _reorientRefLinkCommands = this.reorientRefLinkCommands(it);
        _builder.append(_reorientRefLinkCommands);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence createLinkCommands(final GenLinkEnd it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gef.commands.Command command = req.getTarget() == null ?");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getStartCreateRelationshipCommand(req) : getCompleteCreateRelationshipCommand(req);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return command != null ? command : super.getCreateRelationshipCommand(req);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getStartCreateRelationshipCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest req) {");
    _builder.newLine();
    {
      Iterable<GenLink> _allPotentialLinks = this._utils_qvto.getAllPotentialLinks(it);
      for(final GenLink l : _allPotentialLinks) {
        _builder.append("\t");
        CharSequence _startLinkCommands = this.startLinkCommands(l, it);
        _builder.append(_startLinkCommands, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getCompleteCreateRelationshipCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest req) {");
    _builder.newLine();
    {
      Iterable<GenLink> _allPotentialLinks_1 = this._utils_qvto.getAllPotentialLinks(it);
      for(final GenLink l_1 : _allPotentialLinks_1) {
        _builder.append("\t");
        CharSequence _completeLinkCommands = this.completeLinkCommands(l_1, it);
        _builder.append(_completeLinkCommands, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence startLinkCommands(final GenLink it, final GenLinkEnd linkEnd) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(it);
    _builder.append(_accessElementType);
    _builder.append(" == req.getElementType()) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _createStartLinkCommand = this._utils_qvto.createStartLinkCommand(it, linkEnd);
      if (_createStartLinkCommand) {
        _builder.append("\t");
        _builder.append("return getGEFWrapper(new ");
        CharSequence _createCommandQualifiedClassName = this._qualifiedClassNameProvider.getCreateCommandQualifiedClassName(it);
        _builder.append(_createCommandQualifiedClassName, "\t");
        _builder.append("(req,");
        _builder.newLineIfNotEmpty();
        {
          boolean _createStartIncomingLinkCommand = this._utils_qvto.createStartIncomingLinkCommand(it, linkEnd);
          if (_createStartIncomingLinkCommand) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("req.getTarget(), req.getSource()");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("req.getSource(), req.getTarget()");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("));");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence completeLinkCommands(final GenLink it, final GenLinkEnd linkEnd) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(it);
    _builder.append(_accessElementType);
    _builder.append(" == req.getElementType()) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _createCompleteLinkCommand = this._utils_qvto.createCompleteLinkCommand(it, linkEnd);
      if (_createCompleteLinkCommand) {
        _builder.append("\t");
        _builder.append("return getGEFWrapper(new ");
        CharSequence _createCommandQualifiedClassName = this._qualifiedClassNameProvider.getCreateCommandQualifiedClassName(it);
        _builder.append(_createCommandQualifiedClassName, "\t");
        _builder.append("(req,");
        _builder.newLineIfNotEmpty();
        {
          boolean _createCompleteOutgoingLinkCommand = this._utils_qvto.createCompleteOutgoingLinkCommand(it, linkEnd);
          if (_createCompleteOutgoingLinkCommand) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("req.getTarget(), req.getSource()");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("req.getSource(), req.getTarget()");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("));");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence reorientTypeLinkCommands(final GenLinkEnd it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      ("Returns command to reorient EClass based link. New link target or source\n" + 
        "should be the domain model element associated with this node.\n"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getReorientRelationshipCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("switch (getVisualID(req)) {");
    _builder.newLine();
    {
      Iterable<GenLink> _reroutableTypeLinks = this._utils_qvto.getReroutableTypeLinks(it);
      for(final GenLink l : _reroutableTypeLinks) {
        _builder.append("\t");
        CharSequence _reorientLinkCommand = this.reorientLinkCommand(l);
        _builder.append(_reorientLinkCommand, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getReorientRelationshipCommand(req);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence reorientRefLinkCommands(final GenLinkEnd it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      ("Returns command to reorient EReference based link. New link target or source\n" + 
        "should be the domain model element associated with this node.\n"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getReorientReferenceRelationshipCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("switch (getVisualID(req)) {");
    _builder.newLine();
    {
      Iterable<GenLink> _reroutableRefLinks = this._utils_qvto.getReroutableRefLinks(it);
      for(final GenLink l : _reroutableRefLinks) {
        _builder.append("\t");
        CharSequence _reorientLinkCommand = this.reorientLinkCommand(l);
        _builder.append(_reorientLinkCommand, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getReorientReferenceRelationshipCommand(req);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence reorientLinkCommand(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
    _builder.append(_caseVisualID);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return getGEFWrapper(new ");
    CharSequence _qualifiedClassName = this.xptReorientLinkCommand.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("(req));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
