/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.QualifiedClassNameProvider;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class childContainerCreateCommand {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  public CharSequence childContainerCreateCommand(final Iterable<? extends GenNode> nodes) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(nodes);
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req) {");
        _builder.newLine();
        {
          for(final GenNode n : nodes) {
            CharSequence _childNodeCreateCommand = this.childNodeCreateCommand(n);
            _builder.append(_childNodeCreateCommand);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return super.getCreateCommand(req);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence childNodeCreateCommand(final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(node);
    _builder.append(_accessElementType);
    _builder.append(" == req.getElementType()) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return getGEFWrapper(new ");
    CharSequence _createCommandQualifiedClassName = this._qualifiedClassNameProvider.getCreateCommandQualifiedClassName(node);
    _builder.append(_createCommandQualifiedClassName, "\t");
    _builder.append("(req));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
