/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class GenEditorGenerator_qvto {
  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;
  
  /**
   * FIXME remove java-only GenEditorGenerator#hasAudits or declare it in metamodel
   */
  public boolean hasAudits(final GenEditorGenerator editorGen) {
    return ((!Objects.equal(editorGen.getAudits(), null)) && (!editorGen.getAudits().getRules().isEmpty()));
  }
  
  /**
   * @see GenModelUtils#jdkComplianceLevel
   */
  public int jdkComplianceLevel(final GenEditorGenerator xptSelf) {
    return this._genModelUtils_qvto.jdkComplianceLevel(xptSelf.getDiagram().getDomainDiagramElement());
  }
  
  public int jdkComplianceLevel(final GenCommonBase xptSelf) {
    return this.jdkComplianceLevel(xptSelf.getDiagram().getEditorGen());
  }
}
