/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.preferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class StandardPage {
  @Inject
  @Extension
  private Common _common;
  
  public CharSequence className(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _preferencesPackageName = it.getDiagram().getPreferencesPackageName();
    _builder.append(_preferencesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setPreferenceStore(");
    String _activatorQualifiedClassName = it.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
    _builder.append(_activatorQualifiedClassName, "\t\t");
    _builder.append(".getInstance().getPreferenceStore());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      StandardPreferencePages _kind = it.getKind();
      boolean _equals = Objects.equal(_kind, StandardPreferencePages.GENERAL_LITERAL);
      if (_equals) {
        _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.DiagramsPreferencePage");
        _builder.newLine();
      } else {
        StandardPreferencePages _kind_1 = it.getKind();
        boolean _equals_1 = Objects.equal(_kind_1, StandardPreferencePages.APPEARANCE_LITERAL);
        if (_equals_1) {
          _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.AppearancePreferencePage");
          _builder.newLine();
        } else {
          StandardPreferencePages _kind_2 = it.getKind();
          boolean _equals_2 = Objects.equal(_kind_2, StandardPreferencePages.CONNECTIONS_LITERAL);
          if (_equals_2) {
            _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.ConnectionsPreferencePage");
            _builder.newLine();
          } else {
            StandardPreferencePages _kind_3 = it.getKind();
            boolean _equals_3 = Objects.equal(_kind_3, StandardPreferencePages.PRINTING_LITERAL);
            if (_equals_3) {
              _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.PrintingPreferencePage");
              _builder.newLine();
            } else {
              StandardPreferencePages _kind_4 = it.getKind();
              boolean _equals_4 = Objects.equal(_kind_4, StandardPreferencePages.RULERS_AND_GRID_LITERAL);
              if (_equals_4) {
                _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.RulerGridPreferencePage");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence implementsList(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @MetaDef
  public CharSequence call_initDefaults(final GenStandardPreferencePage it, final String storeVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      StandardPreferencePages _kind = it.getKind();
      boolean _notEquals = (!Objects.equal(_kind, StandardPreferencePages.PATHMAPS_LITERAL));
      if (_notEquals) {
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append(_qualifiedClassName);
        _builder.append(".initDefaults(");
        _builder.append(storeVarName);
        _builder.append(");");
      }
    }
    return _builder;
  }
}
