/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.viewmaps.modeledViewmapProducer;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.papyrus.gmf.gmfgraph.Compartment;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editparts.EditPartFactory;
import xpt.diagram.editparts.Utils_qvto;
import xpt.diagram.editpolicies.GraphicalNodeEditPolicy;
import xpt.diagram.editpolicies.TextSelectionEditPolicy;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class NodeEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private xpt.diagram.Utils_qvto _utils_qvto_1;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private modeledViewmapProducer xptModeledViewmapProducer;
  
  @Inject
  private TextAware xptTextAware;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private GraphicalNodeEditPolicy graphicalEditPolicy;
  
  @Inject
  private TextSelectionEditPolicy textSelection;
  
  @Inject
  private EditPartFactory xptEditPartFactory;
  
  public CharSequence className(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  protected CharSequence _extendsListContents(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart");
      } else {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _extendsListContents(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart");
      } else {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence constructor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPoliciesBody(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _installCreationRolePolicy = this.installCreationRolePolicy(it);
    _builder.append(_installCreationRolePolicy);
    _builder.newLineIfNotEmpty();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    CharSequence _installPrimaryDragEditPolicy = this.installPrimaryDragEditPolicy(it);
    _builder.append(_installPrimaryDragEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy(it);
    _builder.append(_installSemanticEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _installGraphicalNodeEditPolicy = this.installGraphicalNodeEditPolicy(it);
    _builder.append(_installGraphicalNodeEditPolicy);
    _builder.newLineIfNotEmpty();
    {
      boolean _isEmpty = it.getChildNodes().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.DRAG_DROP_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installCanonicalEditPolicy = this.xptEditpartsCommon.installCanonicalEditPolicy(it);
    _builder.append(_installCanonicalEditPolicy);
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());");
    _builder.newLine();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    _builder.append("// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies");
    _builder.newLine();
    _builder.append("// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);");
    _builder.newLine();
    CharSequence _additionalEditPolicies = this.additionalEditPolicies(it);
    _builder.append(_additionalEditPolicies);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additionalEditPolicies(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence installGraphicalNodeEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _needsGraphicalNodeEditPolicy = this._utils_qvto.needsGraphicalNodeEditPolicy(it);
      if (_needsGraphicalNodeEditPolicy) {
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.GRAPHICAL_NODE_ROLE, new ");
        CharSequence _qualifiedClassName = this.graphicalEditPolicy.qualifiedClassName(it);
        _builder.append(_qualifiedClassName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence installCreationRolePolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!it.getChildNodes().isEmpty()) || this._utils_qvto.hasChildrenInListCompartments(it))) {
        CharSequence _installCreationEditPolicy = this.xptEditpartsCommon.installCreationEditPolicy(it);
        _builder.append(_installCreationEditPolicy);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _installPrimaryDragEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _installPrimaryDragEditPolicy(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, getPrimaryDragEditPolicy());");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.editpolicies.LayoutEditPolicy createLayoutEditPolicy() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createLayoutEditPolicyBody = this.createLayoutEditPolicyBody(it);
    _builder.append(_createLayoutEditPolicyBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicyBody(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ViewmapLayoutType _layoutType = it.getLayoutType();
      boolean _equals = Objects.equal(ViewmapLayoutType.XY_LAYOUT_LITERAL, _layoutType);
      if (_equals) {
        CharSequence _createLayoutEditPolicyBody_XY_LAYOUT = this.createLayoutEditPolicyBody_XY_LAYOUT(it);
        _builder.append(_createLayoutEditPolicyBody_XY_LAYOUT);
        _builder.newLineIfNotEmpty();
      } else {
        ViewmapLayoutType _layoutType_1 = it.getLayoutType();
        boolean _equals_1 = Objects.equal(ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL, _layoutType_1);
        if (_equals_1) {
          CharSequence _extraLineBreak = this._common.extraLineBreak();
          _builder.append(_extraLineBreak);
          _builder.newLineIfNotEmpty();
          CharSequence _createLayoutEditPolicyBody_TOOLBAR_LAYOUT = this.createLayoutEditPolicyBody_TOOLBAR_LAYOUT(it);
          _builder.append(_createLayoutEditPolicyBody_TOOLBAR_LAYOUT);
          _builder.newLineIfNotEmpty();
        } else {
          ViewmapLayoutType _layoutType_2 = it.getLayoutType();
          boolean _equals_2 = Objects.equal(ViewmapLayoutType.FLOW_LAYOUT_LITERAL, _layoutType_2);
          if (_equals_2) {
            CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
            _builder.append(_extraLineBreak_1);
            _builder.newLineIfNotEmpty();
            CharSequence _createLayoutEditPolicyBody_FLOW_LAYOUT = this.createLayoutEditPolicyBody_FLOW_LAYOUT(it);
            _builder.append(_createLayoutEditPolicyBody_FLOW_LAYOUT);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _createLayoutEditPolicyBody_DEFAULT = this.createLayoutEditPolicyBody_DEFAULT(it);
            _builder.append(_createLayoutEditPolicyBody_DEFAULT);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicyBody_XY_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.EditPolicy result = super.createChildEditPolicy(child);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (result == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicyBody_TOOLBAR_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE) == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (child instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return new ");
    CharSequence _qualifiedClassName = this.textSelection.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName, "\t\t\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.createChildEditPolicy(child);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicyBody_FLOW_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy() {");
    _builder.newLine();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
        _builder.append(_borderItemSelectionEditPolicy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return super.createChildEditPolicy(child);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command createAddCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command createMoveChildCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createLayoutEditPolicyBody_DEFAULT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.EditPolicy result = child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (result == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result = new org.eclipse.gef.editpolicies.NonResizableEditPolicy();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getMoveChildrenCommand(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence borderItemSelectionEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("org.eclipse.gmf.runtime.notation.View childView = (org.eclipse.gmf.runtime.notation.View) child.getModel();");
        _builder.newLine();
        _builder.append("switch (");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getDiagram());
        _builder.append(_visualIDMethodCall);
        _builder.append("(childView)) {");
        _builder.newLineIfNotEmpty();
        {
          boolean _isEmpty = IterableExtensions.isEmpty(this._utils_qvto.getExternalLabels(it));
          boolean _not = (!_isEmpty);
          if (_not) {
            {
              Iterable<GenExternalNodeLabel> _externalLabels = this._utils_qvto.getExternalLabels(it);
              for(final GenExternalNodeLabel nextLabel : _externalLabels) {
                CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(nextLabel);
                _builder.append(_caseVisualID);
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("return ");
            CharSequence _borderItemSelectionEP = this.borderItemSelectionEP(it);
            _builder.append(_borderItemSelectionEP, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          boolean _isEmpty_1 = IterableExtensions.isEmpty(this._utils_qvto.getSideAffixedChildren(it));
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            {
              Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
              for(final GenChildSideAffixedNode nextBorderItem : _sideAffixedChildren) {
                CharSequence _caseVisualID_1 = this.xptVisualIDRegistry.caseVisualID(nextBorderItem);
                _builder.append(_caseVisualID_1);
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy();");
            _builder.newLine();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence borderItemSelectionEP(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected java.util.List createSelectionHandles() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.handles.MoveHandle mh = new org.eclipse.gef.handles.MoveHandle((org.eclipse.gef.GraphicalEditPart) getHost());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("mh.setBorder(null);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return java.util.Collections.singletonList(mh);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * FIXME:
   * 1. single generation of createNodeShape(), with inner body filled by polymorphic initPrimaryShape, same as in Lite RT
   * 2. getPrimaryShape() for SnippetViewmap. Other templates use it regardless of Viewmap kind, perhaps need to add className to SnippetViewmap (with IFigure being default?)
   * 3. Common (single and shared with Lite RT) condition when to force useLocalConstraints. Lite checks for compartments isEmpty, shouldn't we do the same?
   */
  protected CharSequence _createNodeShape(final Viewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unknown viewmap: " + it) + " for node: ") + node));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _createNodeShape(final ModeledViewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return primaryShape = new ");
    CharSequence _modeledViewmapFigureFQN = this.modeledViewmapFigureFQN(it);
    _builder.append(_modeledViewmapFigureFQN, "\t");
    _builder.append("()");
    CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
    _builder.append(_forceUseLocalCoordinatesAnonymousClassBody, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _modeledViewmapFigureFQN_1 = this.modeledViewmapFigureFQN(it);
    _builder.append(_modeledViewmapFigureFQN_1);
    _builder.append(" getPrimaryShape() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return (");
    CharSequence _modeledViewmapFigureFQN_2 = this.modeledViewmapFigureFQN(it);
    _builder.append(_modeledViewmapFigureFQN_2, "\t");
    _builder.append(") primaryShape;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence modeledViewmapFigureFQN(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _viewmapFigureFQN = this.xptModeledViewmapProducer.viewmapFigureFQN(it);
    _builder.append(_viewmapFigureFQN);
    return _builder;
  }
  
  protected CharSequence _createNodeShape(final FigureViewmap it, final GenNode node) {
    CharSequence _xblockexpression = null;
    {
      String _xifexpression = null;
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _equals = Objects.equal(_figureQualifiedClassName, null);
      if (_equals) {
        _xifexpression = "org.eclipse.draw2d.RectangleFigure";
      } else {
        _xifexpression = it.getFigureQualifiedClassName();
      }
      String fqn = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _generatedMemberComment = this._common.generatedMemberComment();
      _builder.append(_generatedMemberComment);
      _builder.newLineIfNotEmpty();
      _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("return primaryShape = new ");
      _builder.append(fqn, "\t");
      _builder.append("()");
      CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
      _builder.append(_forceUseLocalCoordinatesAnonymousClassBody, "\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(fqn);
      _builder.append(_primaryShapeMethod);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence _createNodeShape(final SnippetViewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _body = it.getBody();
    _builder.append(_body, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _createNodeShape(final InnerClassViewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return primaryShape = new ");
    String _className = it.getClassName();
    _builder.append(_className, "\t");
    _builder.append("()");
    CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
    _builder.append(_forceUseLocalCoordinatesAnonymousClassBody, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(it.getClassName());
    _builder.append(_primaryShapeMethod);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence forceUseLocalCoordinatesAnonymousClassBody(final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!node.getChildNodes().isEmpty()) && Objects.equal(node.getLayoutType(), ViewmapLayoutType.XY_LAYOUT_LITERAL))) {
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected boolean useLocalCoordinates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence getPrimaryShapeMethod(final String fqn) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(fqn);
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    _builder.append(fqn);
    _builder.append(" getPrimaryShape() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return (");
    _builder.append(fqn, "\t");
    _builder.append(") primaryShape;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addFixedChild(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean addFixedChild(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    {
      Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
      for(final GenLabel label : _innerFixedLabels) {
        Viewmap _viewmap = label.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("((");
        Object _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName_1, "\t");
        _builder.append(") childEditPart).");
        CharSequence _labelSetterName = this.xptTextAware.labelSetterName(childViewmap);
        _builder.append(_labelSetterName, "\t");
        _builder.append("(getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      Iterable<? extends GenLabel> _innerFixedLabelsWithModeledViewmaps = this._utils_qvto.getInnerFixedLabelsWithModeledViewmaps(it);
      for(final GenLabel label_1 : _innerFixedLabelsWithModeledViewmaps) {
        Viewmap _viewmap_1 = label_1.getViewmap();
        ModeledViewmap childViewmap_1 = ((ModeledViewmap) _viewmap_1);
        _builder.newLineIfNotEmpty();
        EObject _figureModel = childViewmap_1.getFigureModel();
        String getterName = ((DiagramLabel) _figureModel).getAccessor().getAccessor();
        _builder.newLineIfNotEmpty();
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_2 = this.xptEditPartFactory.getEditPartQualifiedClassName(label_1);
        _builder.append(_editPartQualifiedClassName_2);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("((");
        Object _editPartQualifiedClassName_3 = this.xptEditPartFactory.getEditPartQualifiedClassName(label_1);
        _builder.append(_editPartQualifiedClassName_3, "\t");
        _builder.append(") childEditPart).");
        CharSequence _labelSetterName_1 = this.xptTextAware.labelSetterName(childViewmap_1);
        _builder.append(_labelSetterName_1, "\t");
        _builder.append("(getPrimaryShape().");
        _builder.append(getterName, "\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        Viewmap _viewmap_2 = compartment.getViewmap();
        ParentAssignedViewmap childViewmap_2 = ((ParentAssignedViewmap) _viewmap_2);
        _builder.newLineIfNotEmpty();
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_4 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_4);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        String _getterName_1 = childViewmap_2.getGetterName();
        _builder.append(_getterName_1, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pane.add(((");
        Object _editPartQualifiedClassName_5 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_5, "\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartmentsWithModeledViewmaps = this._utils_qvto.getPinnedCompartmentsWithModeledViewmaps(it);
      for(final GenCompartment compartment_1 : _pinnedCompartmentsWithModeledViewmaps) {
        Viewmap _viewmap_3 = compartment_1.getViewmap();
        ModeledViewmap childViewmap_3 = ((ModeledViewmap) _viewmap_3);
        _builder.newLineIfNotEmpty();
        EObject _figureModel_1 = childViewmap_3.getFigureModel();
        String getterName_1 = ((Compartment) _figureModel_1).getAccessor().getAccessor();
        _builder.newLineIfNotEmpty();
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_6 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment_1);
        _builder.append(_editPartQualifiedClassName_6);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        _builder.append(getterName_1, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pane.add(((");
        Object _editPartQualifiedClassName_7 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment_1);
        _builder.append(_editPartQualifiedClassName_7, "\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
      for(final GenChildSideAffixedNode child : _sideAffixedChildren) {
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_8 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_8);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.");
        String _preferredSideName = child.getPreferredSideName();
        _builder.append(_preferredSideName, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("getBorderedFigure().getBorderItemContainer().add(((");
        Object _editPartQualifiedClassName_9 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_9, "\t");
        _builder.append(") childEditPart).getFigure(), locator);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence removeFixedChild(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean removeFixedChild(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    {
      Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
      for(final GenLabel label : _innerFixedLabels) {
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      Iterable<? extends GenLabel> _innerFixedLabelsWithModeledViewmaps = this._utils_qvto.getInnerFixedLabelsWithModeledViewmaps(it);
      for(final GenLabel label_1 : _innerFixedLabelsWithModeledViewmaps) {
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName(label_1);
        _builder.append(_editPartQualifiedClassName_1);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        Viewmap _viewmap = compartment.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_2 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_2, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("pane.remove(((");
        Object _editPartQualifiedClassName_3 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_3, "\t\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartmentsWithModeledViewmaps = this._utils_qvto.getPinnedCompartmentsWithModeledViewmaps(it);
      for(final GenCompartment compartment_1 : _pinnedCompartmentsWithModeledViewmaps) {
        Viewmap _viewmap_1 = compartment_1.getViewmap();
        ModeledViewmap childViewmap_1 = ((ModeledViewmap) _viewmap_1);
        _builder.newLineIfNotEmpty();
        EObject _figureModel = childViewmap_1.getFigureModel();
        String getterName = ((Compartment) _figureModel).getAccessor().getAccessor();
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_4 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment_1);
        _builder.append(_editPartQualifiedClassName_4, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        _builder.append(getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("pane.remove(((");
        Object _editPartQualifiedClassName_5 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment_1);
        _builder.append(_editPartQualifiedClassName_5, "\t\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
      for(final GenChildSideAffixedNode child : _sideAffixedChildren) {
        _builder.append("if (childEditPart instanceof ");
        Object _editPartQualifiedClassName_6 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_6);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("getBorderedFigure().getBorderItemContainer().remove(((");
        Object _editPartQualifiedClassName_7 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_7, "\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addChildVisual(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void addChildVisual(org.eclipse.gef.EditPart childEditPart, int index) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (addFixedChild(childEditPart)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.addChildVisual(childEditPart, -1);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence removeChildVisual(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void removeChildVisual(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (removeFixedChild(childEditPart)){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.removeChildVisual(childEditPart);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContentPaneFor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure getContentPaneFor(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart editPart) {");
    _builder.newLine();
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        _builder.append("\t");
        Viewmap _viewmap = compartment.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (editPart instanceof ");
        Object _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartmentsWithModeledViewmaps = this._utils_qvto.getPinnedCompartmentsWithModeledViewmaps(it);
      for(final GenCompartment compartment_1 : _pinnedCompartmentsWithModeledViewmaps) {
        _builder.append("\t");
        Viewmap _viewmap_1 = compartment_1.getViewmap();
        ModeledViewmap childViewmap_1 = ((ModeledViewmap) _viewmap_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        EObject _figureModel = childViewmap_1.getFigureModel();
        String getterName = ((Compartment) _figureModel).getAccessor().getAccessor();
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (editPart instanceof ");
        Object _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment_1);
        _builder.append(_editPartQualifiedClassName_1, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getPrimaryShape().");
        _builder.append(getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getBorderedFigure().getBorderItemContainer();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return getContentPane();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addBorderItem(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(this._utils_qvto.getExternalLabels(it));
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addBorderItem(org.eclipse.draw2d.IFigure borderItemContainer, org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart borderItemEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (");
        {
          Iterable<GenExternalNodeLabel> _externalLabels = this._utils_qvto.getExternalLabels(it);
          boolean _hasElements = false;
          for(final GenExternalNodeLabel label : _externalLabels) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(" || ", "\t");
            }
            _builder.append("borderItemEditPart instanceof ");
            Object _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
            _builder.append(_editPartQualifiedClassName, "\t");
          }
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.SOUTH);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("locator.setBorderItemOffset(new org.eclipse.draw2d.geometry.Dimension(-20, -20));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("borderItemContainer.add(borderItemEditPart.getFigure(), locator);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.addBorderItem(borderItemContainer, borderItemEditPart);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence createNodePlate(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure result = new org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure(");
    {
      boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
      if (_isPixelMapMode) {
        int _defaultSizeWidth = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
        _builder.append(_defaultSizeWidth, "\t");
        _builder.append(", ");
        int _defaultSizeHeight = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
        _builder.append(_defaultSizeHeight, "\t");
      } else {
        _builder.append("getMapMode().DPtoLP(");
        int _defaultSizeWidth_1 = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
        _builder.append(_defaultSizeWidth_1, "\t");
        _builder.append("), getMapMode().DPtoLP(");
        int _defaultSizeHeight_1 = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
        _builder.append(_defaultSizeHeight_1, "\t");
        _builder.append(")");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setupNodePlate = this.setupNodePlate(it);
    _builder.append(_setupNodePlate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _setupNodePlate(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _setupNodePlate(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append("//FIXME: workaround for #154536");
    _builder.newLine();
    _builder.append("result.getBounds().setSize(result.getPreferredSize());");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getPrimaryDragEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    ResizeConstraints rc = this._viewmapAttributesUtils_qvto.getResizeConstraints(it.getViewmap());
    _builder.newLineIfNotEmpty();
    {
      if (((!Objects.equal(null, it.getPrimaryDragEditPolicyQualifiedClassName())) || (!Objects.equal(null, rc)))) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.gef.EditPolicy getPrimaryDragEditPolicy() {");
        _builder.newLine();
        {
          String _primaryDragEditPolicyQualifiedClassName = it.getPrimaryDragEditPolicyQualifiedClassName();
          boolean _notEquals = (!Objects.equal(null, _primaryDragEditPolicyQualifiedClassName));
          if (_notEquals) {
            _builder.append("\t");
            _builder.append("return new ");
            String _primaryDragEditPolicyQualifiedClassName_1 = it.getPrimaryDragEditPolicyQualifiedClassName();
            _builder.append(_primaryDragEditPolicyQualifiedClassName_1, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("org.eclipse.gef.EditPolicy result = super.getPrimaryDragEditPolicy();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (result instanceof org.eclipse.gef.editpolicies.ResizableEditPolicy) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gef.editpolicies.ResizableEditPolicy ep = (org.eclipse.gef.editpolicies.ResizableEditPolicy) result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("ep.setResizeDirections(");
            _builder.newLine();
            {
              boolean _isEmpty = rc.getResizeHandleNames().isEmpty();
              boolean _not = (!_isEmpty);
              if (_not) {
                _builder.append("\t");
                _builder.append("\t");
                {
                  EList<String> _resizeHandleNames = rc.getResizeHandleNames();
                  boolean _hasElements = false;
                  for(final String name : _resizeHandleNames) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(" | ", "\t\t");
                    }
                    _builder.append("org.eclipse.draw2d.PositionConstants.");
                    _builder.append(name, "\t\t");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("org.eclipse.draw2d.PositionConstants.NONE");
                _builder.newLine();
                _builder.append("\t\t\t\t");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence createFigure(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      ((("Creates figure for this edit part.\n" + 
        "\n") + 
        "Body of this method does not depend on settings in generation model\n") + 
        "so you may safely remove <i>generated</i> tag and modify it.\n"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure create");
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("Main");
      } else {
        _builder.append("Node");
      }
    }
    _builder.append("Figure() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = createNodePlate();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("figure.setLayoutManager(new org.eclipse.draw2d.StackLayout());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.draw2d.IFigure shape = createNodeShape();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("figure.add(shape);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("contentPane = setupContentPane(shape);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return figure;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setupContentPane(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      (("Default implementation treats passed figure as content pane.\n" + 
        "Respects layout one may have set for generated figure.\n") + 
        "@param nodeShape instance of generated figure class"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure setupContentPane(org.eclipse.draw2d.IFigure nodeShape) {");
    _builder.newLine();
    {
      if ((((!it.getChildNodes().isEmpty()) || (!it.getCompartments().isEmpty())) || IterableExtensions.<GenNodeLabel>exists(it.getLabels(), new Function1<GenNodeLabel, Boolean>() {
        @Override
        public Boolean apply(final GenNodeLabel l) {
          boolean _oclIsKindOf = NodeEditPart.this._common_qvto.oclIsKindOf(l, GenExternalNodeLabel.class);
          return Boolean.valueOf((!_oclIsKindOf));
        }
      }))) {
        _builder.append("\t");
        _builder.append("if (nodeShape.getLayoutManager() == null) {");
        _builder.newLine();
        {
          ViewmapLayoutType _layoutType = it.getLayoutType();
          boolean _equals = Objects.equal(_layoutType, ViewmapLayoutType.XY_LAYOUT_LITERAL);
          if (_equals) {
            _builder.append("\t");
            _builder.append("nodeShape.setLayoutManager(new org.eclipse.draw2d.FreeformLayout() {");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public Object getConstraint(org.eclipse.draw2d.IFigure figure) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("Object result = constraints.get(figure);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("if (result == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("result = new org.eclipse.draw2d.geometry.Rectangle(0, 0, -1, -1);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("});");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout layout =new org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("layout.setSpacing(");
            {
              boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
              if (_isPixelMapMode) {
                _builder.append("5");
              } else {
                _builder.append("getMapMode().DPtoLP(5)");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("nodeShape.setLayoutManager(layout);");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return nodeShape; // use nodeShape itself as contentPane");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContentPane(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.draw2d.IFigure getContentPane() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (contentPane != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return contentPane;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getContentPane();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setForegroundColor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setForegroundColor(org.eclipse.swt.graphics.Color color) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("primaryShape.setForegroundColor(color);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setBackgroundColor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setBackgroundColor(org.eclipse.swt.graphics.Color color) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("primaryShape.setBackgroundColor(color);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setLineWidth(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLineWidth(int width) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape instanceof org.eclipse.draw2d.Shape) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.draw2d.Shape) primaryShape).setLineWidth(");
    {
      boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
      if (_isPixelMapMode) {
        _builder.append("width");
      } else {
        _builder.append("getMapMode().DPtoLP(width)");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setLineStyle(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLineType(int style) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape instanceof org.eclipse.draw2d.Shape) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.draw2d.Shape) primaryShape).setLineStyle(style);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getPrimaryChildEditPart(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.gef.EditPart getPrimaryChildEditPart() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getChildBySemanticHint(");
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(IterableExtensions.<GenNodeLabel>head(it.getLabels()));
        _builder.append(_typeMethodCall, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenTopLevelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (event.getNotifier() == getModel() && org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("handleMajorSemanticChange();");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _innerClassDeclaration(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _innerClassDeclaration(final InnerClassViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    String _classBody = it.getClassBody();
    _builder.append(_classBody);
    return _builder;
  }
  
  protected CharSequence _innerClassDeclaration(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _viewmapClassBody = this.xptModeledViewmapProducer.viewmapClassBody(it);
    _builder.append(_viewmapClassBody);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getTargetEditPartMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.EditPart getTargetEditPart(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter adapter = ((org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) request).getViewAndElementDescriptor().getCreateElementRequestAdapter();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType type = (org.eclipse.gmf.runtime.emf.type.core.IElementType) adapter.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        {
          boolean _listCompartmentHasChildren = this._utils_qvto.listCompartmentHasChildren(compartment);
          if (_listCompartmentHasChildren) {
            {
              EList<GenChildNode> _childNodes = compartment.getChildNodes();
              for(final GenChildNode childNode : _childNodes) {
                _builder.append("if (type == ");
                CharSequence _accessElementType = this.xptElementTypes.accessElementType(childNode);
                _builder.append(_accessElementType);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return getChildBySemanticHint(");
                CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(compartment);
                _builder.append(_typeMethodCall, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getTargetEditPart(request);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsListContents(final GenNode it) {
    if (it instanceof GenChildSideAffixedNode) {
      return _extendsListContents((GenChildSideAffixedNode)it);
    } else if (it != null) {
      return _extendsListContents(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence installPrimaryDragEditPolicy(final GenNode it) {
    if (it instanceof GenChildSideAffixedNode) {
      return _installPrimaryDragEditPolicy((GenChildSideAffixedNode)it);
    } else if (it != null) {
      return _installPrimaryDragEditPolicy(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence createNodeShape(final Viewmap it, final GenNode node) {
    if (it instanceof FigureViewmap) {
      return _createNodeShape((FigureViewmap)it, node);
    } else if (it instanceof InnerClassViewmap) {
      return _createNodeShape((InnerClassViewmap)it, node);
    } else if (it instanceof ModeledViewmap) {
      return _createNodeShape((ModeledViewmap)it, node);
    } else if (it instanceof SnippetViewmap) {
      return _createNodeShape((SnippetViewmap)it, node);
    } else if (it != null) {
      return _createNodeShape(it, node);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, node).toString());
    }
  }
  
  public CharSequence setupNodePlate(final GenNode it) {
    if (it instanceof GenChildSideAffixedNode) {
      return _setupNodePlate((GenChildSideAffixedNode)it);
    } else if (it != null) {
      return _setupNodePlate(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence innerClassDeclaration(final Viewmap it) {
    if (it instanceof InnerClassViewmap) {
      return _innerClassDeclaration((InnerClassViewmap)it);
    } else if (it instanceof ModeledViewmap) {
      return _innerClassDeclaration((ModeledViewmap)it);
    } else if (it != null) {
      return _innerClassDeclaration(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
