/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.diagram.editparts.Utils_qvto;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class CompartmentEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  public CharSequence className(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence constructor(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence hasModelChildrenChanged(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isListLayout = it.isListLayout();
      if (_isListLayout) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean hasModelChildrenChanged(org.eclipse.emf.common.notify.Notification evt) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence getCompartmentName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getCompartmentName() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getDiagram().getEditorGen(), this.i18nKeyForCompartmentTitle(it));
    _builder.append(_accessorCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createFigure(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNeedsTitle = it.isNeedsTitle();
      boolean _not = (!_isNeedsTitle);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.draw2d.IFigure createFigure() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure result = (org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure) super.createFigure();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("result.setTitleVisibility(false);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public Object createDefaultEditPoliciesBody(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    {
      boolean _isCanCollapse = it.isCanCollapse();
      if (_isCanCollapse) {
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy(it);
    _builder.append(_installSemanticEditPolicy);
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenChildNode>notEmpty(it.getChildNodes());
      if (_notEmpty) {
        CharSequence _installCreationEditPolicy = this.xptEditpartsCommon.installCreationEditPolicy(it);
        _builder.append(_installCreationEditPolicy);
        _builder.newLineIfNotEmpty();
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.DRAG_DROP_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installCanonicalEditPolicy = this.xptEditpartsCommon.installCanonicalEditPolicy(it);
    _builder.append(_installCanonicalEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    CharSequence _additionalEditPolicies = this.additionalEditPolicies(it);
    _builder.append(_additionalEditPolicies);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additionalEditPolicies(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence refreshVisuals(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void refreshVisuals() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.refreshVisuals();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("refreshBounds();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.handleNotificationEvent(notification);");
    _builder.newLine();
    _builder.append("Object feature = notification.getFeature();");
    _builder.newLine();
    _builder.append("if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshBounds();");
    _builder.newLine();
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshBounds(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void refreshBounds() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int x = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int y = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int width = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int height = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("((org.eclipse.gef.GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence setRatio(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setRatio(Double ratio) {");
    _builder.newLine();
    {
      ViewmapLayoutType _layoutType = it.getNode().getLayoutType();
      boolean _equals = Objects.equal(ViewmapLayoutType.UNKNOWN_LITERAL, _layoutType);
      if (_equals) {
        _builder.append("\t");
        _builder.append("if (getFigure().getParent().getLayoutManager() instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("super.setRatio(ratio);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("// nothing to do -- parent layout does not accept Double constraints as ratio");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// super.setRatio(ratio); ");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getTargetEditPartMethod(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.EditPart getTargetEditPart(org.eclipse.gef.Request request) {");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenChildNode>notEmpty(it.getChildNodes());
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter adapter = ((org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) request).getViewAndElementDescriptor().getCreateElementRequestAdapter();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType type = (org.eclipse.gmf.runtime.emf.type.core.IElementType) adapter.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
        _builder.newLine();
        {
          EList<GenChildNode> _childNodes = it.getChildNodes();
          for(final GenChildNode childNode : _childNodes) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (type == ");
            CharSequence _accessElementType = this.xptElementTypes.accessElementType(childNode);
            _builder.append(_accessElementType, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getParent().getTargetEditPart(request);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest) {");
        _builder.newLine();
        {
          boolean _haveOneOfChildNodesIncomimgLinks = this._utils_qvto.haveOneOfChildNodesIncomimgLinks(it);
          if (_haveOneOfChildNodesIncomimgLinks) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants.REQ_CONNECTION_END.equals(request.getType())) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("for (Object type : ((org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest) request).getElementTypes()) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("if (type instanceof org.eclipse.gmf.runtime.emf.type.core.IElementType) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = (org.eclipse.gmf.runtime.emf.type.core.IElementType) type;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("if (");
            {
              List<GenLink> _collectIncomingLinks = this._utils_qvto.collectIncomingLinks(it);
              boolean _hasElements = false;
              for(final GenLink link : _collectIncomingLinks) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(" || ", "\t\t\t\t\t");
                }
                _builder.append("elementType.equals(");
                CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType(link);
                _builder.append(_accessElementType_1, "\t\t\t\t\t");
                _builder.append(")");
              }
            }
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("return super.getTargetEditPart(request);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getParent().getTargetEditPart(request);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return super.getTargetEditPart(request);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        CharSequence _internal_i18nAccessors = this.internal_i18nAccessors(compartment);
        _builder.append(_internal_i18nAccessors);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Localization
  public CharSequence internal_i18nAccessors(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _notEquals = (!Objects.equal(null, _title));
      if (_notEquals) {
        CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForCompartmentTitle(it));
        _builder.append(_accessorField);
      }
    }
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        CharSequence _internal_i18nValues = this.internal_i18nValues(compartment);
        _builder.append(_internal_i18nValues);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Localization
  public CharSequence internal_i18nValues(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _notEquals = (!Objects.equal(null, _title));
      if (_notEquals) {
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForCompartmentTitle(it), it.getTitle());
        _builder.append(_messageEntry);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForCompartmentTitle(final GenCompartment compartment) {
    CharSequence _className = this.className(compartment);
    return (_className + ".title");
  }
}
