/**
 * Copyright (c) 2011 - 2013 Montages AG
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OclChoiceParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedEnumParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class ChoiceUtils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public boolean isOclChoiceLabel(final GenCommonBase xptSelf) {
    LabelModelFacet labelModelFacet = this.getLabelModelfacet(xptSelf);
    return ((!Objects.equal(labelModelFacet, null)) && this._common_qvto.oclIsKindOf(labelModelFacet.getParser(), OclChoiceParser.class));
  }
  
  public boolean isOclChoiceLabelWithShowExpr(final GenCommonBase xptSelf) {
    LabelModelFacet labelModelFacet = this.getLabelModelfacet(xptSelf);
    boolean _equals = Objects.equal(labelModelFacet, null);
    if (_equals) {
      return false;
    }
    GenParserImplementation parser = labelModelFacet.getParser();
    boolean _switchResult = false;
    boolean _matched = false;
    if (parser instanceof OclChoiceParser) {
      _matched=true;
      ValueExpression _showExpression = ((OclChoiceParser)parser).getShowExpression();
      _switchResult = (!Objects.equal(_showExpression, null));
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isChoiceLabel(final LabelModelFacet modelFacet) {
    GenParserImplementation parser = modelFacet.getParser();
    return (this._common_qvto.oclIsKindOf(parser, PredefinedEnumParser.class) || this._common_qvto.oclIsKindOf(parser, OclChoiceParser.class));
  }
  
  public String getDirectManagerFQN(final LabelModelFacet modelFacet) {
    String _xifexpression = null;
    boolean _isChoiceLabel = this.isChoiceLabel(modelFacet);
    if (_isChoiceLabel) {
      _xifexpression = "org.eclipse.gmf.tooling.runtime.directedit.ComboDirectEditManager";
    } else {
      _xifexpression = "org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager";
    }
    return _xifexpression;
  }
  
  private LabelModelFacet getLabelModelfacet(final GenCommonBase xptSelf) {
    LabelModelFacet _switchResult = null;
    boolean _matched = false;
    if (xptSelf instanceof GenChildLabelNode) {
      _matched=true;
      _switchResult = ((GenChildLabelNode)xptSelf).getLabelModelFacet();
    }
    if (!_matched) {
      if (xptSelf instanceof GenLabel) {
        _matched=true;
        _switchResult = ((GenLabel)xptSelf).getModelFacet();
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }
}
