/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.naming;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.internal.bridge.naming.AbstractGenNamingStrategy;
import org.eclipse.papyrus.gmf.internal.bridge.naming.GenNamingStrategy;
import org.eclipse.papyrus.gmf.internal.common.NamesDispenser;

public class ClassGenNamingStrategy
extends AbstractGenNamingStrategy {
    private static final int MAX_SEGMENT_LENGTH = 23;

    public ClassGenNamingStrategy(String suffix, NamesDispenser namesDispenser, GenNamingStrategy chainedNamingStrategy, GenNamingStrategy prefixNamingStrategy) {
        super(suffix, namesDispenser, chainedNamingStrategy, prefixNamingStrategy);
    }

    @Override
    public String get(GenDiagram element) {
        String name;
        if (element.getDomainDiagramElement() != null && !this.isEmpty(name = element.getDomainDiagramElement().getName())) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenNode element) {
        String name;
        if (element.getModelFacet() != null && element.getModelFacet().getMetaClass() != null && !this.isEmpty(name = element.getModelFacet().getMetaClass().getName())) {
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenCompartment element) {
        String name = element.getTitle();
        if (!this.isEmpty(name)) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            name = String.valueOf(this.getCompartmentHostPrefix(element)) + name;
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenLink element) {
        GenFeature feature;
        String name;
        GenClass type;
        if (element.getModelFacet() instanceof TypeLinkModelFacet && (type = ((TypeLinkModelFacet)element.getModelFacet()).getMetaClass()) != null && !this.isEmpty(name = type.getName())) {
            return this.createClassName(name);
        }
        if (element.getModelFacet() instanceof FeatureLinkModelFacet && (feature = ((FeatureLinkModelFacet)element.getModelFacet()).getMetaFeature()) != null && !this.isEmpty(name = feature.getName())) {
            name = name.length() > 1 ? String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) : name.toUpperCase();
            name = String.valueOf(feature.getGenClass().getName()) + name;
            return this.createClassName(name);
        }
        return super.get(element);
    }

    @Override
    public String get(GenLabel element) {
        if (element.getModelFacet() instanceof FeatureLabelModelFacet) {
            StringBuffer sb = new StringBuffer();
            for (GenFeature feature : ((FeatureLabelModelFacet)element.getModelFacet()).getMetaFeatures()) {
                String name = feature.getName();
                if (this.isEmpty(name)) continue;
                name = name.length() > 1 ? String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) : name.toUpperCase();
                sb.append(name);
            }
            if (sb.length() > 0) {
                String name = sb.toString();
                if (name.length() > 23) {
                    name = name.substring(0, 23);
                }
                return this.createClassName(String.valueOf(this.getLabelHostPrefix(element)) + name);
            }
        }
        return super.get(element);
    }
}

