/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.papyrus.gmf.mappings.CanvasMapping;
import org.eclipse.papyrus.gmf.mappings.LabelMapping;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.NodeMapping;

public class SpecificDiagramRunTimeModelHelper
extends BasicDiagramRunTimeModelHelper {
    private final Map<String, GenClass> myName2GenClassMap;

    public SpecificDiagramRunTimeModelHelper(GenModel drtGenModel) {
        assert (!drtGenModel.getGenPackages().isEmpty());
        this.myName2GenClassMap = this.collectGenClasses(drtGenModel);
    }

    @Override
    public GenClass get(NodeMapping nodeMapping) {
        GenClass gc = this.getGenClass(nodeMapping.getDiagramNode().getName());
        if (gc != null) {
            return gc;
        }
        return super.get(nodeMapping);
    }

    @Override
    public GenClass get(LinkMapping linkMapping) {
        GenClass gc = this.getGenClass(linkMapping.getDiagramLink().getName());
        if (gc != null) {
            return gc;
        }
        return super.get(linkMapping);
    }

    @Override
    public GenClass get(CanvasMapping canvasMapping) {
        GenClass gc = this.getGenClass(canvasMapping.getDiagramCanvas().getName());
        if (gc != null) {
            return gc;
        }
        return super.get(canvasMapping);
    }

    @Override
    public GenClass get(LabelMapping labelMapping) {
        GenClass gc = this.getGenClass(labelMapping.getDiagramLabel().getName());
        if (gc != null) {
            return gc;
        }
        return super.get(labelMapping);
    }

    private Map<String, GenClass> collectGenClasses(GenModel drtGenModel) {
        TreeMap<String, GenClass> rv = new TreeMap<String, GenClass>();
        GenPackage genPack = (GenPackage)drtGenModel.getGenPackages().get(0);
        for (GenClass next : genPack.getGenClasses()) {
            rv.put(next.getName(), next);
        }
        return rv;
    }

    private GenClass getGenClass(String name) {
        return this.myName2GenClassMap.get(name);
    }
}

