/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.RuntimeGenModelAccess;
import org.eclipse.papyrus.gmf.mappings.CanvasMapping;
import org.eclipse.papyrus.gmf.mappings.LabelMapping;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.NodeMapping;

public class BasicDiagramRunTimeModelHelper
implements DiagramRunTimeModelHelper {
    private GenClass myNode;
    private GenClass myLink;
    private GenClass myCanvas;
    private boolean myIsLoaded = false;

    @Override
    public GenClass get(NodeMapping nodeMapping) {
        this.loadGenModel();
        return this.myNode;
    }

    @Override
    public GenClass get(LinkMapping linkMapping) {
        this.loadGenModel();
        return this.myLink;
    }

    @Override
    public GenClass get(CanvasMapping canvasMapping) {
        this.loadGenModel();
        return this.myCanvas;
    }

    @Override
    public GenClass getChildContainerDefault() {
        this.loadGenModel();
        return this.myNode;
    }

    @Override
    public GenClass get(LabelMapping labelMapping) {
        this.loadGenModel();
        return this.myNode;
    }

    private void loadGenModel() {
        if (this.myIsLoaded) {
            return;
        }
        this.myIsLoaded = true;
        RuntimeGenModelAccess runtimeAccess = new RuntimeGenModelAccess();
        runtimeAccess.ensure();
        GenPackage gp = runtimeAccess.genPackage();
        for (GenClass next : gp.getGenClasses()) {
            if (NotationPackage.eINSTANCE.getNode().getName().equals(next.getName())) {
                this.myNode = next;
                continue;
            }
            if (NotationPackage.eINSTANCE.getEdge().getName().equals(next.getName())) {
                this.myLink = next;
                continue;
            }
            if (!NotationPackage.eINSTANCE.getDiagram().getName().equals(next.getName())) continue;
            this.myCanvas = next;
        }
        assert (this.myNode != null && this.myLink != null && this.myCanvas != null);
    }
}

