/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreModelWizard;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.GenModelReloadActionDelegate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.gmf.bridge.ui.dashboard.DashboardAction;
import org.eclipse.papyrus.gmf.bridge.ui.dashboard.DashboardFacade;
import org.eclipse.papyrus.gmf.bridge.ui.dashboard.DashboardState;
import org.eclipse.papyrus.gmf.codegen.gmfgen.presentation.GMFGenModelWizard;
import org.eclipse.papyrus.gmf.gmfgraph.presentation.GMFGraphModelWizard;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.ActionContainer;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.DashboardActionRegistry;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.DashboardFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.HyperlinkFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.ModelFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.Plugin;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.actions.TransformMap2GenModelAction;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.GMFGraphSimpleModelWizard;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.GMFMapGuideModelWizard;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.GMFToolSimpleModelWizard;
import org.eclipse.papyrus.gmf.internal.common.URIUtil;
import org.eclipse.papyrus.gmf.internal.common.ui.FileSelector;
import org.eclipse.papyrus.gmf.mappings.presentation.GMFMapModelWizard;
import org.eclipse.papyrus.gmf.tooldef.presentation.GMFToolModelWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DashboardMediator
implements DashboardFacade {
    private static final boolean STRICT = true;
    private DashboardFigure view;
    private Shell shell;
    private IProject project;
    private DashboardState state = new DashboardState();
    private Map<String, ActionContainer> locations = new HashMap<String, ActionContainer>();
    private Map<DashboardActionRegistry.DashboardActionDescriptor, IFigure> contributions = new HashMap<DashboardActionRegistry.DashboardActionDescriptor, IFigure>();
    private Map<String, CheckBox> optionFigures = new HashMap<String, CheckBox>();

    public DashboardMediator(Shell shell) {
        this.shell = shell;
    }

    @Override
    public boolean isStrict() {
        return true;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    public void setView(DashboardFigure view) {
        this.view = view;
        this.locations.put("domain_model", view.getDMFigure());
        this.locations.put("domain_genmodel", view.getDGMFigure());
        this.locations.put("graphdef_model", view.getGDMFigure());
        this.locations.put("tooldef_model", view.getTDMFigure());
        this.locations.put("map_model", view.getMMFigure());
        this.locations.put("genmodel", view.getGMFigure());
        this.locations.put("map_model-genmodel", view.getMM2GMFigure());
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectDGMAction()));
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditDGMAction()));
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Reload, new ReloadDGMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectGDMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditGDMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Create, new CreateGDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Create, new CreateDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectTDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditTDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Create, new CreateTDMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectMMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditMMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Create, new CreateMMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Select, new SelectGMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Edit, new EditGMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Create, new CreateGMAction()));
        view.getDM2DGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Derive, new DeriveDGMAction()));
        view.getDM2GDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Derive, new DeriveGDMAction()));
        view.getDM2TDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Derive, new DeriveTDMAction()));
        view.getDM2MMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Combine, new CombineMMAction()));
        view.getMM2GMFigure().addAction(this.createOptionFigure(Messages.DashboardMediator_RCP, "rcp"));
        view.getMM2GMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_Transform, new TransformMap2GenModelAction()));
        DashboardActionRegistry.DashboardActionDescriptor[] dashboardActionDescriptorArray = Plugin.getDefault().getDashboardActionRegistry().getDescriptors();
        int n = dashboardActionDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DashboardActionRegistry.DashboardActionDescriptor descriptor = dashboardActionDescriptorArray[n2];
            this.addDashboardAction(descriptor);
            ++n2;
        }
        this.updateStatus();
    }

    public void addDashboardAction(DashboardActionRegistry.DashboardActionDescriptor descriptor) {
        ActionContainer location = this.locations.get(descriptor.getLocation());
        if (location == null) {
            Plugin.getDefault().getLog().log(Plugin.createError("Unknown GMF Dashboard location: " + descriptor.getLocation(), null));
            return;
        }
        DashboardAction action = descriptor.createDashboardAction();
        if (action == null) {
            return;
        }
        IFigure actionFigure = this.createLinkFigure(descriptor.getLabel(), action);
        location.addAction(actionFigure, descriptor.isStandard());
        this.contributions.put(descriptor, actionFigure);
    }

    public void removeDashboardAction(DashboardActionRegistry.DashboardActionDescriptor descriptor) {
        IFigure actionFigure = this.contributions.remove(descriptor);
        if (actionFigure == null) {
            return;
        }
        ActionContainer location = this.locations.get(descriptor.getLocation());
        if (location == null) {
            Plugin.getDefault().getLog().log(Plugin.createError("Unknown GMF Dashboard location: " + descriptor.getLocation(), null));
            return;
        }
        location.removeAction(actionFigure, descriptor.isStandard());
    }

    protected IFigure createLinkFigure(String text, DashboardAction action) {
        action.init(this);
        HyperlinkFigure linkFigure = new HyperlinkFigure(action);
        linkFigure.setText(text);
        return linkFigure;
    }

    protected IFigure createOptionFigure(String text, final String option) {
        final CheckBox optionFigure = new CheckBox(text);
        optionFigure.setRequestFocusEnabled(false);
        optionFigure.setFocusTraversable(false);
        optionFigure.setForegroundColor(ColorConstants.blue);
        optionFigure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DashboardMediator.this.getState().setOption(option, optionFigure.isSelected());
            }
        });
        this.optionFigures.put(option, optionFigure);
        return optionFigure;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public DashboardState getState() {
        return this.state;
    }

    public void setProjectAndState(IProject project, DashboardState state) {
        this.project = project;
        this.state = state;
        if (this.state == null) {
            this.state = new DashboardState();
        }
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        if (this.project == null) {
            this.view.getStatusLine(0).setText(Messages.DashboardMediator_SelectProject);
            this.view.getStatusLine(1).setText("");
        } else {
            this.view.getStatusLine(0).setText(MessageFormat.format(Messages.DashboardMediator_Project, this.project.getName()));
            double done = (double)this.state.getSpecifiedModelsCount() / (double)this.state.getModelsCount();
            this.view.getStatusLine(1).setText(MessageFormat.format(Messages.DashboardMediator_Progress, new Double(done)));
        }
        this.setModelName(this.view.getDGMFigure(), this.state.getDGM());
        this.setModelName(this.view.getGDMFigure(), this.state.getGDM());
        this.setModelName(this.view.getDMFigure(), this.state.getDM());
        this.setModelName(this.view.getTDMFigure(), this.state.getTDM());
        this.setModelName(this.view.getMMFigure(), this.state.getMM());
        this.setModelName(this.view.getGMFigure(), this.state.getGM());
        this.optionFigures.get("rcp").setSelected(this.state.getOption("rcp"));
        this.view.repaint();
    }

    protected void setModelName(ModelFigure figure, URI uri) {
        figure.setName(uri == null ? null : uri.lastSegment());
        figure.setFullName(uri == null ? null : uri.toString());
    }

    private class CombineMMAction
    extends RunWizardAction {
        private CombineMMAction() {
        }

        @Override
        public boolean isEnabled() {
            return DashboardMediator.this.project != null && DashboardMediator.this.state.getGDM() != null && DashboardMediator.this.state.getDM() != null && DashboardMediator.this.state.getTDM() != null;
        }

        @Override
        protected IWizard createWizard() {
            return new GMFMapGuideModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFMapGuideModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setMM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateDMAction
    extends RunWizardAction {
        private CreateDMAction() {
        }

        @Override
        protected IWizard createWizard() {
            return new EcoreModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((EcoreModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setDM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateGDMAction
    extends RunWizardAction {
        private CreateGDMAction() {
        }

        @Override
        protected IWizard createWizard() {
            return new GMFGraphModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGraphModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setGDM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateGMAction
    extends RunWizardAction {
        private CreateGMAction() {
        }

        @Override
        protected IWizard createWizard() {
            return new GMFGenModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGenModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setGM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateMMAction
    extends RunWizardAction {
        private CreateMMAction() {
        }

        @Override
        protected IWizard createWizard() {
            return new GMFMapModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFMapModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setMM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateTDMAction
    extends RunWizardAction {
        private CreateTDMAction() {
        }

        @Override
        protected IWizard createWizard() {
            return new GMFToolModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFToolModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setTDM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class DeriveDGMAction
    extends RunWizardAction {
        private DeriveDGMAction() {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && DashboardMediator.this.state.getDM() != null;
        }

        @Override
        protected IWizard createWizard() {
            return new OpenEMFModelWizard();
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((OpenEMFModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setDGM(file);
            DashboardMediator.this.updateStatus();
        }

        @Override
        protected IStructuredSelection getSelection() {
            return new StructuredSelection((Object)URIUtil.getFile((URI)DashboardMediator.this.state.getDM()));
        }
    }

    private class DeriveGDMAction
    extends RunWizardAction {
        private DeriveGDMAction() {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && DashboardMediator.this.state.getDM() != null;
        }

        @Override
        protected IWizard createWizard() {
            GMFGraphSimpleModelWizard wizard = new GMFGraphSimpleModelWizard();
            wizard.setMode("detect");
            return wizard;
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGraphSimpleModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setGDM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class DeriveTDMAction
    extends RunWizardAction {
        private DeriveTDMAction() {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && DashboardMediator.this.state.getDM() != null;
        }

        @Override
        protected IWizard createWizard() {
            GMFToolSimpleModelWizard wizard = new GMFToolSimpleModelWizard();
            wizard.setMode("detect");
            return wizard;
        }

        @Override
        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFToolSimpleModelWizard)wizard).getModelFile();
            DashboardMediator.this.state.setTDM(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class EditDGMAction
    extends EditFileAction {
        private EditDGMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getDGM();
        }
    }

    private class EditDMAction
    extends EditFileAction {
        private EditDMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getDM();
        }
    }

    protected abstract class EditFileAction
    implements DashboardAction {
        protected EditFileAction() {
        }

        @Override
        public void init(DashboardFacade context) {
        }

        @Override
        public boolean isEnabled() {
            return DashboardMediator.this.project != null && this.getURI() != null;
        }

        @Override
        public void run() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IFile modelFile = URIUtil.getFile((URI)this.getURI());
            try {
                String fileName = modelFile.getFullPath().toString();
                String editorId = workbench.getEditorRegistry().getDefaultEditor(fileName).getId();
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), editorId);
            }
            catch (PartInitException pie) {
                String msg = MessageFormat.format(Messages.DashboardMediator_FailToOpen, this.getURI());
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)msg, (String)pie.getMessage());
            }
        }

        protected abstract URI getURI();
    }

    private class EditGDMAction
    extends EditFileAction {
        private EditGDMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getGDM();
        }
    }

    private class EditGMAction
    extends EditFileAction {
        private EditGMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getGM();
        }
    }

    private class EditMMAction
    extends EditFileAction {
        private EditMMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getMM();
        }
    }

    private class EditTDMAction
    extends EditFileAction {
        private EditTDMAction() {
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getTDM();
        }
    }

    private static class OpenEMFModelWizard
    extends EMFModelWizard {
        private OpenEMFModelWizard() {
        }

        public IFile getModelFile() {
            IPath path = this.genModelContainerPath.append(this.genModelFileName);
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
    }

    private class ReloadDGMAction
    implements DashboardAction {
        private ReloadDGMAction() {
        }

        @Override
        public void init(DashboardFacade context) {
        }

        @Override
        public boolean isEnabled() {
            return DashboardMediator.this.state.getDGM() != null;
        }

        @Override
        public void run() {
            IFile file = URIUtil.getFile((URI)DashboardMediator.this.state.getDGM());
            GenModelReloadActionDelegate action = new GenModelReloadActionDelegate();
            Action uiAction = new Action(){};
            action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)file));
            action.run((IAction)uiAction);
            DashboardMediator.this.updateStatus();
        }
    }

    protected abstract class RunWizardAction
    implements DashboardAction {
        private static final int SIZING_WIZARD_WIDTH = 500;
        private static final int SIZING_WIZARD_HEIGHT = 500;

        protected RunWizardAction() {
        }

        @Override
        public void init(DashboardFacade context) {
        }

        @Override
        public boolean isEnabled() {
            return DashboardMediator.this.project != null;
        }

        @Override
        public void run() {
            final IWizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(PlatformUI.getWorkbench(), this.getSelection());
            }
            WizardDialog dialog = new WizardDialog(DashboardMediator.this.shell, wizard){

                protected void finishPressed() {
                    RunWizardAction.this.wizardFinished(wizard);
                    super.finishPressed();
                }
            };
            dialog.create();
            dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
            dialog.open();
        }

        protected IStructuredSelection getSelection() {
            ArrayList<IFile> selection = new ArrayList<IFile>();
            this.addFile(selection, DashboardMediator.this.state.getDM());
            this.addFile(selection, DashboardMediator.this.state.getDGM());
            this.addFile(selection, DashboardMediator.this.state.getGDM());
            this.addFile(selection, DashboardMediator.this.state.getTDM());
            this.addFile(selection, DashboardMediator.this.state.getMM());
            this.addFile(selection, DashboardMediator.this.state.getGM());
            return new StructuredSelection(selection);
        }

        protected void addFile(List<IFile> files, URI uri) {
            if (uri == null) {
                return;
            }
            IFile file = URIUtil.getFile((URI)uri);
            if (file != null) {
                files.add(file);
            }
        }

        protected abstract IWizard createWizard();

        protected void wizardFinished(IWizard wizard) {
        }
    }

    private class SelectDGMAction
    extends SelectFileAction {
        private SelectDGMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getDGMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getDGM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setDGM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "genmodel";
        }
    }

    private class SelectDMAction
    extends SelectFileAction {
        private SelectDMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getDMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getDM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setDM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "ecore";
        }
    }

    protected abstract class SelectFileAction
    implements DashboardAction {
        protected SelectFileAction() {
        }

        @Override
        public void init(DashboardFacade context) {
        }

        @Override
        public boolean isEnabled() {
            return DashboardMediator.this.project != null;
        }

        @Override
        public void run() {
            IFile file = this.getURI() == null ? null : URIUtil.getFile((URI)this.getURI());
            file = FileSelector.selectFile((Shell)DashboardMediator.this.shell, (String)this.getFigure().getDescription(), null, (IFile)file, (String)this.getFileExtension());
            if (file == null) {
                return;
            }
            this.setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
            DashboardMediator.this.updateStatus();
        }

        protected abstract ModelFigure getFigure();

        protected abstract URI getURI();

        protected abstract void setURI(URI var1);

        protected abstract String getFileExtension();
    }

    private class SelectGDMAction
    extends SelectFileAction {
        private SelectGDMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getGDMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getGDM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setGDM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "gmfgraph";
        }
    }

    private class SelectGMAction
    extends SelectFileAction {
        private SelectGMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getGMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getGM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setGM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "gmfgen";
        }
    }

    private class SelectMMAction
    extends SelectFileAction {
        private SelectMMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getMMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getMM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setMM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "gmfmap";
        }
    }

    private class SelectTDMAction
    extends SelectFileAction {
        private SelectTDMAction() {
        }

        @Override
        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getTDMFigure();
        }

        @Override
        protected URI getURI() {
            return DashboardMediator.this.state.getTDM();
        }

        @Override
        protected void setURI(URI uri) {
            DashboardMediator.this.state.setTDM(uri);
        }

        @Override
        protected String getFileExtension() {
            return "gmftool";
        }
    }
}

