/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.FlowActionFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.FlowFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.ModelFigure;
import org.eclipse.papyrus.gmf.internal.bridge.ui.dashboard.Plugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DashboardFigure
extends RectangleFigure {
    private static final int LINE_WIDTH = 6;
    private static final int TEXT_GAP = 9;
    private static final int ARROW_LENGTH = 15;
    private static final Color DASHBOARD_BG = new Color(null, 113, 104, 209);
    private static final Color DASHBOARD_FG = new Color(null, 169, 164, 227);
    private static final Color MODEL_BG = ColorConstants.white;
    private ImageFigure logoFigure = new ImageFigure(){

        protected void paintFigure(Graphics graphics) {
            if (this.getImage() != null) {
                graphics.drawImage(this.getImage(), new Rectangle(this.getImage().getBounds()), this.getBounds());
            }
        }
    };
    private IFigure statusFigure;
    private ModelFigure dgmFigure;
    private ModelFigure gdmFigure;
    private ModelFigure dmFigure;
    private ModelFigure tdmFigure;
    private ModelFigure mmFigure;
    private ModelFigure gmFigure;
    private FlowFigure dm2dgmFlow;
    private FlowFigure dm2gdmFlow;
    private FlowFigure dm2tdmFlow;
    private FlowFigure dm2mmFlow;
    private FlowFigure gdm2mmFlow;
    private FlowFigure tdm2mmFlow;
    private FlowFigure mm2gmFlow;
    private FlowActionFigure dm2dgmFigure;
    private FlowActionFigure dm2gdmFigure;
    private FlowActionFigure dm2tdmFigure;
    private FlowActionFigure dm2mmFigure;
    private FlowActionFigure mm2gmFigure;

    public DashboardFigure() {
        this.add((IFigure)this.logoFigure);
        Image logoImage = Plugin.getDefault().getImageRegistry().get("/icons/viewban/logo.png");
        if (logoImage != null) {
            this.logoFigure.setImage(logoImage);
        }
        this.dgmFigure = this.createModelFigure(Messages.DashboardFigure_DGM, "/icons/full/obj16/GenModelModelFile.gif");
        this.add((IFigure)this.dgmFigure);
        this.gdmFigure = this.createModelFigure(Messages.DashboardFigure_GDM, "/icons/full/obj16/GMFGraphModelFile.gif");
        this.add((IFigure)this.gdmFigure);
        this.dmFigure = this.createModelFigure(Messages.DashboardFigure_DM, "/icons/full/obj16/EcoreModelFile.gif");
        this.add((IFigure)this.dmFigure);
        this.tdmFigure = this.createModelFigure(Messages.DashboardFigure_TDM, "/icons/full/obj16/GMFToolModelFile.gif");
        this.add((IFigure)this.tdmFigure);
        this.mmFigure = this.createModelFigure(Messages.DashboardFigure_MM, "/icons/full/obj16/GMFMapModelFile.gif");
        this.add((IFigure)this.mmFigure);
        this.gmFigure = this.createModelFigure(Messages.DashboardFigure_GM, "/icons/full/obj16/GMFGenModelFile.gif");
        this.add((IFigure)this.gmFigure);
        this.dm2dgmFlow = this.createFlowFigure(true);
        this.add((IFigure)this.dm2dgmFlow);
        this.dm2gdmFlow = this.createFlowFigure(true);
        this.add((IFigure)this.dm2gdmFlow);
        this.dm2tdmFlow = this.createFlowFigure(true);
        this.add((IFigure)this.dm2tdmFlow);
        this.dm2mmFlow = this.createFlowFigure(true);
        this.add((IFigure)this.dm2mmFlow);
        this.gdm2mmFlow = this.createFlowFigure(false);
        this.add((IFigure)this.gdm2mmFlow);
        this.tdm2mmFlow = this.createFlowFigure(false);
        this.add((IFigure)this.tdm2mmFlow);
        this.mm2gmFlow = this.createFlowFigure(true);
        this.add((IFigure)this.mm2gmFlow);
        this.dm2dgmFigure = this.createFlowActionFigure();
        this.add((IFigure)this.dm2dgmFigure);
        this.dm2gdmFigure = this.createFlowActionFigure();
        this.add((IFigure)this.dm2gdmFigure);
        this.dm2tdmFigure = this.createFlowActionFigure();
        this.add((IFigure)this.dm2tdmFigure);
        this.dm2mmFigure = this.createFlowActionFigure();
        this.add((IFigure)this.dm2mmFigure);
        this.mm2gmFigure = this.createFlowActionFigure();
        this.add((IFigure)this.mm2gmFigure);
        this.statusFigure = new Figure();
        this.add(this.statusFigure);
        this.statusFigure.setFont(JFaceResources.getBannerFont());
        ToolbarLayout statusLayout = new ToolbarLayout();
        statusLayout.setStretchMinorAxis(false);
        this.statusFigure.setLayoutManager((LayoutManager)statusLayout);
        this.statusFigure.add((IFigure)new Label());
        this.statusFigure.add((IFigure)new Label());
        this.setLayoutManager((LayoutManager)new DashboardLayout());
        this.setBorder((Border)new MarginBorder(10));
        this.setBackgroundColor(DASHBOARD_BG);
        this.setForegroundColor(DASHBOARD_FG);
    }

    public ModelFigure getDGMFigure() {
        return this.dgmFigure;
    }

    public ModelFigure getGDMFigure() {
        return this.gdmFigure;
    }

    public ModelFigure getDMFigure() {
        return this.dmFigure;
    }

    public ModelFigure getTDMFigure() {
        return this.tdmFigure;
    }

    public ModelFigure getMMFigure() {
        return this.mmFigure;
    }

    public ModelFigure getGMFigure() {
        return this.gmFigure;
    }

    public FlowActionFigure getDM2DGMFigure() {
        return this.dm2dgmFigure;
    }

    public FlowActionFigure getDM2GDMFigure() {
        return this.dm2gdmFigure;
    }

    public FlowActionFigure getDM2TDMFigure() {
        return this.dm2tdmFigure;
    }

    public FlowActionFigure getDM2MMFigure() {
        return this.dm2mmFigure;
    }

    public FlowActionFigure getMM2GMFigure() {
        return this.mm2gmFigure;
    }

    public Label getStatusLine(int i) {
        return (Label)this.statusFigure.getChildren().get(i);
    }

    protected ModelFigure createModelFigure(String description, String iconKey) {
        ModelFigure modelFigure = new ModelFigure();
        modelFigure.setDescription(description);
        Image image = Plugin.getDefault().getImageRegistry().get(iconKey);
        if (image != null) {
            modelFigure.setIcon(image);
        }
        modelFigure.setBackgroundColor(MODEL_BG);
        modelFigure.setForegroundColor(DASHBOARD_FG);
        modelFigure.setLineWidth(6);
        modelFigure.setSpacing(9);
        return modelFigure;
    }

    protected FlowFigure createFlowFigure(boolean directed) {
        FlowFigure flowFigure = new FlowFigure();
        if (directed) {
            PolygonDecoration decoration = new PolygonDecoration();
            PointList template = new PointList();
            template.addPoint(0, -3);
            template.addPoint(0, 3);
            template.addPoint(-15, 13);
            template.addPoint(-15, -13);
            decoration.setTemplate(template);
            decoration.setScale(1.0, 1.0);
            flowFigure.setTargetDecoration((RotatableDecoration)decoration);
        }
        flowFigure.setForegroundColor(DASHBOARD_FG);
        flowFigure.setLineWidth(6);
        return flowFigure;
    }

    protected FlowActionFigure createFlowActionFigure() {
        FlowActionFigure flowActionFigure = new FlowActionFigure();
        ToolbarLayout flowActionLayout = new ToolbarLayout();
        flowActionLayout.setStretchMinorAxis(false);
        flowActionLayout.setMinorAlignment(0);
        flowActionFigure.setLayoutManager((LayoutManager)flowActionLayout);
        flowActionFigure.setBackgroundColor(MODEL_BG);
        flowActionFigure.setForegroundColor(DASHBOARD_FG);
        flowActionFigure.setLineWidth(2);
        flowActionFigure.setBorder((Border)new MarginBorder(4));
        return flowActionFigure;
    }

    protected void outlineShape(Graphics graphics) {
    }

    private class DashboardLayout
    extends AbstractLayout {
        private static final int MAX_BOX_WIDTH = 300;
        private static final int BOX_SPACING = 20;

        private DashboardLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension d = this.getLayoutData().getSize();
            Insets insets = container.getInsets();
            d = new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight());
            return d.union(this.getBorderPreferredSize(container));
        }

        public void layout(IFigure container) {
            this.getLayoutData().apply(container.getClientArea().getLocation());
        }

        protected LayoutData getLayoutData() {
            Dimension dgmSize = DashboardFigure.this.dgmFigure.getPreferredSize();
            dgmSize.width = Math.min(dgmSize.width, 300);
            Dimension dmSize = DashboardFigure.this.dmFigure.getPreferredSize();
            dmSize.width = Math.min(dmSize.width, 300);
            Dimension gdmSize = DashboardFigure.this.gdmFigure.getPreferredSize();
            gdmSize.width = Math.min(gdmSize.width, 300);
            Dimension tdmSize = DashboardFigure.this.gdmFigure.getPreferredSize();
            tdmSize.width = Math.min(tdmSize.width, 300);
            Dimension mmSize = DashboardFigure.this.mmFigure.getPreferredSize();
            mmSize.width = Math.min(mmSize.width, 300);
            Dimension gmSize = DashboardFigure.this.gmFigure.getPreferredSize();
            gmSize.width = Math.min(gmSize.width, 300);
            Dimension dm2dgmSize = DashboardFigure.this.dm2dgmFigure.getPreferredSize();
            Dimension dm2gdmSize = DashboardFigure.this.dm2gdmFigure.getPreferredSize();
            Dimension dm2tdmSize = DashboardFigure.this.dm2tdmFigure.getPreferredSize();
            Dimension dm2mmSize = DashboardFigure.this.dm2mmFigure.getPreferredSize();
            Dimension mm2gmSize = DashboardFigure.this.mm2gmFigure.getPreferredSize();
            LayoutData data = new LayoutData();
            int dmY = gdmSize.height + 20;
            int dgmY = dmY + dmSize.height + 20;
            data.dgmBox = new Rectangle(0, dgmY, dgmSize.width, dgmSize.height);
            data.dm2dgmBox = new Rectangle((data.dgmBox.width - dm2dgmSize.width) / 2, dmY + (dmSize.height - dm2dgmSize.height) / 2, dm2dgmSize.width, dm2dgmSize.height);
            data.dmBox = new Rectangle(data.dm2dgmBox.x + data.dm2dgmBox.width + 20, dmY, dmSize.width, dmSize.height);
            int dm2tdmX = data.dmBox.x + (data.dmBox.width - dm2tdmSize.width) / 2;
            int gap1 = dm2tdmX - (data.dgmBox.x + data.dgmBox.width);
            if (gap1 < 20) {
                int delta = 20 - gap1;
                data.dmBox.x += delta;
                dm2tdmX += delta;
            }
            data.dm2gdmBox = new Rectangle(data.dmBox.x + (data.dmBox.width - dm2gdmSize.width) / 2, (gdmSize.height - dm2gdmSize.height) / 2, dm2gdmSize.width, dm2gdmSize.height);
            data.gdmBox = new Rectangle(data.dm2gdmBox.x + data.dm2gdmBox.width + 20 + 15, 0, gdmSize.width, gdmSize.height);
            int tdmY = data.dmBox.y + data.dmBox.height + 20;
            data.dm2tdmBox = new Rectangle(dm2tdmX, tdmY + (tdmSize.height - dm2tdmSize.height) / 2, dm2tdmSize.width, dm2tdmSize.height);
            data.tdmBox = new Rectangle(data.dm2tdmBox.x + data.dm2tdmBox.width + 20 + 15, tdmY, tdmSize.width, tdmSize.height);
            data.dm2mmBox = new Rectangle(data.dmBox.x + data.dmBox.width + 20, data.dmBox.y + (data.dmBox.height - dm2mmSize.height) / 2, dm2mmSize.width, dm2mmSize.height);
            data.mmBox = new Rectangle(data.dm2mmBox.x + data.dm2mmBox.width + 20 + 15, data.dmBox.y, mmSize.width, mmSize.height);
            int gmY = data.mmBox.y + data.mmBox.height + 20;
            data.mm2gmBox = new Rectangle(data.mmBox.x + data.mmBox.width + 20, data.mmBox.y + (data.mmBox.height - mm2gmSize.height) / 2, mm2gmSize.width, mm2gmSize.height);
            data.gmBox = new Rectangle(data.mm2gmBox.x - (gmSize.width - mm2gmSize.width) / 2, gmY, gmSize.width, gmSize.height);
            int gap2 = data.gmBox.x - (data.tdmBox.x + data.tdmBox.width);
            if (gap2 < 20) {
                int delta = 20 - gap2;
                data.mm2gmBox.x += delta;
                data.gmBox.x += delta;
            }
            int pointsY = data.dmBox.y + data.dmBox.height / 2;
            data.dm2dgmPoints = new PointList(3);
            data.dm2dgmPoints.addPoint(data.dmBox.x, pointsY);
            data.dm2dgmPoints.addPoint(data.dm2dgmBox.x + data.dm2dgmBox.width / 2, pointsY);
            data.dm2dgmPoints.addPoint(data.dm2dgmBox.x + data.dm2dgmBox.width / 2, data.dgmBox.y);
            int pointsX = data.dmBox.x + data.dmBox.width / 2;
            data.dm2gdmPoints = new PointList(3);
            data.dm2gdmPoints.addPoint(pointsX, data.dmBox.y);
            data.dm2gdmPoints.addPoint(pointsX, data.dm2gdmBox.y + data.dm2gdmBox.height / 2);
            data.dm2gdmPoints.addPoint(data.gdmBox.x, data.dm2gdmBox.y + data.dm2gdmBox.height / 2);
            data.dm2tdmPoints = new PointList(3);
            data.dm2tdmPoints.addPoint(pointsX, data.dmBox.y + data.dmBox.height);
            data.dm2tdmPoints.addPoint(pointsX, data.dm2tdmBox.y + data.dm2tdmBox.height / 2);
            data.dm2tdmPoints.addPoint(data.tdmBox.x, data.dm2tdmBox.y + data.dm2tdmBox.height / 2);
            data.dm2mmPoints = new PointList(2);
            data.dm2mmPoints.addPoint(data.dmBox.x + data.dmBox.width, pointsY);
            data.dm2mmPoints.addPoint(data.mmBox.x, pointsY);
            int crossX = data.dm2mmBox.x + data.dm2mmBox.width / 2;
            data.gdm2mmPoints = new PointList(2);
            data.gdm2mmPoints.addPoint(crossX, data.gdmBox.y + data.gdmBox.height);
            data.gdm2mmPoints.addPoint(crossX, pointsY);
            data.tdm2mmPoints = new PointList(2);
            data.tdm2mmPoints.addPoint(crossX, data.tdmBox.y);
            data.tdm2mmPoints.addPoint(crossX, pointsY);
            data.mm2gmPoints = new PointList(3);
            data.mm2gmPoints.addPoint(data.mmBox.x + data.mmBox.width, pointsY);
            data.mm2gmPoints.addPoint(data.mm2gmBox.x + data.mm2gmBox.width / 2, pointsY);
            data.mm2gmPoints.addPoint(data.mm2gmBox.x + data.mm2gmBox.width / 2, data.gmBox.y);
            int logoMaxWidth = data.dm2gdmBox.x - 20;
            int logoMaxHeight = data.dmBox.y - 20;
            Dimension logoSize = DashboardFigure.this.logoFigure.getPreferredSize();
            if (logoSize.width > logoMaxWidth || logoSize.height > logoMaxHeight) {
                double scale = Math.min((double)logoMaxWidth / (double)logoSize.width, (double)logoMaxHeight / (double)logoSize.height);
                logoSize.width = (int)((double)logoSize.width * scale);
                logoSize.height = (int)((double)logoSize.height * scale);
            }
            data.logoBox = new Rectangle(0, 0, logoSize.width, logoSize.height);
            Dimension statusSize = DashboardFigure.this.statusFigure.getPreferredSize();
            int statusX = Math.max(data.gmBox.x + data.gmBox.width - statusSize.width, data.gdmBox.x + data.gdmBox.width + 20);
            data.statusBox = new Rectangle(statusX, 0, statusSize.width, statusSize.height);
            return data;
        }

        private class LayoutData {
            public Rectangle logoBox;
            public Rectangle statusBox;
            public Rectangle dgmBox;
            public Rectangle gdmBox;
            public Rectangle dmBox;
            public Rectangle tdmBox;
            public Rectangle mmBox;
            public Rectangle gmBox;
            public PointList dm2dgmPoints;
            public PointList dm2gdmPoints;
            public PointList dm2tdmPoints;
            public PointList dm2mmPoints;
            public PointList gdm2mmPoints;
            public PointList tdm2mmPoints;
            public PointList mm2gmPoints;
            public Rectangle dm2dgmBox;
            public Rectangle dm2gdmBox;
            public Rectangle dm2tdmBox;
            public Rectangle dm2mmBox;
            public Rectangle mm2gmBox;

            private LayoutData() {
            }

            public void apply(Point offset) {
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.logoFigure.setBounds(this.logoBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.statusFigure.setBounds(this.statusBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dgmFigure.setBounds(this.dgmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.gdmFigure.setBounds(this.gdmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dmFigure.setBounds(this.dmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.tdmFigure.setBounds(this.tdmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.mmFigure.setBounds(this.mmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.gmFigure.setBounds(this.gmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2dgmFlow.setPoints(this.getTranslated(this.dm2dgmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2gdmFlow.setPoints(this.getTranslated(this.dm2gdmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2tdmFlow.setPoints(this.getTranslated(this.dm2tdmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2mmFlow.setPoints(this.getTranslated(this.dm2mmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.gdm2mmFlow.setPoints(this.getTranslated(this.gdm2mmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.tdm2mmFlow.setPoints(this.getTranslated(this.tdm2mmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.mm2gmFlow.setPoints(this.getTranslated(this.mm2gmPoints, offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2dgmFigure.setBounds(this.dm2dgmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2gdmFigure.setBounds(this.dm2gdmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2tdmFigure.setBounds(this.dm2tdmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.dm2mmFigure.setBounds(this.dm2mmBox.getTranslated(offset));
                ((DashboardLayout)DashboardLayout.this).DashboardFigure.this.mm2gmFigure.setBounds(this.mm2gmBox.getTranslated(offset));
            }

            private PointList getTranslated(PointList source, Point offset) {
                PointList target = new PointList(source.size());
                target.addAll(source);
                target.translate(offset);
                return target;
            }

            public Dimension getSize() {
                Rectangle bounds = this.logoBox.getCopy();
                bounds.union(this.statusBox);
                bounds.union(this.dgmBox);
                bounds.union(this.gdmBox);
                bounds.union(this.dmBox);
                bounds.union(this.tdmBox);
                bounds.union(this.mmBox);
                bounds.union(this.gmBox);
                return bounds.getSize();
            }
        }
    }
}

