/**
 * Copyright (c) 2015 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Onder Gurcan (Onder.Gurcan@cea.fr) - Initial API and implementation
 */
package org.eclipse.papyrus.uml.profile.newchildmenu.generator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreationMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.ElementCreationMenuModelFactory;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.impl.ElementCreationMenuModelFactoryImpl;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.impl.ElementTypeSetConfigurationImpl;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class NewChildMenuGenerator {
  public void generate(final String parentFolderName, final String elementtypesconfigurationsFilePath) {
    try {
      ResourceSetImpl resourceSet = new ResourceSetImpl();
      URI elementtypesconfigurationsURI = URI.createURI(elementtypesconfigurationsFilePath);
      Resource resource = resourceSet.getResource(elementtypesconfigurationsURI, true);
      EObject eObject = resource.getContents().get(0);
      ElementTypeSetConfigurationImpl configurationImpl = ((ElementTypeSetConfigurationImpl) eObject);
      Folder folder = this.generateElementCreationMenuModel(configurationImpl.getName(), configurationImpl.getElementTypeConfigurations());
      Resource folderResource = resourceSet.createResource(URI.createURI((parentFolderName + "/newChildMenu.xmi")));
      folderResource.getContents().add(folder);
      folderResource.save(null);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Folder generateElementCreationMenuModel(final String profileName, final EList<ElementTypeConfiguration> elementTypeConfigurationsList) {
    ElementCreationMenuModelFactory factory = ElementCreationMenuModelFactoryImpl.init();
    Folder folder = factory.createFolder();
    folder.setLabel(profileName);
    for (final ElementTypeConfiguration elementTypeConfigurations : elementTypeConfigurationsList) {
      {
        CreationMenu creationMenu = factory.createCreationMenu();
        creationMenu.setLabel(elementTypeConfigurations.getName());
        creationMenu.setElementType(elementTypeConfigurations);
        folder.getMenu().add(creationMenu);
      }
    }
    return folder;
  }
}
