/*******************************************************************************
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, ARTAL
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *     Borland - initial API and implementation
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 ******************************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.gmf.gmfgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Color Constants</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.gmf.gmfgraph.GMFGraphPackage#getColorConstants()
 * @model
 * @generated
 */
public enum ColorConstants implements Enumerator
{
	/**
	 * The '<em><b>White</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WHITE
	 * @generated
	 * @ordered
	 */
	WHITE_LITERAL(0, "white", "white"),
	/**
	 * The '<em><b>Black</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLACK
	 * @generated
	 * @ordered
	 */
	BLACK_LITERAL(1, "black", "black"),
	/**
	 * The '<em><b>Light Gray</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIGHT_GRAY
	 * @generated
	 * @ordered
	 */
	LIGHT_GRAY_LITERAL(2, "lightGray", "lightGray"),
	/**
	 * The '<em><b>Gray</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GRAY
	 * @generated
	 * @ordered
	 */
	GRAY_LITERAL(3, "gray", "gray"),
	/**
	 * The '<em><b>Dark Gray</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DARK_GRAY
	 * @generated
	 * @ordered
	 */
	DARK_GRAY_LITERAL(4, "darkGray", "darkGray"),
	/**
	 * The '<em><b>Red</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RED
	 * @generated
	 * @ordered
	 */
	RED_LITERAL(5, "red", "red"),
	/**
	 * The '<em><b>Orange</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ORANGE
	 * @generated
	 * @ordered
	 */
	ORANGE_LITERAL(6, "orange", "orange"),
	/**
	 * The '<em><b>Yellow</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #YELLOW
	 * @generated
	 * @ordered
	 */
	YELLOW_LITERAL(7, "yellow", "yellow"),
	/**
	 * The '<em><b>Green</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GREEN
	 * @generated
	 * @ordered
	 */
	GREEN_LITERAL(8, "green", "green"),
	/**
	 * The '<em><b>Light Green</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIGHT_GREEN
	 * @generated
	 * @ordered
	 */
	LIGHT_GREEN_LITERAL(9, "lightGreen", "lightGreen"),
	/**
	 * The '<em><b>Dark Green</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DARK_GREEN
	 * @generated
	 * @ordered
	 */
	DARK_GREEN_LITERAL(10, "darkGreen", "darkGreen"),
	/**
	 * The '<em><b>Cyan</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CYAN
	 * @generated
	 * @ordered
	 */
	CYAN_LITERAL(11, "cyan", "cyan"),
	/**
	 * The '<em><b>Light Blue</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIGHT_BLUE
	 * @generated
	 * @ordered
	 */
	LIGHT_BLUE_LITERAL(12, "lightBlue", "lightBlue"),
	/**
	 * The '<em><b>Blue</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLUE
	 * @generated
	 * @ordered
	 */
	BLUE_LITERAL(13, "blue", "blue"),
	/**
	 * The '<em><b>Dark Blue</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DARK_BLUE
	 * @generated
	 * @ordered
	 */
	DARK_BLUE_LITERAL(14, "darkBlue", "darkBlue");
	/**
	 * The '<em><b>White</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>White</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WHITE_LITERAL
	 * @model name="white"
	 * @generated
	 * @ordered
	 */
	public static final int WHITE = 0;

	/**
	 * The '<em><b>Black</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Black</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BLACK_LITERAL
	 * @model name="black"
	 * @generated
	 * @ordered
	 */
	public static final int BLACK = 1;

	/**
	 * The '<em><b>Light Gray</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Light Gray</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIGHT_GRAY_LITERAL
	 * @model name="lightGray"
	 * @generated
	 * @ordered
	 */
	public static final int LIGHT_GRAY = 2;

	/**
	 * The '<em><b>Gray</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Gray</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GRAY_LITERAL
	 * @model name="gray"
	 * @generated
	 * @ordered
	 */
	public static final int GRAY = 3;

	/**
	 * The '<em><b>Dark Gray</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Dark Gray</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DARK_GRAY_LITERAL
	 * @model name="darkGray"
	 * @generated
	 * @ordered
	 */
	public static final int DARK_GRAY = 4;

	/**
	 * The '<em><b>Red</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Red</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RED_LITERAL
	 * @model name="red"
	 * @generated
	 * @ordered
	 */
	public static final int RED = 5;

	/**
	 * The '<em><b>Orange</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Orange</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ORANGE_LITERAL
	 * @model name="orange"
	 * @generated
	 * @ordered
	 */
	public static final int ORANGE = 6;

	/**
	 * The '<em><b>Yellow</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Yellow</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #YELLOW_LITERAL
	 * @model name="yellow"
	 * @generated
	 * @ordered
	 */
	public static final int YELLOW = 7;

	/**
	 * The '<em><b>Green</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Green</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GREEN_LITERAL
	 * @model name="green"
	 * @generated
	 * @ordered
	 */
	public static final int GREEN = 8;

	/**
	 * The '<em><b>Light Green</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Light Green</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIGHT_GREEN_LITERAL
	 * @model name="lightGreen"
	 * @generated
	 * @ordered
	 */
	public static final int LIGHT_GREEN = 9;

	/**
	 * The '<em><b>Dark Green</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Dark Green</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DARK_GREEN_LITERAL
	 * @model name="darkGreen"
	 * @generated
	 * @ordered
	 */
	public static final int DARK_GREEN = 10;

	/**
	 * The '<em><b>Cyan</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Cyan</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CYAN_LITERAL
	 * @model name="cyan"
	 * @generated
	 * @ordered
	 */
	public static final int CYAN = 11;

	/**
	 * The '<em><b>Light Blue</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Light Blue</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIGHT_BLUE_LITERAL
	 * @model name="lightBlue"
	 * @generated
	 * @ordered
	 */
	public static final int LIGHT_BLUE = 12;

	/**
	 * The '<em><b>Blue</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Blue</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BLUE_LITERAL
	 * @model name="blue"
	 * @generated
	 * @ordered
	 */
	public static final int BLUE = 13;

	/**
	 * The '<em><b>Dark Blue</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Dark Blue</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DARK_BLUE_LITERAL
	 * @model name="darkBlue"
	 * @generated
	 * @ordered
	 */
	public static final int DARK_BLUE = 14;

	/**
	 * An array of all the '<em><b>Color Constants</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ColorConstants[] VALUES_ARRAY =
		new ColorConstants[] {
			WHITE_LITERAL,
			BLACK_LITERAL,
			LIGHT_GRAY_LITERAL,
			GRAY_LITERAL,
			DARK_GRAY_LITERAL,
			RED_LITERAL,
			ORANGE_LITERAL,
			YELLOW_LITERAL,
			GREEN_LITERAL,
			LIGHT_GREEN_LITERAL,
			DARK_GREEN_LITERAL,
			CYAN_LITERAL,
			LIGHT_BLUE_LITERAL,
			BLUE_LITERAL,
			DARK_BLUE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Color Constants</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ColorConstants> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Color Constants</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ColorConstants get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ColorConstants result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Color Constants</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ColorConstants getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ColorConstants result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Color Constants</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ColorConstants get(int value) {
		switch (value) {
			case WHITE: return WHITE_LITERAL;
			case BLACK: return BLACK_LITERAL;
			case LIGHT_GRAY: return LIGHT_GRAY_LITERAL;
			case GRAY: return GRAY_LITERAL;
			case DARK_GRAY: return DARK_GRAY_LITERAL;
			case RED: return RED_LITERAL;
			case ORANGE: return ORANGE_LITERAL;
			case YELLOW: return YELLOW_LITERAL;
			case GREEN: return GREEN_LITERAL;
			case LIGHT_GREEN: return LIGHT_GREEN_LITERAL;
			case DARK_GREEN: return DARK_GREEN_LITERAL;
			case CYAN: return CYAN_LITERAL;
			case LIGHT_BLUE: return LIGHT_BLUE_LITERAL;
			case BLUE: return BLUE_LITERAL;
			case DARK_BLUE: return DARK_BLUE_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ColorConstants(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
}
