/*
 * Decompiled with CFR 0.152.
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.papyrus.gmf.gmfgraph.Alignment;
import org.eclipse.papyrus.gmf.gmfgraph.BasicFont;
import org.eclipse.papyrus.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.Color;
import org.eclipse.papyrus.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.papyrus.gmf.gmfgraph.CustomFigure;
import org.eclipse.papyrus.gmf.gmfgraph.DecorationFigure;
import org.eclipse.papyrus.gmf.gmfgraph.Ellipse;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureAccessor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.Label;
import org.eclipse.papyrus.gmf.gmfgraph.Polyline;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineConnection;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.papyrus.gmf.gmfgraph.Rectangle;
import org.eclipse.papyrus.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.papyrus.gmf.gmfgraph.SVGProperty;
import org.eclipse.papyrus.gmf.gmfgraph.SVGPropertyType;
import org.eclipse.papyrus.gmf.gmfgraph.Shape;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;

    public String compilationUnitName(FigureDescriptor figure) {
        return StringExtensions.toFirstUpper((String)figure.getName());
    }

    public boolean hasSourceDecoration(PolylineConnection figure) {
        DecorationFigure _sourceDecoration = figure.getSourceDecoration();
        return !Objects.equal(null, (Object)_sourceDecoration);
    }

    public Iterable<String> requiredBundles(Iterable<String> referencedBundles) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new String[]{"org.eclipse.core.runtime", "org.eclipse.draw2d"});
        boolean _isFullRuntime = this.isFullRuntime();
        if (_isFullRuntime) {
            result.add("org.eclipse.gmf.runtime.draw2d.ui");
        }
        Iterables.addAll((Collection)result, referencedBundles);
        return IterableExtensions.sort((Iterable)result);
    }

    public boolean isFullRuntime() {
        return true;
    }

    public boolean hasTargetDecoration(PolylineConnection figure) {
        DecorationFigure _targetDecoration = figure.getTargetDecoration();
        return !Objects.equal(null, (Object)_targetDecoration);
    }

    protected boolean _needsField(RealFigure figure) {
        return this.realFigureNeedsField(figure);
    }

    protected boolean _needsField(CustomFigure figure) {
        return this.customFigureNeedsField(figure) || this.realFigureNeedsField((RealFigure)figure);
    }

    public boolean customFigureNeedsField(CustomFigure figure) {
        return this.hasDescriptor((RealFigure)figure) && !figure.getCustomChildren().isEmpty();
    }

    public boolean realFigureNeedsField(final RealFigure figure) {
        return this.hasDescriptor(figure) && IterableExtensions.exists((Iterable)figure.getDescriptor().getAccessors(), (Functions.Function1)new Functions.Function1<ChildAccess, Boolean>(){

            public Boolean apply(ChildAccess a) {
                Figure _figure = a.getFigure();
                return Objects.equal((Object)_figure, (Object)figure);
            }
        });
    }

    public boolean hasDescriptor(RealFigure figure) {
        FigureDescriptor _descriptor = figure.getDescriptor();
        return !Objects.equal((Object)_descriptor, null);
    }

    public String figureVariableName(RealFigure figure, int count) {
        boolean _needsField = this.needsField(figure);
        if (_needsField) {
            return this.figureFieldName(figure);
        }
        String _xifexpression = null;
        boolean _nullOrSpaces = this._common_qvto.nullOrSpaces(figure.getName());
        _xifexpression = _nullOrSpaces ? this.variableNameStem((Figure)figure) : StringExtensions.toFirstLower((String)figure.getName());
        String base = _xifexpression;
        return String.valueOf(base) + Integer.valueOf(count);
    }

    protected String _nameStem(FigureRef xptSelf) {
        return this.variableNameStem((Figure)xptSelf.getFigure());
    }

    protected String _nameStem(Figure xptSelf) {
        return this.variableNameStem(xptSelf);
    }

    protected String _variableNameStem(Figure xptSelf) {
        return "fig";
    }

    protected String _variableNameStem(RealFigure xptSelf) {
        return "fig";
    }

    protected String _variableNameStem(Shape xptSelf) {
        return "shape";
    }

    protected String _variableNameStem(Rectangle xptSelf) {
        return "rect";
    }

    protected String _variableNameStem(RoundedRectangle xptSelf) {
        return "rrect";
    }

    protected String _variableNameStem(Ellipse xptSelf) {
        return "elli";
    }

    protected String _variableNameStem(Polyline xptSelf) {
        return "polyline";
    }

    protected String _variableNameStem(Label xptSelf) {
        return "l";
    }

    protected String _variableNameStem(DecorationFigure xptSelf) {
        return "dec";
    }

    protected String _variableNameStem(ConnectionFigure xptSelf) {
        return "conn";
    }

    protected String _figureFieldName(final RealFigure xptSelf) {
        Functions.Function1<ChildAccess, Boolean> _function = new Functions.Function1<ChildAccess, Boolean>(){

            public Boolean apply(ChildAccess a) {
                Figure _figure = a.getFigure();
                return Objects.equal((Object)xptSelf, (Object)_figure);
            }
        };
        return this.figureFieldName(IterableExtensions.filter((Iterable)xptSelf.getDescriptor().getAccessors(), (Functions.Function1)_function));
    }

    protected String _figureFieldName(ChildAccess xptSelf) {
        String _trimPrefixIfAny = this.trimPrefixIfAny(xptSelf.getAccessor(), "get");
        return "f" + _trimPrefixIfAny;
    }

    protected String _figureFieldName(CustomFigure xptSelf) {
        String _firstUpper = StringExtensions.toFirstUpper((String)xptSelf.getName());
        return "my" + _firstUpper;
    }

    protected String _figureFieldName(Iterable<ChildAccess> accesses) {
        Functions.Function1<ChildAccess, String> _function = new Functions.Function1<ChildAccess, String>(){

            public String apply(ChildAccess x) {
                return Utils_qvto.this.figureFieldName(x);
            }
        };
        return (String)IterableExtensions.head((Iterable)IterableExtensions.map(accesses, (Functions.Function1)_function));
    }

    public String borderLayoutConstant(BorderLayoutData layoutData) {
        String _switchResult = null;
        Alignment _alignment = layoutData.getAlignment();
        if (_alignment != null) {
            switch (_alignment) {
                case BEGINNING_LITERAL: {
                    String _xifexpression = null;
                    boolean _isVertical = layoutData.isVertical();
                    _xifexpression = _isVertical ? "TOP" : "LEFT";
                    _switchResult = _xifexpression;
                    break;
                }
                case END_LITERAL: {
                    String _xifexpression_1 = null;
                    boolean _isVertical_1 = layoutData.isVertical();
                    _xifexpression_1 = _isVertical_1 ? "BOTTOM" : "RIGHT";
                    _switchResult = _xifexpression_1;
                    break;
                }
                default: {
                    _switchResult = "CENTER";
                    break;
                }
            }
        } else {
            _switchResult = "CENTER";
        }
        return _switchResult;
    }

    public Iterable<FigureAccessor> allCustomAccessors(FigureDescriptor fd) {
        Functions.Function1<CustomFigure, EList<FigureAccessor>> _function = new Functions.Function1<CustomFigure, EList<FigureAccessor>>(){

            public EList<FigureAccessor> apply(CustomFigure cf) {
                return cf.getCustomChildren();
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map(this.filterCustom(CollectionLiterals.newLinkedList((Object[])new Figure[]{fd.getActualFigure()})), (Functions.Function1)_function));
    }

    public Iterable<CustomFigure> filterCustom(Iterable<Figure> figures) {
        LinkedList result = CollectionLiterals.newLinkedList();
        this.deepCollectCustom(figures, result);
        return result;
    }

    protected void deepCollectCustom(Iterable<Figure> figures, List<CustomFigure> acc) {
        boolean _isEmpty = IterableExtensions.isEmpty(figures);
        if (_isEmpty) {
            return;
        }
        Iterables.addAll(acc, (Iterable)Iterables.filter(figures, CustomFigure.class));
        Functions.Function1<RealFigure, EList<Figure>> _function = new Functions.Function1<RealFigure, EList<Figure>>(){

            public EList<Figure> apply(RealFigure rf) {
                return rf.getChildren();
            }
        };
        this.deepCollectCustom(Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(figures, RealFigure.class), (Functions.Function1)_function)), acc);
        Functions.Function1<CustomFigure, EList<FigureAccessor>> _function_1 = new Functions.Function1<CustomFigure, EList<FigureAccessor>>(){

            public EList<FigureAccessor> apply(CustomFigure rf) {
                return rf.getCustomChildren();
            }
        };
        Functions.Function1<FigureAccessor, RealFigure> _function_2 = new Functions.Function1<FigureAccessor, RealFigure>(){

            public RealFigure apply(FigureAccessor cc) {
                return cc.getTypedFigure();
            }
        };
        this.deepCollectCustom(Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(figures, CustomFigure.class), (Functions.Function1)_function_1)), (Functions.Function1)_function_2), Figure.class), acc);
    }

    public LinkedList<FigureAccessor> getCustomFigureChainFigureAccess(ChildAccess it) {
        LinkedList result = CollectionLiterals.newLinkedList();
        boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it.getFigure(), CustomFigure.class);
        if (_oclIsKindOf) {
            Figure _figure = it.getFigure();
            CustomFigure cf = (CustomFigure)_figure;
            while (this._common_qvto.oclIsKindOf(cf.eContainer(), FigureAccessor.class)) {
                EObject _eContainer = cf.eContainer();
                result.push((FigureAccessor)_eContainer);
                EObject _eContainer_1 = cf.eContainer().eContainer();
                cf = (CustomFigure)_eContainer_1;
            }
        }
        return result;
    }

    public String svgPropertyType(SVGProperty p) {
        String _switchResult = null;
        SVGPropertyType _type = p.getType();
        if (_type != null) {
            switch (_type) {
                case COLOR: {
                    _switchResult = "org.eclipse.swt.graphics.Color";
                    break;
                }
                case FLOAT: {
                    _switchResult = "float";
                    break;
                }
                default: {
                    _switchResult = "String";
                    break;
                }
            }
        } else {
            _switchResult = "String";
        }
        return _switchResult;
    }

    @MetaDef
    public String fontVariableName(BasicFont it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        return String.valueOf(_upperCase) + "_FONT";
    }

    @MetaDef
    public String backgroundColorVariableName(Color it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        return String.valueOf(_upperCase) + "_BACK";
    }

    @MetaDef
    public String foregroundColorVariableName(Color it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        return String.valueOf(_upperCase) + "_FORE";
    }

    protected String trimPrefixIfAny(String text, String prefix) {
        String _xifexpression = null;
        _xifexpression = text.startsWith(prefix) && text.length() > prefix.length() ? text.substring(prefix.length()) : text;
        return _xifexpression;
    }

    public boolean needsField(RealFigure figure) {
        if (figure instanceof CustomFigure) {
            return this._needsField((CustomFigure)figure);
        }
        if (figure != null) {
            return this._needsField(figure);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(figure).toString());
    }

    public String nameStem(Figure xptSelf) {
        if (xptSelf instanceof FigureRef) {
            return this._nameStem((FigureRef)xptSelf);
        }
        if (xptSelf != null) {
            return this._nameStem(xptSelf);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xptSelf).toString());
    }

    public String variableNameStem(Figure xptSelf) {
        if (xptSelf instanceof Ellipse) {
            return this._variableNameStem((Ellipse)xptSelf);
        }
        if (xptSelf instanceof Polyline) {
            return this._variableNameStem((Polyline)xptSelf);
        }
        if (xptSelf instanceof Rectangle) {
            return this._variableNameStem((Rectangle)xptSelf);
        }
        if (xptSelf instanceof RoundedRectangle) {
            return this._variableNameStem((RoundedRectangle)xptSelf);
        }
        if (xptSelf instanceof ConnectionFigure) {
            return this._variableNameStem((ConnectionFigure)xptSelf);
        }
        if (xptSelf instanceof DecorationFigure) {
            return this._variableNameStem((DecorationFigure)xptSelf);
        }
        if (xptSelf instanceof Label) {
            return this._variableNameStem((Label)xptSelf);
        }
        if (xptSelf instanceof Shape) {
            return this._variableNameStem((Shape)xptSelf);
        }
        if (xptSelf instanceof RealFigure) {
            return this._variableNameStem((RealFigure)xptSelf);
        }
        if (xptSelf != null) {
            return this._variableNameStem(xptSelf);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xptSelf).toString());
    }

    public String figureFieldName(Object xptSelf) {
        if (xptSelf instanceof CustomFigure) {
            return this._figureFieldName((CustomFigure)xptSelf);
        }
        if (xptSelf instanceof RealFigure) {
            return this._figureFieldName((RealFigure)xptSelf);
        }
        if (xptSelf instanceof ChildAccess) {
            return this._figureFieldName((ChildAccess)xptSelf);
        }
        if (xptSelf instanceof Iterable) {
            return this._figureFieldName((Iterable)xptSelf);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xptSelf).toString());
    }
}

