/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.wizards.strategy;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.strategy.Hierarchy;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.strategy.Strategy;

public class CompositeStrategy<T extends EObject>
implements Strategy<T> {
    private final Strategy<T>[] myStrategies;

    public CompositeStrategy(Strategy<T> ... strategies) {
        assert (strategies != null);
        this.myStrategies = strategies;
        int i = 0;
        while (i < strategies.length) {
            if (strategies[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
    }

    @Override
    public String getID() {
        return "composite";
    }

    @Override
    public void filter(Collection<T> soFar, Hierarchy hierarchy) {
        int i = 0;
        while (i < this.myStrategies.length) {
            this.myStrategies[i].filter(soFar, hierarchy);
            ++i;
        }
    }
}

