/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.legacy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class TreePath {
    private Resource resource;
    private List<EObject> segments = new ArrayList<EObject>();
    private List<EReference> segmentContainers = new ArrayList<EReference>();

    public TreePath(Resource resource) {
        this.resource = resource;
    }

    protected TreePath(Resource resource, List<EObject> segments, List<EReference> segmentContainers) {
        this.resource = resource;
        this.segments.addAll(segments);
        this.segmentContainers.addAll(segmentContainers);
    }

    public void addToLastSegmentContainer(EObject eobject) {
        if (this.getLastSegment() == null) {
            this.getResource().getContents().add((Object)eobject);
        } else {
            this.addToSegmentContainer(this.segments.size() - 1, eobject);
        }
    }

    public void addToSegmentContainer(int index, EObject eobject) {
        EObject segment = this.getSegment(index);
        EReference container = this.getSegmentContainer(index);
        if (segment == null) {
            throw new IndexOutOfBoundsException("List size is " + this.segments.size() + ", requred index is " + index);
        }
        Object containerValue = segment.eGet((EStructuralFeature)container);
        if (!container.isMany()) {
            this.getSegment(index).eSet((EStructuralFeature)container, (Object)eobject);
        } else if (containerValue instanceof List) {
            ((List)containerValue).add(eobject);
        } else {
            throw new IllegalArgumentException("Unsupported EReference value - " + containerValue.getClass());
        }
    }

    public TreePath createChildTreePath(EObject segment, EReference container) {
        TreePath tp = new TreePath(this.resource, this.segments, this.segmentContainers);
        tp.segments.add(segment);
        tp.segmentContainers.add(container);
        return tp;
    }

    public EObject getLastSegment() {
        if (this.segments.size() == 0) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public EReference getLastSegmentContainer() {
        if (this.segmentContainers.size() == 0) {
            return null;
        }
        return this.segmentContainers.get(this.segmentContainers.size() - 1);
    }

    public Resource getResource() {
        return this.resource;
    }

    public EObject getSegment(int index) {
        return this.segments.get(index);
    }

    public EObject getSegment(String eclassName) {
        if (eclassName == null) {
            return null;
        }
        for (EObject eo : this.segments) {
            if (!eclassName.equals(eo.eClass().getName())) continue;
            return eo;
        }
        return null;
    }

    public EReference getSegmentContainer(int index) {
        return this.segmentContainers.get(index);
    }

    public EReference getSegmentContainer(String eclassName) {
        if (eclassName == null) {
            return null;
        }
        int i = 0;
        while (i < this.segmentContainers.size()) {
            if (eclassName.equals(this.segments.get(i).eClass().getName())) {
                return this.segmentContainers.get(i);
            }
            ++i;
        }
        return null;
    }
}

