/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;

public class ArchitectureBuildChecker
implements IPluginChecker {
    private final IProject project;
    private final IFile architectureFile;

    public ArchitectureBuildChecker(IProject project, IFile architectureFile) {
        this.project = project;
        this.architectureFile = architectureFile;
    }

    public void check(IProgressMonitor monitor) {
        IBuildModel buildModel;
        if (monitor != null) {
            monitor.subTask("Validate 'build.properties' file for architecture '" + this.architectureFile.getName() + "'.");
        }
        if ((buildModel = ProjectManagementService.getPluginBuild((IProject)this.project)) != null) {
            boolean containsProfile = false;
            String profilePath = this.architectureFile.getProjectRelativePath().toString();
            IBuild build = buildModel.getBuild();
            IBuildEntry buildEntry = build.getEntry("bin.includes");
            String[] tokens = buildEntry.getTokens();
            int i = 0;
            while (i < tokens.length && !containsProfile) {
                containsProfile = profilePath.startsWith(tokens[i]);
                ++i;
            }
            if (!containsProfile) {
                IFile buildPropertiesFile = ProjectManagementService.getBuildFile((IContainer)this.project);
                MarkersService.createMarker((IResource)buildPropertiesFile, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", (String)("The build does not contains entry for file '" + profilePath + "'."), (int)2);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

