/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.nattable.common.handlers.PolicyDefinedTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableViewPrototype
extends ViewPrototype {
    private TableConfiguration configuration;

    public TableViewPrototype(PapyrusTable prototype) {
        super((PapyrusRepresentationKind)prototype);
        this.configuration = prototype.getConfiguration();
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        if (this.configuration == null) {
            return false;
        }
        PolicyDefinedTableHandler handler = new PolicyDefinedTableHandler(this.configuration, owner, name);
        return handler.execute(this);
    }

    public Command getCommandChangeOwner(EObject view, final EObject target) {
        final Table table = (Table)view;
        final EObject previous = table.getOwner();
        return new AbstractCommand("Change table owner"){

            public void execute() {
                table.setOwner(target);
            }

            public void undo() {
                table.setOwner(previous);
            }

            public void redo() {
                table.setOwner(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public Command getCommandChangeRoot(EObject view, final EObject target) {
        final Table table = (Table)view;
        final EObject previous = table.getContext();
        return new AbstractCommand("Change table root element"){

            public void execute() {
                table.setContext(target);
            }

            public void undo() {
                table.setContext(previous);
            }

            public void redo() {
                table.setContext(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public EObject getOwnerOf(EObject view) {
        return ((Table)view).getOwner();
    }

    public EObject getRootOf(EObject view) {
        return ((Table)view).getContext();
    }
}

