/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;

public class SetMultiplicityCommand
extends CompoundCommand {
    private int[] lowerUpper;
    private MultiplicityElement element;
    static EStructuralFeature lowerFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Lower();
    static EStructuralFeature lowerFeatureVS = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
    static EStructuralFeature upperFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Upper();
    static EStructuralFeature upperFeatureVS = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();

    public SetMultiplicityCommand(MultiplicityElement element, String value) {
        if (element == null) {
            return;
        }
        int[] lowerUpper = MultiplicityParser.getBounds(value);
        if (lowerUpper == null || lowerUpper.length < 2) {
            return;
        }
        int lower = lowerUpper[0];
        int upper = lowerUpper[1];
        if (!MultiplicityParser.isValidMultiplicity(lower, upper)) {
            return;
        }
        this.lowerUpper = lowerUpper;
        this.element = element;
        this.append(this.getSetCommand(lowerFeature, lowerFeatureVS, lower));
        this.append(this.getSetCommand(upperFeature, upperFeatureVS, upper));
    }

    private Command getSetCommand(EStructuralFeature feature, EStructuralFeature featureVS, int value) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.element);
        if (provider != null) {
            SetRequest request = value == 1 ? new SetRequest((EObject)this.element, featureVS, null) : new SetRequest((EObject)this.element, feature, (Object)value);
            ICommand gmfCommand = provider.getEditCommand((IEditCommandRequest)request);
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(gmfCommand);
            return emfCommand;
        }
        return null;
    }

    public boolean canExecute() {
        return this.element != null && this.lowerUpper != null && this.lowerUpper.length == 2 && super.canExecute();
    }
}

