/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Nicolas FAUVERGUE (ALL4TEC) nicolas.fauvergue@all4tec.net - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.infra.internationalization.common.utils;

/**
 * This class defines the constants for the internationalization preferences.
 */
public class InternationalizationPreferencesConstants {

	/**
	 * The internationalization preference label.
	 */
	public static final String USE_INTERNATIONALIZATION_PREFERENCE = "useInternationalization"; //$NON-NLS-1$
	
	/**
	 * The label for the internationalization annotation.
	 */
	public static final String INTERNATIONALIZATION_ANNOTATION_LABEL = "Internationalization"; //$NON-NLS-1$
	
	/**
	 * The label of the internationalization annotation detail.
	 */
	public static final String USE_DETAIL_ANNOTATION_LABEL = "use"; //$NON-NLS-1$
	
	/**
	 * The language preference name.
	 */
	public static final String LANGUAGE_PREFERENCE = "language"; //$NON-NLS-1$
	
	/**
	 * The preference constant to determinate if the internationalization must be used or not.
	 */
	public static final String LOAD_INTERNATIONALIZATION = "loadInternationalization"; //$NON-NLS-1$
	
	/**
	 * The preference constant to determinate if the internationalization of the external files must be used or not.
	 */
	public static final String LOAD_INTERNATIONALIZATION_OF_EXTERNAL_FILES = "loadInternationalizationofExternalFiles"; //$NON-NLS-1$
	
}
