/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPalettePreferences;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.ui.IEditorPart;

public class PaletteUtil {
    public static PaletteContainer getContainerByID(PaletteContainer container, String parentID) {
        if (parentID.equals(container.getId())) {
            return container;
        }
        Iterator<PaletteContainer> it = PaletteUtil.getDirectChildContainers(container).iterator();
        while (it.hasNext()) {
            PaletteContainer tmp = PaletteUtil.getContainerByID(it.next(), parentID);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    public static EClass getToolMetaclass(ToolEntry entry) {
        EClass eClass = null;
        Tool tool = entry.createTool();
        List<IElementType> types = null;
        if (tool instanceof AspectUnspecifiedTypeCreationTool) {
            types = ((AspectUnspecifiedTypeCreationTool)tool).getElementTypes();
        } else if (tool instanceof AspectUnspecifiedTypeConnectionTool) {
            types = ((AspectUnspecifiedTypeConnectionTool)tool).getElementTypes();
        }
        if (types != null && types.size() > 0) {
            IElementType type = types.get(0);
            if (type instanceof SpecializationType) {
                type = ((SpecializationType)type).getSpecializedTypes()[0];
            }
            if (type != null) {
                eClass = type.getEClass();
            }
        }
        return eClass;
    }

    public static PaletteContainer getContainerByID(PaletteEntry entry, String parentID) {
        PaletteContainer root = PaletteUtil.getRoot(entry);
        return PaletteUtil.getContainerByID(root, parentID);
    }

    public static List<PaletteContainer> getDirectChildContainers(PaletteContainer container) {
        ArrayList<PaletteContainer> containers = new ArrayList<PaletteContainer>();
        for (PaletteEntry entry : container.getChildren()) {
            if (!(entry instanceof PaletteContainer)) continue;
            containers.add((PaletteContainer)entry);
        }
        return containers;
    }

    public static PaletteContainer getRoot(PaletteContainer container) {
        if (container.getParent() != null) {
            return PaletteUtil.getRoot(container.getParent());
        }
        return container;
    }

    public static PaletteContainer getRoot(PaletteEntry entry) {
        return PaletteUtil.getRoot(entry.getParent());
    }

    private PaletteUtil() {
    }

    public static List<ToolEntry> getAllToolEntries(PaletteContainer container) {
        ArrayList<ToolEntry> entries = new ArrayList<ToolEntry>();
        for (PaletteEntry entry : container.getChildren()) {
            if (entry instanceof ToolEntry) {
                entries.add((ToolEntry)entry);
            }
            if (!(entry instanceof PaletteContainer)) continue;
            entries.addAll(PaletteUtil.getAllToolEntries((PaletteContainer)entry));
        }
        return entries;
    }

    public static List<PaletteEntry> getAllEntries(PaletteContainer container) {
        ArrayList<PaletteEntry> elements = new ArrayList<PaletteEntry>();
        for (Object object : container.getChildren()) {
            if (object instanceof PaletteContainer) {
                elements.add((PaletteEntry)((PaletteContainer)object));
                elements.addAll(PaletteUtil.getAllEntries((PaletteContainer)object));
                continue;
            }
            if (!(object instanceof ToolEntry)) continue;
            elements.add((PaletteEntry)((ToolEntry)object));
        }
        return elements;
    }

    public static Set<? extends PaletteEntry> getAvailableEntries(IEditorPart part, ProviderPriority priority) {
        HashSet entries = new HashSet();
        PaletteRoot root = new PaletteRoot();
        List<? extends Service.ProviderDescriptor> providers = PapyrusPaletteService.getInstance().getProviders();
        ContributeToPaletteOperation operation = new ContributeToPaletteOperation(part, (Object)part.getEditorInput(), root, new HashMap());
        List<? extends Service.ProviderDescriptor> providerList = PapyrusPaletteService.getInstance().getProviders();
        for (PapyrusPaletteService.ProviderDescriptor providerDescriptor : providerList) {
            int compare = providerDescriptor.getPriority().compareTo((Object)priority);
            if (compare >= 0 || !providerDescriptor.providesWithVisibility(operation)) continue;
            ((IPaletteProvider)providerDescriptor.getProvider()).contributeToPalette(part, (Object)part.getEditorInput(), root, new HashMap());
        }
        return entries;
    }

    public static Map<String, PaletteEntry> getAvailableEntriesSet(IEditorPart part, ProviderPriority priority) {
        HashMap<String, PaletteEntry> entries = new HashMap<String, PaletteEntry>();
        PaletteRoot root = new PaletteRoot();
        List<? extends Service.ProviderDescriptor> providers = PapyrusPaletteService.getInstance().getProviders();
        ContributeToPaletteOperation operation = new ContributeToPaletteOperation(part, (Object)part.getEditorInput(), root, entries);
        List<? extends Service.ProviderDescriptor> providerList = PapyrusPaletteService.getInstance().getProviders();
        for (PapyrusPaletteService.ProviderDescriptor providerDescriptor : providerList) {
            int compare = providerDescriptor.getPriority().compareTo((Object)priority);
            if (compare > 0 || !providerDescriptor.providesWithVisibility(operation)) continue;
            ((IPaletteProvider)providerDescriptor.getProvider()).contributeToPalette(part, (Object)part.getEditorInput(), root, entries);
        }
        return entries;
    }

    public static List<String> getStereotypeListFromString(String serializedForm) {
        StringTokenizer tokenizer = new StringTokenizer(serializedForm, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    public static String convertToCommaSeparatedRepresentation(Collection objects) {
        return PaletteUtil.convertToFlatRepresentation(objects, ",");
    }

    public static String convertToFlatRepresentation(Collection objects, String separator) {
        StringBuilder buffer = new StringBuilder();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static Set<String> getProfileSetFromString(String serializedForm) {
        StringTokenizer tokenizer = new StringTokenizer(serializedForm, ",");
        HashSet<String> list = new HashSet<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static URI getRedefinitionFileURI(String contributionID) {
        String path = PapyrusPalettePreferences.getPaletteRedefinition(contributionID);
        StringBuilder error = new StringBuilder();
        URI uri = null;
        if (path == null) {
            error.append(Messages.PaletteUtil_ErrorMessage_PaletteNullOnContribution);
            error.append(contributionID);
        } else {
            File stateLocationRootFile = Activator.getInstance().getStateLocation().append(path).toFile();
            if (stateLocationRootFile == null) {
                error.append(Messages.PaletteUtil_ErrorMessage_NoRedefinitionFoundWithId);
                error.append(contributionID);
            } else if (!stateLocationRootFile.exists()) {
                error.append(Messages.PaletteUtil_ErrorMessage_NoLocalDefinition);
                error.append(stateLocationRootFile);
            } else if (!stateLocationRootFile.canRead()) {
                error.append(Messages.PaletteUtil_ErrorMessage_CantReadLocalDefinitionOfFile);
                error.append(stateLocationRootFile);
            } else {
                uri = URI.createFileURI((String)stateLocationRootFile.getAbsolutePath());
            }
        }
        if (!error.toString().isEmpty()) {
            Activator.log.error(error.toString(), null);
        }
        return uri;
    }

    public static String getSerializedProfileList(Collection<String> profiles) {
        return PaletteUtil.convertToCommaSeparatedRepresentation(profiles);
    }
}

