/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.HighlightEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public class CustomEditPolicyProvider
implements IEditPolicyProvider {
    public void addProviderChangeListener(IProviderChangeListener listener) {
    }

    public void createEditPolicies(EditPart editPart) {
        this.installEditPolicy(editPart, (EditPolicy)new HighlightEditPolicy(), "Highlight Edit Policy");
    }

    private void installEditPolicy(EditPart editPart, EditPolicy editPolicy, String role) {
        if (editPart == null || editPolicy == null) {
            return;
        }
        EditPolicy myEditPolicy = editPart.getEditPolicy((Object)role);
        if (myEditPolicy == null) {
            editPart.installEditPolicy((Object)role, editPolicy);
        }
    }

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation;
        block6: {
            EditPart editPart;
            block5: {
                epOperation = (CreateEditPoliciesOperation)operation;
                if (!ProviderServiceUtil.isEnabled(this, epOperation.getEditPart())) {
                    return false;
                }
                try {
                    editPart = epOperation.getEditPart();
                    if (editPart instanceof GraphicalEditPart) break block5;
                    return false;
                }
                catch (ServiceException e) {
                    return false;
                }
            }
            EditingDomain domain = EMFHelper.resolveEditingDomain((Object)editPart);
            if (domain != null) break block6;
            return false;
        }
        ServicesRegistry registry = ServiceUtilsForEditPart.getInstance().getServiceRegistry(epOperation.getEditPart());
        return registry != null;
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
    }
}

