/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.codegen;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.xtend.ui.handlers.CodegenEmittersWithXtend2;
import org.eclipse.gmf.codegen.xtend.ui.handlers.GeneratorWithXtend2;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.papyrus.codegen.PapyrusCodegenEmitters;

public class PapyrusGenerator
extends GeneratorWithXtend2 {
    private final PapyrusCodegenEmitters emitters;
    private GenEditorGenerator editorGen;

    public PapyrusGenerator(GenEditorGenerator genModel, PapyrusCodegenEmitters codegenEmitters) {
        super(genModel, (CodegenEmittersWithXtend2)codegenEmitters);
        this.editorGen = genModel;
        this.emitters = codegenEmitters;
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        super.customRun();
    }

    protected void generatePaletteConfiguration() throws UnexpectedBehaviourException, InterruptedException {
        if (this.editorGen.getDiagram().getPalette() == null) {
            return;
        }
        this.doGenerateFile(this.emitters.getPaletteConfigurationEmitter(), (IPath)new Path(String.valueOf(this.getRelativePath()) + File.separator + this.editorGen.getModelID() + ".paletteconfiguration"), new Object[]{this.editorGen});
    }

    protected String getRelativePath() {
        String path = null;
        URI resourceURI = this.editorGen.eResource().getURI();
        if (resourceURI.isPlatformResource()) {
            String platformString = resourceURI.toPlatformString(true);
            Path workspacePath = new Path(platformString);
            workspacePath = workspacePath.removeFirstSegments(1);
            workspacePath = workspacePath.removeLastSegments(1);
            path = workspacePath.toString();
        } else {
            path = "model";
        }
        return path;
    }
}

