/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.FilterReference;
import org.eclipse.papyrus.infra.filters.FilteredElement;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.util.FiltersSwitch;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.AssistantEditPlugin;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.AssistedElementTypeFilterItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.ConnectionAssistantItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.ElementTypeFilterItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.ModelingAssistantProviderItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.provider.PopupAssistantItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.util.AssistantAdapterFactory;

public class AssistantItemProviderAdapterFactory
extends AssistantAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable,
IChildCreationExtender {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager((ResourceLocator)AssistantEditPlugin.INSTANCE, "http://www.eclipse.org/Papyrus/2014/diagram/assistant");
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected AssistedElementTypeFilterItemProvider assistedElementTypeFilterItemProvider;
    protected ConnectionAssistantItemProvider connectionAssistantItemProvider;
    protected PopupAssistantItemProvider popupAssistantItemProvider;
    protected ElementTypeFilterItemProvider elementTypeFilterItemProvider;
    protected ModelingAssistantProviderItemProvider modelingAssistantProviderItemProvider;

    public AssistantItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createAssistedElementTypeFilterAdapter() {
        if (this.assistedElementTypeFilterItemProvider == null) {
            this.assistedElementTypeFilterItemProvider = new AssistedElementTypeFilterItemProvider((AdapterFactory)this);
        }
        return this.assistedElementTypeFilterItemProvider;
    }

    public Adapter createConnectionAssistantAdapter() {
        if (this.connectionAssistantItemProvider == null) {
            this.connectionAssistantItemProvider = new ConnectionAssistantItemProvider((AdapterFactory)this);
        }
        return this.connectionAssistantItemProvider;
    }

    public Adapter createPopupAssistantAdapter() {
        if (this.popupAssistantItemProvider == null) {
            this.popupAssistantItemProvider = new PopupAssistantItemProvider((AdapterFactory)this);
        }
        return this.popupAssistantItemProvider;
    }

    public Adapter createElementTypeFilterAdapter() {
        if (this.elementTypeFilterItemProvider == null) {
            this.elementTypeFilterItemProvider = new ElementTypeFilterItemProvider((AdapterFactory)this);
        }
        return this.elementTypeFilterItemProvider;
    }

    public Adapter createModelingAssistantProviderAdapter() {
        if (this.modelingAssistantProviderItemProvider == null) {
            this.modelingAssistantProviderItemProvider = new ModelingAssistantProviderItemProvider((AdapterFactory)this);
        }
        return this.modelingAssistantProviderItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.assistedElementTypeFilterItemProvider != null) {
            this.assistedElementTypeFilterItemProvider.dispose();
        }
        if (this.modelingAssistantProviderItemProvider != null) {
            this.modelingAssistantProviderItemProvider.dispose();
        }
        if (this.popupAssistantItemProvider != null) {
            this.popupAssistantItemProvider.dispose();
        }
        if (this.connectionAssistantItemProvider != null) {
            this.connectionAssistantItemProvider.dispose();
        }
        if (this.elementTypeFilterItemProvider != null) {
            this.elementTypeFilterItemProvider.dispose();
        }
    }

    public static class FiltersChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return AssistantEditPlugin.INSTANCE;
        }

        protected static class CreationSwitch
        extends FiltersSwitch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseFilterReference(FilterReference object) {
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER, AssistantFactory.eINSTANCE.createAssistedElementTypeFilter()));
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER, AssistantFactory.eINSTANCE.createElementTypeFilter()));
                return null;
            }

            public Object caseCompoundFilter(CompoundFilter object) {
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.COMPOUND_FILTER__OWNED_FILTER, AssistantFactory.eINSTANCE.createAssistedElementTypeFilter()));
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.COMPOUND_FILTER__OWNED_FILTER, AssistantFactory.eINSTANCE.createElementTypeFilter()));
                return null;
            }

            public Object caseFilteredElement(FilteredElement object) {
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTERED_ELEMENT__FILTER, AssistantFactory.eINSTANCE.createAssistedElementTypeFilter()));
                this.newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTERED_ELEMENT__FILTER, AssistantFactory.eINSTANCE.createElementTypeFilter()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }
}

