/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.clipboard;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.clipboard.ICopierFactory;
import org.eclipse.papyrus.infra.core.internal.clipboard.CopierConfiguratorRegistry;
import org.eclipse.papyrus.infra.core.internal.clipboard.DefaultConfiguration;

public class CopierFactory
implements ICopierFactory {
    private final ResourceSet resourceSet;
    private final boolean useOriginalReferences;

    public CopierFactory(ResourceSet resourceSet) {
        this(resourceSet, true);
    }

    public CopierFactory(ResourceSet resourceSet, boolean useOriginalReferences) {
        this.resourceSet = resourceSet;
        this.useOriginalReferences = useOriginalReferences;
    }

    public boolean isUseOriginalReferences() {
        return this.useOriginalReferences;
    }

    @Override
    public EcoreUtil.Copier get() {
        DefaultConfiguration configuration = new DefaultConfiguration(true, this.isUseOriginalReferences());
        CopierConfiguratorRegistry.INSTANCE.configureCopier(configuration);
        return this.createCopier(configuration);
    }

    private EcoreUtil.Copier createCopier(DefaultConfiguration configuration) {
        return configuration.isEmpty() ? this.createBasicCopier() : new ConfiguredCopier(configuration, this.getPackageRegistry());
    }

    private EcoreUtil.Copier createBasicCopier() {
        return new BasicCopier(true, this.isUseOriginalReferences(), this.getPackageRegistry());
    }

    private EPackage.Registry getPackageRegistry() {
        return this.resourceSet == null ? EPackage.Registry.INSTANCE : this.resourceSet.getPackageRegistry();
    }

    private static class BasicCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private final EPackage.Registry packageRegistry;

        BasicCopier(boolean resolveReferences, boolean useOriginalReferences, EPackage.Registry registry) {
            super(resolveReferences, useOriginalReferences);
            this.packageRegistry = registry;
        }

        protected EObject createCopy(EObject eObject) {
            EClass eClass = this.getTarget(eObject);
            EFactory eFactory = this.getEFactory(eClass);
            return eFactory.create(eClass);
        }

        EFactory getEFactory(EClass eClass) {
            EFactory result = this.packageRegistry.getEFactory(eClass.getEPackage().getNsURI());
            if (result == null) {
                result = eClass.getEPackage().getEFactoryInstance();
            }
            return result;
        }
    }

    private static class ConfiguredCopier
    extends BasicCopier {
        private static final long serialVersionUID = 1L;
        private final DefaultConfiguration configuration;

        ConfiguredCopier(DefaultConfiguration configuration, EPackage.Registry registry) {
            super(configuration.isResolveReferences(), configuration.isUseOriginalReferences(), registry);
            this.configuration = configuration;
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (this.configuration.shouldCopyReference(eReference, eObject)) {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }
    }
}

