/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.messages.Messages;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientSemanticCommand
extends EditElementCommand {
    private EObject oppositeEnd;
    private EObject newEnd;
    protected final int reorientDirection;
    private Property newPartWithPort;
    private Property oppositePartWithPort;

    public ConnectorReorientSemanticCommand(ReorientRelationshipRequest request) {
        this((ReorientRequest)request, request.getRelationship());
    }

    public ConnectorReorientSemanticCommand(ReorientReferenceRelationshipRequest request) {
        this((ReorientRequest)request, null);
    }

    private ConnectorReorientSemanticCommand(ReorientRequest request, EObject element2Edit) {
        super(request.getLabel(), element2Edit, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.newEnd = request.getNewRelationshipEnd();
        this.setupFields();
    }

    private void setupFields() {
        this.oppositeEnd = null;
        this.oppositePartWithPort = null;
        if (this.getElementToEdit() instanceof Connector) {
            ConnectorEnd source = (ConnectorEnd)this.getLink().getEnds().get(0);
            ConnectorEnd target = (ConnectorEnd)this.getLink().getEnds().get(1);
            this.oppositeEnd = this.isSourceRedirect() ? target.getRole() : source.getRole();
            this.oppositePartWithPort = this.isSourceRedirect() ? target.getPartWithPort() : source.getPartWithPort();
        }
        this.initFields();
    }

    private boolean isSourceRedirect() {
        return ((ConnectorEnd)this.getLink().getEnds().get(0)).getRole() == ((ReorientRequest)this.getRequest()).getOldRelationshipEnd();
    }

    protected void initFields() {
        this.newPartWithPort = (Property)this.getRequest().getParameter("partWithPort");
        this.oppositePartWithPort = (Property)this.getRequest().getParameter("oppositePartWithPort");
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.getLink().getEnds().size() != 2) {
            return false;
        }
        return this.canReorient(this.newEnd, this.oppositeEnd);
    }

    private boolean canReorient(EObject newRole, EObject oppositeRole) {
        if (newRole == null) {
            return true;
        }
        if (!(newRole instanceof ConnectableElement)) {
            return false;
        }
        if (oppositeRole != null && ConnectorUtils.applyUMLRulesForConnector(this.getLink())) {
            StructuredClassifier newContainer = this.deduceParentConnector(this.getLink(), (ConnectableElement)oppositeRole, (ConnectableElement)newRole, this.oppositePartWithPort, this.newPartWithPort);
            if (ConnectorUtils.applyUMLRulesForConnector(this.getLink()) && !ConnectorUtils.getUMLPossibleRoles(newContainer).contains(newRole)) {
                return false;
            }
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ConnectorEnd oppositeEnd;
        ConnectorEnd editedConnectorEnd;
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.isSourceRedirect()) {
            editedConnectorEnd = (ConnectorEnd)this.getLink().getEnds().get(0);
            oppositeEnd = (ConnectorEnd)this.getLink().getEnds().get(1);
        } else {
            editedConnectorEnd = (ConnectorEnd)this.getLink().getEnds().get(1);
            oppositeEnd = (ConnectorEnd)this.getLink().getEnds().get(0);
        }
        if (editedConnectorEnd != null) {
            this.reorientEnd(editedConnectorEnd, oppositeEnd, (ConnectableElement)this.newEnd, this.newPartWithPort, this.oppositePartWithPort);
            if (ConnectorUtils.applyUMLRulesForConnector(this.getLink())) {
                StructuredClassifier newContainer = this.deduceParentConnector(this.getLink(), (ConnectableElement)this.oppositeEnd, (ConnectableElement)this.newEnd, this.oppositePartWithPort, this.newPartWithPort);
                this.replaceOwner(this.getLink(), newContainer);
            }
            return CommandResult.newOKCommandResult();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientEnd(ConnectorEnd end, ConnectorEnd oppositeEnd, ConnectableElement role, Property partWithPort, Property oppositePartWithPort) {
        end.setRole(role);
        end.setPartWithPort(partWithPort);
        oppositeEnd.setPartWithPort(oppositePartWithPort);
        return CommandResult.newOKCommandResult();
    }

    public void setNewPartWithPort(Property newPartWithPort) {
        this.newPartWithPort = newPartWithPort;
    }

    protected void replaceOwner(Connector connector, StructuredClassifier newOwner) {
        if (newOwner != connector.getOwner()) {
            if (newOwner.getOwnedConnector(connector.getName()) != null) {
                String replacementName = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)Messages.ConnectorReorientSemanticCommand_0, (Collection)newOwner.eContents());
                connector.setName(replacementName);
            }
            newOwner.getOwnedConnectors().add((Object)connector);
        }
    }

    protected StructuredClassifier deduceParentConnector(Connector connector, ConnectableElement role1, ConnectableElement role2, Property partWithPort1, Property partWithPort2) {
        StructuredClassifier class2;
        StructuredClassifier class1 = role1 instanceof Port && partWithPort1 != null ? (StructuredClassifier)TypeUtils.as((Object)partWithPort1.getOwner(), StructuredClassifier.class) : (StructuredClassifier)TypeUtils.as((Object)role1.getOwner(), StructuredClassifier.class);
        StructuredClassifier structuredClassifier = class2 = role2 instanceof Port && partWithPort2 != null ? (StructuredClassifier)TypeUtils.as((Object)partWithPort2.getOwner(), StructuredClassifier.class) : (StructuredClassifier)TypeUtils.as((Object)role2.getOwner(), StructuredClassifier.class);
        if (class1 == class2) {
            return class1;
        }
        return (StructuredClassifier)TypeUtils.as((Object)connector.getOwner(), StructuredClassifier.class);
    }

    public final void setOppositeEnd(EObject oppositeEnd) {
        this.oppositeEnd = oppositeEnd;
    }

    public final void setNewEnd(EObject newEnd) {
        this.newEnd = newEnd;
    }

    public final void setOppositePartWithPort(Property oppositePartWithPort) {
        this.oppositePartWithPort = oppositePartWithPort;
    }

    public EObject getOppositeEnd() {
        return this.oppositeEnd;
    }

    public EObject getNewEnd() {
        return this.newEnd;
    }

    protected Property getNewPartWithPort() {
        return this.newPartWithPort;
    }

    protected Property getOppositePartWithPort() {
        return this.oppositePartWithPort;
    }
}

