/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.ui.utils;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.widgets.EStructuralFeatureEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class EStructuralFeatureUtil {
    public static void setValueToEditor(EStructuralFeatureEditor editor, Element stereotypedElement, Property property, Stereotype stereotype) {
        EObject stereotypeApplication = stereotypedElement.getStereotypeApplication(stereotype);
        EStructuralFeature structuralFeature = EStructuralFeatureUtil.getFeature(stereotypeApplication, property);
        editor.setProviders((IStaticContentProvider)new UMLContentProvider(stereotypeApplication, structuralFeature, stereotype), (ILabelProvider)new UMLLabelProvider());
        if (structuralFeature instanceof EReference) {
            editor.setValueFactory((ReferenceValueFactory)EStructuralFeatureUtil.getUMLPropertyEditorFactory(stereotypeApplication, (EReference)structuralFeature));
        }
        editor.setFeatureToEdit(property.getName(), structuralFeature, stereotypedElement, stereotypeApplication);
    }

    private static EStructuralFeature getFeature(EObject stereotypeApplication, Property property) {
        return stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)property.getName()));
    }

    private static UMLPropertyEditorFactory getUMLPropertyEditorFactory(EObject stereotypeApplication, EReference reference) {
        UMLPropertyEditorFactory factory = new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(stereotypeApplication, reference);
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)stereotypeApplication.eResource().getResourceSet(), (String)HistoryUtil.getHistoryID((EObject)stereotypeApplication, (EStructuralFeature)reference, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }
}

