/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ClassifiedURIImpl;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.CommonURIUtils;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

class BasicEMFResourceProvider
implements OpaqueResourceProvider.EMF {
    private final Object resourceClassifier;
    private final String diagnosticSource;
    private final EAttribute referenceAttribute;
    private final OpaqueResourceProvider.URIAccessor<EObject, EAttribute, Object> uriAccessor;
    private final BiFunction<EObject, IProject, URI> baseURIFunction;

    BasicEMFResourceProvider(Object resourceClassifier, String diagnosticSource, EAttribute attribute) {
        this(resourceClassifier, diagnosticSource, attribute, null, BasicEMFResourceProvider::getURI);
    }

    BasicEMFResourceProvider(Object resourceClassifier, String diagnosticSource, EAttribute attribute, EAttribute bundleQualifier) {
        this(resourceClassifier, diagnosticSource, attribute, bundleQualifier, BasicEMFResourceProvider::getURI);
    }

    BasicEMFResourceProvider(Object resourceClassifier, String diagnosticSource, EAttribute attribute, OpaqueResourceProvider.URIAccessor<EObject, EAttribute, Object> uriAccessor) {
        this(resourceClassifier, diagnosticSource, attribute, null, uriAccessor);
    }

    BasicEMFResourceProvider(Object resourceClassifier, String diagnosticSource, EAttribute attribute, EAttribute bundleQualifier, OpaqueResourceProvider.URIAccessor<EObject, EAttribute, Object> uriAccessor) {
        if (attribute.getEAttributeType().getInstanceClass() != String.class && attribute.getEAttributeType().getInstanceClass() != URI.class) {
            throw new IllegalArgumentException("attribute not of URI type");
        }
        if (bundleQualifier != null && bundleQualifier.getEAttributeType().getInstanceClass() != String.class) {
            throw new IllegalArgumentException("bundleQualifier not of String type");
        }
        if (bundleQualifier != null && !bundleQualifier.getEContainingClass().isSuperTypeOf(attribute.getEContainingClass())) {
            throw new IllegalArgumentException("bundleQualifier not a feature of the referencing EClass");
        }
        this.resourceClassifier = resourceClassifier;
        this.diagnosticSource = diagnosticSource;
        this.referenceAttribute = attribute;
        this.uriAccessor = uriAccessor;
        Function<IProject, String> projectBundle = project -> Optional.ofNullable(PluginRegistry.findModel((IProject)project)).map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName).orElse(project.getName());
        BiFunction<EObject, IProject, URI> projectBase = (object, project) -> URI.createPlatformPluginURI((String)((String)projectBundle.apply((IProject)project)), (boolean)true).appendSegment("");
        if (bundleQualifier == null) {
            this.baseURIFunction = projectBase;
        } else {
            Function<EObject, Optional> bundleFunction = object -> Optional.of(object).filter(arg_0 -> ((EClass)bundleQualifier.getEContainingClass()).isInstance(arg_0)).map(owner -> (String)owner.eGet((EStructuralFeature)bundleQualifier)).filter(Predicate.not(String::isBlank));
            BiFunction<EObject, IProject, URI> bundleBase = (object, project) -> URI.createPlatformPluginURI((String)((Optional)bundleFunction.apply((EObject)object)).orElse(project.getName()), (boolean)true).appendSegment("");
            this.baseURIFunction = bundleBase;
        }
    }

    @Override
    public Iterable<OpaqueResourceProvider.ClassifiedURI> getOpaqueResourceReferences(IProject modelProject, IFile modelFile, EObject object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.referenceAttribute.getEContainingClass().isInstance((Object)object)) {
            return List.of();
        }
        return Iterables.filter((Iterable)Iterables.transform(this.get(object, this.referenceAttribute), e -> this.resolveURI(modelProject, object, e, diagnostics, context)), Objects::nonNull);
    }

    Iterable<?> get(EObject owner, EAttribute attribute) {
        Object value = owner.eGet((EStructuralFeature)attribute);
        if (value == null) {
            return List.of();
        }
        if (value instanceof Iterable) {
            return Iterables.filter((Iterable)((Iterable)value), Objects::nonNull);
        }
        return List.of(value);
    }

    OpaqueResourceProvider.ClassifiedURI resolveURI(IProject project, EObject object, Object referenceValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        URI result;
        try {
            result = this.uriAccessor.getURI(object, this.referenceAttribute, referenceValue);
        }
        catch (Exception e) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, this.diagnosticSource, 0, NLS.bind((String)Messages.BasicEMFResourceProvider_0, (Object[])new Object[]{EObjectValidator.getObjectLabel((EObject)object, context), this.resourceClassifier, referenceValue}), new Object[]{object, this.referenceAttribute});
            diagnostics.add((Diagnostic)diagnostic);
            return null;
        }
        if (result != null) {
            if (result.isRelative() && result.isHierarchical()) {
                if (result.hasAbsolutePath() && !result.hasAuthority() && !result.hasDevice()) {
                    result = URI.createHierarchicalURI((String[])result.segments(), (String)result.query(), (String)result.fragment());
                }
                result = result.resolve(this.baseURIFunction.apply(object, project));
            }
            if (!CommonURIUtils.exists(object, result)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, this.diagnosticSource, 0, NLS.bind((String)Messages.BasicEMFResourceProvider_1, (Object[])new Object[]{result.lastSegment(), EObjectValidator.getObjectLabel((EObject)object, context), this.resourceClassifier}), new Object[]{object, this.referenceAttribute});
                diagnostics.add((Diagnostic)diagnostic);
                result = null;
            }
        }
        return result == null ? null : new ClassifiedURIImpl(result, this.resourceClassifier);
    }

    static URI getURI(EObject owner, EAttribute attribute, Object value) {
        URI result = null;
        if (value != null && attribute.getEContainingClass().isInstance((Object)owner)) {
            URI uri;
            URI uRI = uri = value instanceof URI ? (URI)value : URI.createURI((String)String.valueOf(value), (boolean)true);
            if (!uri.isEmpty()) {
                result = uri;
            }
        }
        return result;
    }
}

