/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;

public class EditPartUtils {
    public static EditPart findFirstChildEditPartWithId(EditPart editPart, String visualId) {
        List<? extends EditPart> result = EditPartUtils.findChildEditPartsWithId(editPart, visualId);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public static List<? extends EditPart> findChildEditPartsWithId(EditPart editPart, String visualId) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        EditPartUtils.internalFindChildEditPartsWithId(editPart, visualId, editParts);
        return editParts;
    }

    private static void internalFindChildEditPartsWithId(EditPart editPart, String visualId, List<EditPart> result) {
        View view;
        Object model = editPart.getModel();
        if (model instanceof View && (view = (View)model).getType() != null && view.getType().equals(visualId)) {
            result.add(editPart);
        }
        List children = editPart.getChildren();
        for (EditPart child : children) {
            EditPartUtils.internalFindChildEditPartsWithId(child, visualId, result);
        }
    }

    public static EditPart findParentEditPartWithId(EditPart editPart, String visualId) {
        EditPart parent = editPart;
        while (parent != null) {
            Object model = parent.getModel();
            if (!(model instanceof View)) break;
            View parentView = (View)model;
            if (parentView.getType() != null && parentView.getType().equals(visualId)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static GraphicalEditPart findEditPartClosestToOrdinate(int ordinate, List<? extends GraphicalEditPart> editParts) {
        if (editParts.isEmpty()) {
            return null;
        }
        TreeMap<Integer, GraphicalEditPart> distanceMap = new TreeMap<Integer, GraphicalEditPart>();
        for (GraphicalEditPart graphicalEditPart : editParts) {
            IFigure figure = graphicalEditPart.getFigure();
            Rectangle bounds = new Rectangle(figure.getBounds());
            figure.getParent().translateToAbsolute((Translatable)bounds);
            int posY = bounds.y + bounds.height / 2;
            int distance = Math.abs(posY - ordinate);
            distanceMap.put(distance, graphicalEditPart);
        }
        return (GraphicalEditPart)distanceMap.values().iterator().next();
    }

    public static void revealEditPart(EditPart editPart) {
        if (editPart != null && editPart.getViewer() != null) {
            editPart.getViewer().reveal(editPart);
        }
    }
}

