/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementCase;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.IQueryContext;
import org.eclipse.papyrus.emf.facet.query.java.core.internal.exceptions.ClassAlreadyExistsException;
import org.eclipse.papyrus.emf.facet.query.java.core.internal.exceptions.ResourceURIExpectedException;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.wizard.page.CreateQueryClassWizardPage;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.wizard.page.SelectJavaClassWizardPage;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.wizard.page.SelectOrCreateJavaClassWizardPage;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.wizard.IExtendedWizard;

public class SelectOrCreateJavaClassWizard
extends Wizard
implements IExtendedWizard {
    private final WizardDialog dialog;
    private CreateQueryClassWizardPage createClassPage;
    private SelectOrCreateJavaClassWizardPage firstPage;
    private final IDialogCallback<String> callBack;
    private SelectJavaClassWizardPage selectClassPage;
    private final IQueryContext queryContext;

    public SelectOrCreateJavaClassWizard(IQueryContext queryContext, IDialogCallback<String> callBack) throws ClassAlreadyExistsException, ResourceURIExpectedException, JavaModelException {
        ETypedElementCase eTECase;
        this.queryContext = queryContext;
        this.callBack = callBack;
        this.dialog = new WizardDialog(this.getShell(), (IWizard)this);
        this.setWindowTitle(Messages.Choose_an_operation);
        Resource resource = queryContext.getResource();
        URI uri = resource.getURI();
        if (!uri.isPlatformResource()) {
            throw new ResourceURIExpectedException();
        }
        String projectName = uri.segment(1);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        StringBuffer implClassName = new StringBuffer(this.queryContext.getDerivedTypedElementName());
        EObject intermediate = this.queryContext.getIntermediateEObject();
        if (intermediate instanceof ETypedElementCase && (eTECase = (ETypedElementCase)intermediate).getCase() != null) {
            implClassName.append(eTECase.getCase().getName());
        }
        implClassName.append("Query");
        if (javaProject.findType(implClassName.toString()) != null) {
            throw new ClassAlreadyExistsException();
        }
    }

    public void addPages() {
        this.firstPage = new SelectOrCreateJavaClassWizardPage();
        this.addPage((IWizardPage)this.firstPage);
        this.createClassPage = new CreateQueryClassWizardPage(this.queryContext);
        this.addPage((IWizardPage)this.createClassPage);
        this.selectClassPage = new SelectJavaClassWizardPage();
        this.addPage((IWizardPage)this.selectClassPage);
    }

    private String createJavaClass() {
        return this.createClassPage.apply(this.queryContext.getReturnType(), this.queryContext.getUpperBound() > 1, this.queryContext.getExtendedEClass());
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public boolean performFinish() {
        return this.finish();
    }

    public int open() {
        return this.dialog.open();
    }

    public IWizardPage getCurrentPage() {
        return this.getContainer().getCurrentPage();
    }

    public IWizardPage next() {
        IWizardPage nextPage = this.getNextPage(this.getCurrentPage());
        this.dialog.showPage(nextPage);
        return nextPage;
    }

    public IWizardPage previous() {
        IWizardPage previousPage = this.getPreviousPage(this.getCurrentPage());
        this.dialog.showPage(previousPage);
        return previousPage;
    }

    public boolean finish() {
        boolean result = true;
        try {
            if (this.getContainer().getCurrentPage() == this.createClassPage) {
                String classQName = this.createJavaClass();
                this.callBack.committed((Object)classQName);
            } else if (this.getContainer().getCurrentPage() == this.selectClassPage) {
                this.callBack.committed((Object)this.selectClassPage.getResult().toString());
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            result = false;
        }
        return result;
    }

    public boolean performCancel() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object result = null;
        if (page == this.firstPage) {
            result = this.firstPage.isSelect() ? this.selectClassPage : this.createClassPage;
        }
        return result;
    }
}

