/**
 * Copyright (c) 2007-2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - [235113] alternative parser access
 *                                 [244419] custom parsers
 *                                 [138179] expression-backed labels
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up parsers
 */
package impl.parsers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ExternalParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelTextAccessMethod;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OclChoiceParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedEnumParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import parsers.ExpressionLabelParser;
import parsers.PredefinedParser;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.OclTracker_qvto;
import xpt.expressions.getExpression;
import xpt.providers.ElementTypes;
import xpt.providers.ParserUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class ParserProvider {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private OclTracker_qvto _oclTracker_qvto;

  @Inject
  @Extension
  private ParserUtils_qvto _parserUtils_qvto;

  @Inject
  @Extension
  private expression_qvto _expression_qvto;

  @Inject
  @Extension
  private ExpressionLabelParser _expressionLabelParser;

  @Inject
  @Extension
  private PredefinedParser _predefinedParser;

  @Inject
  private getExpression xptGetExpression;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private VisualIDRegistry xptVisualIDRegistry;

  @Inject
  private ElementTypes xptElementTypes;

  @Inject
  private parsers.ParserProvider xptParsers;

  @Inject
  private Activator xptActivator;

  public CharSequence accessorMethod_delegate2providers(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Utility method that consults ParserService");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.gmf.runtime.common.ui.services.parser.IParser getParser(org.eclipse.gmf.runtime.emf.type.core.IElementType type, org.eclipse.emf.ecore.EObject object, String parserHint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserService.getInstance().getParser(new HintAdapter(type, object, parserHint));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * invokes method generated with accessorMethod_delegate2providers template
   */
  @MetaDef
  public CharSequence accessorCall_delegate2providers(final GenCommonBase it, final GenCommonBase elementTypeHolder, final LabelModelFacet labelModelFacet, final String parsedElement) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedClassName = it.getDiagram().getEditorGen().getLabelParsers().getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append(".getParser(");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(elementTypeHolder);
    _builder.append(_accessElementType);
    _builder.append(", ");
    _builder.append(parsedElement);
    _builder.append(", ");
    {
      if ((labelModelFacet == null)) {
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
        _builder.append(_typeMethodCall);
      } else {
        CharSequence _dispatch4_parserHint = this.dispatch4_parserHint(labelModelFacet.getParser(), labelModelFacet, it);
        _builder.append(_dispatch4_parserHint);
      }
    }
    _builder.append(")");
    return _builder;
  }

  protected CharSequence _dispatch4_parserHint(final GenParserImplementation it, final LabelModelFacet labelFacet, final GenCommonBase hintHolder) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(hintHolder);
    _builder.append(_typeMethodCall);
    return _builder;
  }

  /**
   * ExternalParser may override hint
   */
  protected CharSequence _dispatch4_parserHint(final ExternalParser it, final LabelModelFacet labelFacet, final GenCommonBase hintHolder) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _hint = it.getHint();
      boolean _tripleEquals = (_hint == null);
      if (_tripleEquals) {
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(hintHolder);
        _builder.append(_typeMethodCall);
      } else {
        String _hint_1 = it.getHint();
        _builder.append(_hint_1);
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch4_parserHint(final ExternalParser it, final DesignLabelModelFacet labelFacet, final GenCommonBase hintHolder) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _hint = it.getHint();
      boolean _tripleEquals = (_hint == null);
      if (_tripleEquals) {
        _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.CommonParserHint.DESCRIPTION");
      } else {
        String _hint_1 = it.getHint();
        _builder.append(_hint_1);
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch4_parserHint(final GenParserImplementation it, final DesignLabelModelFacet labelFacet, final GenCommonBase hintHolder) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.CommonParserHint.DESCRIPTION");
    return _builder;
  }

  /**
   * FIXME refactor static field to an instance registered within Activator
   * Complementary method to accessorMethod_delegate2providers, although for direct access need an instance of this class
   */
  public CharSequence accessorMethod_direct(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private static ");
    CharSequence _className = this.xptParsers.className(it);
    _builder.append(_className);
    _builder.append(" ourInstance;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public static ");
    CharSequence _className_1 = this.xptParsers.className(it);
    _builder.append(_className_1);
    _builder.append(" get() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (ourInstance == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ourInstance = new ");
    CharSequence _qualifiedClassName = this.xptParsers.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ourInstance;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * XXX consider adding #getDescriptionParser() method to control that kind of parser access?
   * XXX do I really need GenCommonBase elementTypeHolder, why not use elementType reference directly?
   */
  public CharSequence accessorCall_direct(final GenCommonBase it, final GenCommonBase elementTypeHolder, final LabelModelFacet labelModelFacet, final String parsedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((labelModelFacet == null) || this._common_qvto.oclIsKindOf(labelModelFacet.getParser(), ExternalParser.class))) {
        _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.ParserService.getInstance().getParser(new org.eclipse.gmf.runtime.emf.ui.services.parser.ParserHintAdapter(/*");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(elementTypeHolder);
        _builder.append(_accessElementType);
        _builder.append(", */");
        _builder.append(parsedElement);
        _builder.append(", ");
        {
          if ((labelModelFacet == null)) {
            CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
            _builder.append(_typeMethodCall);
          } else {
            CharSequence _dispatch4_parserHint = this.dispatch4_parserHint(labelModelFacet.getParser(), labelModelFacet, it);
            _builder.append(_dispatch4_parserHint);
          }
        }
        _builder.append("))");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _qualifiedClassName = this.xptParsers.qualifiedClassName(it.getDiagram().getEditorGen().getLabelParsers());
        _builder.append(_qualifiedClassName);
        _builder.append(".get().");
        String _parserAccessorName = this._parserUtils_qvto.parserAccessorName(it);
        _builder.append(_parserAccessorName);
        _builder.append("()");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence provider_getParserMethod(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.ui.services.parser.IParser getParser(org.eclipse.core.runtime.IAdaptable hint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String vid = hint.getAdapter(String.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (vid != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getParser(");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(vid));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("hint.getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (view != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getParser(");
    CharSequence _visualIDMethodCall_1 = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
    _builder.append(_visualIDMethodCall_1, "\t\t");
    _builder.append("(view));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence provider_providesMethod(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean provides(org.eclipse.gmf.runtime.common.core.service.IOperation operation) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (operation instanceof org.eclipse.gmf.runtime.common.ui.services.parser.GetParserOperation) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IAdaptable hint =");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("((org.eclipse.gmf.runtime.common.ui.services.parser.GetParserOperation) operation).getHint();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (");
    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getElement(hint) == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getParser(hint) != null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence HintAdapterClass(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class HintAdapter extends org.eclipse.gmf.runtime.emf.ui.services.parser.ParserHintAdapter {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final org.eclipse.gmf.runtime.emf.type.core.IElementType elementType;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public HintAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType type, org.eclipse.emf.ecore.EObject object, String parserHint) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super(object, parserHint);");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence __assert = this._common._assert("type != null");
    _builder.append(__assert, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("elementType = type;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it.getEditorGen().getDiagram());
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public Object getAdapter(@SuppressWarnings(\"rawtypes\") Class adapter) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.gmf.runtime.emf.type.core.IElementType.class.equals(adapter)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return elementType;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.getAdapter(adapter);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getParserByVisualIdMethod(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.ui.services.parser.IParser getParser(String visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (visualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (visualID) {");
    _builder.newLine();
    {
      EList<GenTopLevelNode> _topLevelNodes = it.getEditorGen().getDiagram().getTopLevelNodes();
      for(final GenTopLevelNode node : _topLevelNodes) {
        _builder.append("\t\t\t");
        CharSequence _dispatch_getParsers = this.dispatch_getParsers(node);
        _builder.append(_dispatch_getParsers, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenChildNode> _childNodes = it.getEditorGen().getDiagram().getChildNodes();
      for(final GenChildNode node_1 : _childNodes) {
        _builder.append("\t\t\t");
        CharSequence _dispatch_getParsers_1 = this.dispatch_getParsers(node_1);
        _builder.append(_dispatch_getParsers_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getEditorGen().getDiagram().getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t\t");
        CharSequence _dispatch_getParsers_2 = this.dispatch_getParsers(link);
        _builder.append(_dispatch_getParsers_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dispatch_getParsers(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenNodeLabel> _labels = it.getLabels();
      for(final GenNodeLabel label : _labels) {
        {
          LabelModelFacet _modelFacet = label.getModelFacet();
          boolean _tripleNotEquals = (_modelFacet != null);
          if (_tripleNotEquals) {
            String _doGetParser = this.doGetParser(label.getModelFacet().getParser(), label);
            _builder.append(_doGetParser);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch_getParsers(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenLinkLabel> _labels = it.getLabels();
      for(final GenLinkLabel label : _labels) {
        {
          LabelModelFacet _modelFacet = label.getModelFacet();
          boolean _tripleNotEquals = (_modelFacet != null);
          if (_tripleNotEquals) {
            String _doGetParser = this.doGetParser(label.getModelFacet().getParser(), label);
            _builder.append(_doGetParser);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch_getParsers(final GenChildLabelNode it) {
    CharSequence _xifexpression = null;
    TypeModelFacet _modelFacet = it.getModelFacet();
    boolean _tripleNotEquals = (_modelFacet != null);
    if (_tripleNotEquals) {
      StringConcatenation _builder = new StringConcatenation();
      String _doGetParser = this.doGetParser(it.getLabelModelFacet().getParser(), it);
      _builder.append(_doGetParser);
      _xifexpression = _builder;
    }
    return _xifexpression;
  }

  public String doGetParser(final GenParserImplementation parser, final GenCommonBase element) {
    boolean _not = (!((parser == null) || this._common_qvto.oclIsKindOf(parser, ExternalParser.class)));
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(element);
      _builder.append(_caseVisualID);
      _builder.append(" return ");
      String _parserAccessorName = this._parserUtils_qvto.parserAccessorName(element);
      _builder.append(_parserAccessorName);
      _builder.append("();");
      return _builder.toString();
    }
    return null;
  }

  protected CharSequence _dispatch_parsers(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenNodeLabel> _labels = it.getLabels();
      for(final GenNodeLabel label : _labels) {
        {
          LabelModelFacet _modelFacet = label.getModelFacet();
          boolean _tripleNotEquals = (_modelFacet != null);
          if (_tripleNotEquals) {
            CharSequence _dispatch_parser = this.dispatch_parser(label.getModelFacet().getParser(), label.getModelFacet(), label);
            _builder.append(_dispatch_parser);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch_parsers(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenLinkLabel> _labels = it.getLabels();
      for(final GenLinkLabel label : _labels) {
        {
          LabelModelFacet _modelFacet = label.getModelFacet();
          boolean _tripleNotEquals = (_modelFacet != null);
          if (_tripleNotEquals) {
            CharSequence _dispatch_parser = this.dispatch_parser(label.getModelFacet().getParser(), label.getModelFacet(), label);
            _builder.append(_dispatch_parser);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _dispatch_parsers(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dispatch_parser = this.dispatch_parser(it.getLabelModelFacet().getParser(), it.getLabelModelFacet(), it);
    _builder.append(_dispatch_parser);
    return _builder;
  }

  protected CharSequence _dispatch_parser(final GenParserImplementation it, final LabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Abstract template for " + it) + ", element: ") + element));
    return _builder;
  }

  protected CharSequence _dispatch_parser(final CustomParser it, final LabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    String _qualifiedName = it.getQualifiedName();
    _builder.append(_qualifiedName);
    _builder.append(" ");
    String _parserFieldName = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    {
      boolean _isExtensibleViaService = it.getHolder().isExtensibleViaService();
      if (_isExtensibleViaService) {
        _builder.append("private");
      } else {
        _builder.append("public");
      }
    }
    _builder.append(" org.eclipse.gmf.runtime.common.ui.services.parser.IParser ");
    String _parserAccessorName = this._parserUtils_qvto.parserAccessorName(element);
    _builder.append(_parserAccessorName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (");
    String _parserFieldName_1 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_1, "\t");
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _parserFieldName_2 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_2, "\t\t");
    _builder.append(" = new ");
    String _qualifiedName_1 = it.getQualifiedName();
    _builder.append(_qualifiedName_1, "\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _parserFieldName_3 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_3, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}\t");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dispatch_parser(final ExternalParser it, final LabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _dispatch_parser(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it, final FeatureLabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _doPredefinedParser = this.doPredefinedParser(it, modelFacet, element);
    _builder.append(_doPredefinedParser);
    return _builder;
  }

  protected CharSequence _dispatch_parser(final PredefinedEnumParser it, final FeatureLabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _doPredefinedParser = this.doPredefinedParser(it, modelFacet, element);
    _builder.append(_doPredefinedParser);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _dispatch_parser(final OclChoiceParser it, final FeatureLabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _doPredefinedParser = this.doPredefinedParser(it, modelFacet, element);
    _builder.append(_doPredefinedParser);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Intentionally modelFacet typed as general LMF, because ExpressionLabelModelFacet is merely a marker
   */
  protected CharSequence _dispatch_parser(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it, final LabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isParserViewExpressionDefinedAndOcl = this._expression_qvto.isParserViewExpressionDefinedAndOcl(it);
      if (_isParserViewExpressionDefinedAndOcl) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        {
          boolean _isExtensibleViaService = it.getHolder().isExtensibleViaService();
          if (_isExtensibleViaService) {
            _builder.append("private");
          } else {
            _builder.append("public");
          }
        }
        _builder.append(" org.eclipse.gmf.runtime.common.ui.services.parser.IParser ");
        String _parserAccessorName = this._parserUtils_qvto.parserAccessorName(element);
        _builder.append(_parserAccessorName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return new ");
        CharSequence _qualifiedClassName = this._expressionLabelParser.qualifiedClassName(it);
        _builder.append(_qualifiedClassName, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private ");
        CharSequence _qualifiedClassName_1 = this._expressionLabelParser.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_1);
        _builder.append(" ");
        String _parserFieldName = this._parserUtils_qvto.parserFieldName(element);
        _builder.append(_parserFieldName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        {
          boolean _isExtensibleViaService_1 = it.getHolder().isExtensibleViaService();
          if (_isExtensibleViaService_1) {
            _builder.append("private");
          } else {
            _builder.append("public");
          }
        }
        _builder.append(" org.eclipse.gmf.runtime.common.ui.services.parser.IParser ");
        String _parserAccessorName_1 = this._parserUtils_qvto.parserAccessorName(element);
        _builder.append(_parserAccessorName_1);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (");
        String _parserFieldName_1 = this._parserUtils_qvto.parserFieldName(element);
        _builder.append(_parserFieldName_1, "\t");
        _builder.append(" == null) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _parserFieldName_2 = this._parserUtils_qvto.parserFieldName(element);
        _builder.append(_parserFieldName_2, "\t\t");
        _builder.append(" = new ");
        CharSequence _qualifiedClassName_2 = this._expressionLabelParser.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_2, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _parserFieldName_3 = this._parserUtils_qvto.parserFieldName(element);
        _builder.append(_parserFieldName_3, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence doPredefinedParser(final GenParserImplementation it, final FeatureLabelModelFacet modelFacet, final GenCommonBase element) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.common.ui.services.parser.IParser ");
    String _parserFieldName = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    {
      boolean _isExtensibleViaService = it.getHolder().isExtensibleViaService();
      if (_isExtensibleViaService) {
        _builder.append("private");
      } else {
        _builder.append("public");
      }
    }
    _builder.append(" org.eclipse.gmf.runtime.common.ui.services.parser.IParser ");
    String _parserAccessorName = this._parserUtils_qvto.parserAccessorName(element);
    _builder.append(_parserAccessorName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (");
    String _parserFieldName_1 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_1, "\t");
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _dispatch_createPredefinedParser = this.dispatch_createPredefinedParser(it, modelFacet, "parser");
    _builder.append(_dispatch_createPredefinedParser, "\t\t");
    _builder.append("\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _parserFieldName_2 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_2, "\t\t");
    _builder.append(" = parser;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _parserFieldName_3 = this._parserUtils_qvto.parserFieldName(element);
    _builder.append(_parserFieldName_3, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dispatch_createPredefinedParser(final GenParserImplementation it, final FeatureLabelModelFacet modelFacet, final String parserVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("PredefinedParser, PredefinedEnumParser or OclChoiceParser expected but occured: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _dispatch_createPredefinedParser(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it, final FeatureLabelModelFacet modelFacet, final String parserVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.ecore.EAttribute[] features = new org.eclipse.emf.ecore.EAttribute[] {");
    _builder.newLine();
    {
      EList<GenFeature> _metaFeatures = modelFacet.getMetaFeatures();
      boolean _hasElements = false;
      for(final GenFeature f : _metaFeatures) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t");
        }
        _builder.append("\t");
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(f);
        _builder.append(_MetaFeature, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    {
      int _size = modelFacet.getEditableMetaFeatures().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("org.eclipse.emf.ecore.EAttribute[] editableFeatures = new org.eclipse.emf.ecore.EAttribute[] {");
        _builder.newLine();
        {
          EList<GenFeature> _editableMetaFeatures = modelFacet.getEditableMetaFeatures();
          boolean _hasElements_1 = false;
          for(final GenFeature f_1 : _editableMetaFeatures) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            CharSequence _MetaFeature_1 = this.xptMetaModel.MetaFeature(f_1);
            _builder.append(_MetaFeature_1);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("};");
        _builder.newLine();
      }
    }
    CharSequence _qualifiedClassName = this._predefinedParser.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(" ");
    _builder.append(parserVar);
    _builder.append(" = new ");
    CharSequence _qualifiedClassName_1 = this._predefinedParser.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1);
    _builder.append("(features");
    {
      int _size_1 = modelFacet.getEditableMetaFeatures().size();
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        _builder.append(", editableFeatures");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _setPatterns = this.setPatterns(modelFacet, it.getViewMethod(), it.getEditMethod(), parserVar);
    _builder.append(_setPatterns);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _dispatch_createPredefinedParser(final PredefinedEnumParser it, final FeatureLabelModelFacet modelFacet, final String parserVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.ecore.EAttribute editableFeature = ");
    CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(this._common_qvto.<GenFeature>notNullOf(IterableExtensions.<GenFeature>head(modelFacet.getEditableMetaFeatures()), IterableExtensions.<GenFeature>head(modelFacet.getMetaFeatures())));
    _builder.append(_MetaFeature);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append(" ");
    _builder.append(parserVar);
    _builder.append(" = new ");
    String _qualifiedClassName_1 = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName_1);
    _builder.append("(editableFeature);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _dispatch_createPredefinedParser(final OclChoiceParser it, final FeatureLabelModelFacet modelFacet, final String parserVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _createOclChoiceParser = this.createOclChoiceParser(it, modelFacet, parserVar, IterableExtensions.<GenFeature>head(modelFacet.getEditableMetaFeatures()), IterableExtensions.<GenFeature>head(modelFacet.getEditableMetaFeatures()).getGenClass());
    _builder.append(_createOclChoiceParser);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence createOclChoiceParser(final OclChoiceParser it, final FeatureLabelModelFacet modelFacet, final String parserVar, final GenFeature feature, final GenClass context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.ecore.EStructuralFeature editableFeature = ");
    CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(feature);
    _builder.append(_MetaFeature);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.tooling.runtime.parsers.ChoiceParserBase ");
    _builder.append(parserVar);
    _builder.append(" = ");
    _builder.newLineIfNotEmpty();
    {
      ValueExpression _showExpression = it.getShowExpression();
      boolean _tripleNotEquals = (_showExpression != null);
      if (_tripleNotEquals) {
        _builder.append("new org.eclipse.gmf.tooling.runtime.parsers.OclTrackerChoiceParser( //");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("editableFeature, ");
        CharSequence _safeItemExpression = this.safeItemExpression(it, feature);
        _builder.append(_safeItemExpression, "\t");
        _builder.append(", ");
        CharSequence _expressionBody = this.xptGetExpression.getExpressionBody(it.getShowExpression());
        _builder.append(_expressionBody, "\t");
        _builder.append(", ");
        CharSequence _itemProviderAdapterFactory = this.itemProviderAdapterFactory(it);
        _builder.append(_itemProviderAdapterFactory, "\t");
        _builder.append(", ");
        CharSequence _optionalOclTrackerFactoryTypeHint = this.optionalOclTrackerFactoryTypeHint(it.getShowExpression());
        _builder.append(_optionalOclTrackerFactoryTypeHint, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("new org.eclipse.gmf.tooling.runtime.parsers.OclChoiceParser( //");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("editableFeature, ");
        CharSequence _safeItemExpression_1 = this.safeItemExpression(it, feature);
        _builder.append(_safeItemExpression_1, "\t");
        _builder.append(", null, ");
        CharSequence _itemProviderAdapterFactory_1 = this.itemProviderAdapterFactory(it);
        _builder.append(_itemProviderAdapterFactory_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence itemProviderAdapterFactory(final OclChoiceParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getHolder().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance().getItemProvidersAdapterFactory()");
    return _builder;
  }

  public CharSequence safeItemExpression(final OclChoiceParser it, final GenFeature feature) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ValueExpression _itemsExpression = it.getItemsExpression();
      boolean _tripleEquals = (_itemsExpression == null);
      if (_tripleEquals) {
        _builder.append("\"");
        String _name = feature.getEcoreFeature().getEType().getName();
        _builder.append(_name);
        _builder.append(".allInstances()\"");
      } else {
        CharSequence _expressionBody = this.xptGetExpression.getExpressionBody(it.getItemsExpression());
        _builder.append(_expressionBody);
      }
    }
    return _builder;
  }

  public CharSequence optionalOclTrackerFactoryTypeHint(final ValueExpression it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isForcedImpactAnalyzerKind = this._oclTracker_qvto.isForcedImpactAnalyzerKind(it.getBody());
      if (_isForcedImpactAnalyzerKind) {
        _builder.append(", org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTrackerFactory.Type.IMPACT_ANALYZER");
      }
    }
    return _builder;
  }

  public CharSequence setPatterns(final FeatureLabelModelFacet it, final LabelTextAccessMethod viewMethod, final LabelTextAccessMethod editMethod, final String parserVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equals(viewMethod, LabelTextAccessMethod.NATIVE));
      if (_notEquals) {
        {
          boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getViewPattern());
          boolean _not = (!_isNullOrEmpty);
          if (_not) {
            _builder.append(parserVar);
            _builder.append(".setViewPattern(\"");
            String _viewPattern = it.getViewPattern();
            _builder.append(_viewPattern);
            _builder.append("\"); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append(_nonNLS);
            _builder.newLineIfNotEmpty();
          }
        }
        {
          boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(it.getEditorPattern());
          boolean _not_1 = (!_isNullOrEmpty_1);
          if (_not_1) {
            _builder.append(parserVar);
            _builder.append(".setEditorPattern(\"");
            String _editorPattern = it.getEditorPattern();
            _builder.append(_editorPattern);
            _builder.append("\"); ");
            CharSequence _nonNLS_1 = this._common.nonNLS(1);
            _builder.append(_nonNLS_1);
            _builder.newLineIfNotEmpty();
          } else {
            boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(it.getViewPattern());
            boolean _not_2 = (!_isNullOrEmpty_2);
            if (_not_2) {
              _builder.append(parserVar);
              _builder.append(".setEditorPattern(\"");
              String _viewPattern_1 = it.getViewPattern();
              _builder.append(_viewPattern_1);
              _builder.append("\"); ");
              CharSequence _nonNLS_2 = this._common.nonNLS(1);
              _builder.append(_nonNLS_2);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    {
      boolean _notEquals_1 = (!Objects.equals(editMethod, LabelTextAccessMethod.NATIVE));
      if (_notEquals_1) {
        {
          boolean _isNullOrEmpty_3 = StringExtensions.isNullOrEmpty(it.getEditPattern());
          boolean _not_3 = (!_isNullOrEmpty_3);
          if (_not_3) {
            _builder.append(parserVar);
            _builder.append(".setEditPattern(\"");
            String _editPattern = it.getEditPattern();
            _builder.append(_editPattern);
            _builder.append("\"); ");
            CharSequence _nonNLS_3 = this._common.nonNLS(1);
            _builder.append(_nonNLS_3);
            _builder.newLineIfNotEmpty();
          } else {
            boolean _isNullOrEmpty_4 = StringExtensions.isNullOrEmpty(it.getViewPattern());
            boolean _not_4 = (!_isNullOrEmpty_4);
            if (_not_4) {
              _builder.append(parserVar);
              _builder.append(".setEditPattern(\"");
              String _viewPattern_2 = it.getViewPattern();
              _builder.append(_viewPattern_2);
              _builder.append("\"); ");
              CharSequence _nonNLS_4 = this._common.nonNLS(1);
              _builder.append(_nonNLS_4);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    return _builder;
  }

  @XbaseGenerated
  protected CharSequence dispatch4_parserHint(final GenParserImplementation it, final LabelModelFacet labelFacet, final GenCommonBase hintHolder) {
    if (it instanceof ExternalParser
         && labelFacet instanceof DesignLabelModelFacet) {
      return _dispatch4_parserHint((ExternalParser)it, (DesignLabelModelFacet)labelFacet, hintHolder);
    } else if (it instanceof ExternalParser
         && labelFacet != null) {
      return _dispatch4_parserHint((ExternalParser)it, labelFacet, hintHolder);
    } else if (it != null
         && labelFacet instanceof DesignLabelModelFacet) {
      return _dispatch4_parserHint(it, (DesignLabelModelFacet)labelFacet, hintHolder);
    } else if (it != null
         && labelFacet != null) {
      return _dispatch4_parserHint(it, labelFacet, hintHolder);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, labelFacet, hintHolder).toString());
    }
  }

  @XbaseGenerated
  public CharSequence dispatch_getParsers(final GenLinkEnd it) {
    if (it instanceof GenChildLabelNode) {
      return _dispatch_getParsers((GenChildLabelNode)it);
    } else if (it instanceof GenNode) {
      return _dispatch_getParsers((GenNode)it);
    } else if (it instanceof GenLink) {
      return _dispatch_getParsers((GenLink)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence dispatch_parsers(final GenLinkEnd it) {
    if (it instanceof GenChildLabelNode) {
      return _dispatch_parsers((GenChildLabelNode)it);
    } else if (it instanceof GenNode) {
      return _dispatch_parsers((GenNode)it);
    } else if (it instanceof GenLink) {
      return _dispatch_parsers((GenLink)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence dispatch_parser(final GenParserImplementation it, final LabelModelFacet modelFacet, final GenCommonBase element) {
    if (it instanceof OclChoiceParser
         && modelFacet instanceof FeatureLabelModelFacet) {
      return _dispatch_parser((OclChoiceParser)it, (FeatureLabelModelFacet)modelFacet, element);
    } else if (it instanceof PredefinedEnumParser
         && modelFacet instanceof FeatureLabelModelFacet) {
      return _dispatch_parser((PredefinedEnumParser)it, (FeatureLabelModelFacet)modelFacet, element);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser
         && modelFacet instanceof FeatureLabelModelFacet) {
      return _dispatch_parser((org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser)it, (FeatureLabelModelFacet)modelFacet, element);
    } else if (it instanceof CustomParser
         && modelFacet != null) {
      return _dispatch_parser((CustomParser)it, modelFacet, element);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser
         && modelFacet != null) {
      return _dispatch_parser((org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser)it, modelFacet, element);
    } else if (it instanceof ExternalParser
         && modelFacet != null) {
      return _dispatch_parser((ExternalParser)it, modelFacet, element);
    } else if (it != null
         && modelFacet != null) {
      return _dispatch_parser(it, modelFacet, element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, modelFacet, element).toString());
    }
  }

  @XbaseGenerated
  public CharSequence dispatch_createPredefinedParser(final GenParserImplementation it, final FeatureLabelModelFacet modelFacet, final String parserVar) {
    if (it instanceof OclChoiceParser) {
      return _dispatch_createPredefinedParser((OclChoiceParser)it, modelFacet, parserVar);
    } else if (it instanceof PredefinedEnumParser) {
      return _dispatch_createPredefinedParser((PredefinedEnumParser)it, modelFacet, parserVar);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser) {
      return _dispatch_createPredefinedParser((org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser)it, modelFacet, parserVar);
    } else if (it != null) {
      return _dispatch_createPredefinedParser(it, modelFacet, parserVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, modelFacet, parserVar).toString());
    }
  }
}
