/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.GenAuditRoot_qvto;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.ValidationMarker;
import xpt.providers.MarkerNavigationProvider;
import xpt.providers.ValidationDecoratorProvider;
import xpt.providers.ValidationProvider;

@Singleton
public class ValidateAction {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;
    @Inject
    private Activator xptActivator;
    @Inject
    private ValidationProvider xptValidationProvider;
    @Inject
    @Extension
    private GenAuditRoot_qvto _genAuditRoot_qvto;
    @Inject
    @Extension
    private ExternalizerUtils_qvto _externalizerUtils_qvto;
    @Inject
    private ValidationMarker xptValidationMarker;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private MarkerNavigationProvider xptMarkerNavigationProvider;
    @Inject
    private ValidationDecoratorProvider xptValidationDecoratorProvider;

    @MetaDef
    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ValidateAction");
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence extendsList(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.jface.action.Action");
        return _builder;
    }

    public CharSequence ValidateAction(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(it);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _run = this.run(it);
        _builder.append((Object)_run, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _runValidation = this.runValidation(it);
        _builder.append((Object)_runValidation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _runNonUIValidation = this.runNonUIValidation(it);
        _builder.append((Object)_runNonUIValidation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _runValidationWithEP = this.runValidationWithEP(it);
        _builder.append((Object)_runValidationWithEP, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _runEMFValidator = this.runEMFValidator(it);
        _builder.append((Object)_runEMFValidator, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _validate = this.validate(it);
        _builder.append((Object)_validate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createMarkersForStatus = this.createMarkersForStatus(it);
        _builder.append((Object)_createMarkersForStatus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createMarkersForDiagnostic = this.createMarkersForDiagnostic(it);
        _builder.append((Object)_createMarkersForDiagnostic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _addMarker = this.addMarker(it);
        _builder.append((Object)_addMarker, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _diagnosticToStatusSeverity = this.diagnosticToStatusSeverity(it);
        _builder.append((Object)_diagnosticToStatusSeverity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _collectTargetElementsFromStatus = this.collectTargetElementsFromStatus(it);
        _builder.append((Object)_collectTargetElementsFromStatus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _collectTargetElementsFromDiagnostic = this.collectTargetElementsFromDiagnostic(it);
        _builder.append((Object)_collectTargetElementsFromDiagnostic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.ui.IWorkbenchPage page;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append("(org.eclipse.ui.IWorkbenchPage page) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setText(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)));
        _builder.append((Object)_accessorCall, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.page = page;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence run(GenDiagram it) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.ui.IWorkbenchPart workbenchPart = page.getActivePart();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (workbenchPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart part =\t(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) workbenchPart;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("new org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation(");
        }
        _builder.append("new org.eclipse.jface.operation.IRunnableWithProgress() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("public void run(org.eclipse.core.runtime.IProgressMonitor monitor) throws InterruptedException, java.lang.reflect.InvocationTargetException {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("runValidation(part.getDiagramEditPart(), part.getDiagram());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        GenApplication _application_1 = it.getEditorGen().getApplication();
        boolean bl2 = _tripleEquals_1 = _application_1 == null;
        if (_tripleEquals_1) {
            _builder.append(")");
        }
        _builder.append(".run(new org.eclipse.core.runtime.NullProgressMonitor());\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} catch (Exception e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append(".getInstance().logError(\"Validation action failed\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runValidation(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void runValidation(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append(".openDiagram(view.eResource())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.ui.IEditorPart editorPart = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (editorPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("runValidation(((org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) editorPart).getDiagramEditPart(), view);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("runNonUIValidation(view);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (Exception e) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".getInstance().logError(\"Validation action failed\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runNonUIValidation(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void runNonUIValidation(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.swt.widgets.Shell shell = org.eclipse.swt.widgets.Display.getCurrent().getActiveShell();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (shell == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("shell = new org.eclipse.swt.widgets.Shell();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart =");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory.getInstance().createDiagramEditPart(view.getDiagram(),shell);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("runValidation(diagramEditPart, view);");
        _builder.newLine();
        _builder.append("}\t\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runValidationWithEP(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void runValidation(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart fpart = diagramEditPart;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final org.eclipse.gmf.runtime.notation.View fview = view;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain txDomain = org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(view);");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptValidationProvider.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".runWithConstraints(txDomain, new Runnable() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("validate(fpart, fview);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runEMFValidator(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static org.eclipse.emf.common.util.Diagnostic runEMFValidator(org.eclipse.gmf.runtime.notation.View target) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (target.isSetElement() && target.getElement() != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new org.eclipse.emf.ecore.util.Diagnostician() {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public String getObjectLabel(org.eclipse.emf.ecore.EObject eObject) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(eObject, true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}.validate(target.getElement());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.emf.common.util.Diagnostic.OK_INSTANCE;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence validate(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static void validate(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("\t");
            _builder.append("org.eclipse.core.resources.IFile target = view.eResource() != null ? org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(view.eResource()) : null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (target != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName, "\t\t");
            _builder.append(".deleteMarkers(target);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View target = view;");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_1, "\t");
            _builder.append(".removeAllMarkers(diagramEditPart.getViewer());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("org.eclipse.emf.common.util.Diagnostic diagnostic = runEMFValidator(view);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("createMarkers(target, diagnostic, diagramEditPart);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.validation.service.IBatchValidator validator = (org.eclipse.emf.validation.service.IBatchValidator) org.eclipse.emf.validation.service.ModelValidationService.getInstance().newValidator(org.eclipse.emf.validation.model.EvaluationMode.BATCH);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("validator.setIncludeLiveConstraints(true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (view.isSetElement() && view.getElement() != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.runtime.IStatus status = validator.validate(view.getElement());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("createMarkers(target, status, diagramEditPart);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _shouldRunValidateOnDiagram = this._genAuditRoot_qvto.shouldRunValidateOnDiagram(it.getEditorGen().getAudits());
        if (_shouldRunValidateOnDiagram) {
            boolean _hasDiagramElementTargetRule = this._genAuditRoot_qvto.hasDiagramElementTargetRule(it.getEditorGen().getAudits());
            if (_hasDiagramElementTargetRule) {
                _builder.append("\t");
                _builder.append("validator.setTraversalStrategy(");
                CharSequence _qualifiedClassName_2 = this.xptValidationProvider.qualifiedClassName(it);
                _builder.append((Object)_qualifiedClassName_2, "\t");
                _builder.append(".getNotationTraversalStrategy(validator));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("org.eclipse.core.runtime.IStatus status = validator.validate(view);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("createMarkers(target, status, diagramEditPart);");
            _builder.newLine();
        }
        if (it.getEditorGen().getApplication() != null && it.isValidationDecorators()) {
            _builder.append("\t");
            CharSequence _qualifiedClassName_3 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_3, "\t");
            _builder.append(".refreshDecorators(view);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("for (java.util.Iterator it = view.eAllContents(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.emf.ecore.EObject next = (org.eclipse.emf.ecore.EObject) it.next();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (next instanceof org.eclipse.gmf.runtime.notation.View) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _qualifiedClassName_4 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_4, "\t\t\t");
            _builder.append(".refreshDecorators((org.eclipse.gmf.runtime.notation.View) next);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createMarkersForStatus(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static void createMarkers(");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("org.eclipse.core.resources.IFile");
        } else {
            _builder.append("org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append(" target, org.eclipse.core.runtime.IStatus validationStatus, org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (validationStatus.isOK()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final org.eclipse.core.runtime.IStatus rootStatus = validationStatus;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<org.eclipse.emf.validation.model.IConstraintStatus> allStatuses = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.emf.validation.model.IConstraintStatus");
        _builder.append(_diamondOp, "\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".LazyElement2ViewMap element2ViewMap = new ");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(".LazyElement2ViewMap(diagramEditPart.getDiagramView(), collectTargetElements(rootStatus, new java.util.HashSet<");
        String _diamondOp_1 = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.emf.ecore.EObject");
        _builder.append(_diamondOp_1, "\t");
        _builder.append(">(), allStatuses));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator<org.eclipse.emf.validation.model.IConstraintStatus> it = allStatuses.iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.validation.model.IConstraintStatus nextStatus = it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t\t");
        _builder.append(".findView(diagramEditPart, nextStatus.getTarget(), element2ViewMap);\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view), org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(nextStatus.getTarget(), true), nextStatus.getMessage(), nextStatus.getSeverity());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createMarkersForDiagnostic(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static void createMarkers(");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("org.eclipse.core.resources.IFile");
        } else {
            _builder.append("org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append(" target, org.eclipse.emf.common.util.Diagnostic emfValidationStatus, org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (emfValidationStatus.getSeverity() == org.eclipse.emf.common.util.Diagnostic.OK) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final org.eclipse.emf.common.util.Diagnostic rootStatus = emfValidationStatus;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<org.eclipse.emf.common.util.Diagnostic> allDiagnostics = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.emf.common.util.Diagnostic");
        _builder.append(_diamondOp, "\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(".LazyElement2ViewMap element2ViewMap = new ");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(".LazyElement2ViewMap(diagramEditPart.getDiagramView(), collectTargetElements(rootStatus, new java.util.HashSet<");
        String _diamondOp_1 = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.emf.ecore.EObject");
        _builder.append(_diamondOp_1, "\t");
        _builder.append(">(), allDiagnostics));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator<org.eclipse.emf.common.util.Diagnostic> it = emfValidationStatus.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.common.util.Diagnostic nextDiagnostic = it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.List<?> data = nextDiagnostic.getData();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.emf.ecore.EObject element = (org.eclipse.emf.ecore.EObject) data.get(0);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t\t\t");
        _builder.append(".findView(diagramEditPart, element, element2ViewMap);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view), org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(element, true), nextDiagnostic.getMessage(), diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addMarker(GenDiagram it) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static void addMarker(org.eclipse.gef.EditPartViewer viewer, ");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("org.eclipse.core.resources.IFile");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        } else {
            _builder.append("org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append(" target, String elementId, String location, String message, int statusSeverity) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (target == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        GenApplication _application_1 = it.getEditorGen().getApplication();
        boolean bl2 = _tripleEquals_1 = _application_1 == null;
        if (_tripleEquals_1) {
            _builder.append("\t");
            CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append(".addMarker(target, elementId, location, message, statusSeverity);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("new ");
            CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_1, "\t");
            _builder.append("(location, message, statusSeverity).add(viewer, elementId);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence diagnosticToStatusSeverity(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static int diagnosticToStatusSeverity(int diagnosticSeverity) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.OK) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.core.runtime.IStatus.OK;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.INFO) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.core.runtime.IStatus.INFO;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.WARNING) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.core.runtime.IStatus.WARNING;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.ERROR || diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.CANCEL) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.core.runtime.IStatus.ERROR;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.core.runtime.IStatus.INFO;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence collectTargetElementsFromStatus(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.core.runtime.IStatus status, java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List<org.eclipse.emf.validation.model.IConstraintStatus> allConstraintStatuses) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (status instanceof org.eclipse.emf.validation.model.IConstraintStatus) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("targetElementCollector.add(((org.eclipse.emf.validation.model.IConstraintStatus) status).getTarget());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("allConstraintStatuses.add((org.eclipse.emf.validation.model.IConstraintStatus)status);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (status.isMultiStatus()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.runtime.IStatus[] children = status.getChildren();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (int i = 0; i < children.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return targetElementCollector;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence collectTargetElementsFromDiagnostic(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.emf.common.util.Diagnostic diagnostic, java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List<org.eclipse.emf.common.util.Diagnostic> allDiagnostics) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<?> data = diagnostic.getData();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject target = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("target = (org.eclipse.emf.ecore.EObject) data.get(0);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("targetElementCollector.add(target);\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("allDiagnostics.add(diagnostic);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator<org.eclipse.emf.common.util.Diagnostic> it = diagnostic.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("collectTargetElements(it.next(), targetElementCollector, allDiagnostics);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return targetElementCollector;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)), "Validate");
        _builder.append((Object)_messageEntry);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)));
        _builder.append((Object)_accessorField);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForValidateAction(GenDiagram diagram) {
        return this.className(diagram).toString();
    }
}

