/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.ThemeInitializerManager;

public class CreateShapeCompartmentViewCommand
extends RecordingCommand {
    private View owner;
    private boolean isVisible;

    public CreateShapeCompartmentViewCommand(TransactionalEditingDomain domain, String label, String description, View owner, boolean isVisible) {
        super(domain, label, description);
        this.owner = owner;
        this.setVisible(isVisible);
    }

    protected void doExecute() {
        BasicCompartment compartment = NotationFactory.eINSTANCE.createBasicCompartment();
        compartment.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
        compartment.getStyles().add((Object)ts);
        compartment.setType("compartment_shape_display");
        ViewUtil.insertChildView((View)this.owner, (View)compartment, (int)-1, (boolean)false);
        if (ThemeInitializerManager.instance.usePreferenceInitializer((View)compartment)) {
            ts.setShowTitle(false);
            compartment.setVisible(this.isVisible());
            compartment.setMutable(false);
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

