/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.rulebased.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.core.IRule;

public abstract class AbstractRule<T extends RuleConfiguration>
implements IRule<T> {
    protected T invariantRuleConfiguration;

    @Override
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            IElementType typeToCreate = ((CreateElementRequest)request).getElementType();
            if (!this.approveCreationRequest((ConfiguredHintedSpecializationElementType)typeToCreate, (CreateElementRequest)request)) {
                return false;
            }
        } else if (request instanceof SetRequest) {
            EStructuralFeature feature = ((SetRequest)request).getFeature();
            if (feature instanceof EReference) {
                Object value = ((SetRequest)request).getValue();
                ArrayList<Object> values = new ArrayList<Object>();
                if (value instanceof EObject) {
                    values.add(value);
                } else if (value instanceof List) {
                    values.addAll((List)value);
                }
                for (Object e : values) {
                    IElementType[] types;
                    if (!(e instanceof EObject)) continue;
                    IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)e, request.getClientContext());
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IElementType type = iElementTypeArray[n2];
                        if (type instanceof ConfiguredHintedSpecializationElementType && !this.approveSetRequest((ConfiguredHintedSpecializationElementType)type, (SetRequest)request)) {
                            return false;
                        }
                        ++n2;
                    }
                }
            }
        } else if (request instanceof MoveRequest) {
            Map objectsToMove = ((MoveRequest)request).getElementsToMove();
            for (EObject movedElement : objectsToMove.keySet()) {
                IElementType[] iElementTypeArray;
                IElementType[] iElementTypeArray2 = iElementTypeArray = ElementTypeRegistry.getInstance().getAllTypesMatching(movedElement, request.getClientContext());
                int n = iElementTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IElementType type = iElementTypeArray2[n3];
                    if (type instanceof ConfiguredHintedSpecializationElementType && !this.approveMoveRequest((ConfiguredHintedSpecializationElementType)type, (MoveRequest)request)) {
                        return false;
                    }
                    ++n3;
                }
            }
            return true;
        }
        return true;
    }

    protected abstract boolean approveMoveRequest(ConfiguredHintedSpecializationElementType var1, MoveRequest var2);

    protected abstract boolean approveSetRequest(ConfiguredHintedSpecializationElementType var1, SetRequest var2);

    protected abstract boolean approveCreationRequest(ConfiguredHintedSpecializationElementType var1, CreateElementRequest var2);

    @Override
    public void init(T invariantRuleConfiguration) {
        this.invariantRuleConfiguration = invariantRuleConfiguration;
    }
}

