/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionContainerDeletionContext;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionFragmentContainerEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionOperand;

public class InteractionOperandEditHelperAdvice
extends InteractionFragmentContainerEditHelperAdvice {
    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
        if (request instanceof CreateElementRequest) {
            this.configureCreate((CreateElementRequest)request);
        }
    }

    private void configureCreate(CreateElementRequest request) {
        InteractionOperand operand;
        Element operandOwner;
        if (ElementUtil.isTypeOf(request.getElementType(), (IElementType)UMLElementTypes.INTERACTION_OPERAND) && request.getContainer() instanceof InteractionOperand && (operandOwner = (operand = (InteractionOperand)request.getContainer()).getOwner()) instanceof CombinedFragment) {
            request.setContainer((EObject)operandOwner);
        }
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        ICommand result = super.getAfterDestroyDependentsCommand(request);
        if (request.getElementToDestroy() instanceof InteractionOperand) {
            Optional<Object> context;
            InteractionOperand operand = (InteractionOperand)request.getElementToDestroy();
            final CombinedFragment cfrag = Optional.ofNullable(operand.getOwner()).filter(CombinedFragment.class::isInstance).map(CombinedFragment.class::cast).orElse(null);
            Optional<Object> optional = context = cfrag == null ? Optional.empty() : InteractionContainerDeletionContext.get(request);
            if (context.isPresent()) {
                AbstractTransactionalCommand deferredCFragDeletion = new AbstractTransactionalCommand(request.getEditingDomain(), "Delete Combined Fragment", null, request){
                    private IElementEditService edit;
                    private DestroyElementRequest destroyCFrag;
                    {
                        super($anonymous0, $anonymous1, $anonymous2);
                        this.edit = ElementEditServiceUtils.getCommandProvider((Object)combinedFragment.eContainer(), (IClientContext)destroyDependentsRequest.getClientContext());
                        this.destroyCFrag = new DestroyElementRequest(destroyDependentsRequest.getEditingDomain(), (EObject)combinedFragment, false);
                    }

                    public boolean canExecute() {
                        return super.canExecute() && this.edit != null;
                    }

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (cfrag.eResource() != null && cfrag.getOperands().isEmpty()) {
                            ICommand delegate = this.edit.getEditCommand((IEditCommandRequest)this.destroyCFrag);
                            if (delegate == null || !delegate.canExecute()) {
                                return CommandResult.newCancelledCommandResult();
                            }
                            delegate.execute(monitor, info);
                            return delegate.getCommandResult();
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                result = CompositeCommand.compose((ICommand)result, (ICommand)deferredCFragDeletion);
            }
        }
        return result;
    }

    static boolean deletingAllOperands(InteractionContainerDeletionContext ctx, CombinedFragment cfrag, DestroyDependentsRequest req) {
        Set destroying = req.getDependentElementsToDestroy();
        return cfrag.getOperands().stream().allMatch(operand -> ctx.isBeingDestroyed((InteractionOperand)operand) || destroying.contains(operand));
    }
}

