/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;

public class PluginValidation {
    private List<IPluginChecker> pluginCheckers;

    public PluginValidation() {
        this.pluginCheckers = new ArrayList<IPluginChecker>();
    }

    public PluginValidation(List<IPluginChecker> pluginCheckers) {
        this.pluginCheckers = new ArrayList<IPluginChecker>(pluginCheckers);
    }

    public void addPluginChecker(IPluginChecker pluginChecker) {
        this.pluginCheckers.add(pluginChecker);
    }

    public boolean removePluginChecker(IPluginChecker pluginChecker) {
        return this.pluginCheckers.remove(pluginChecker);
    }

    public void validate(IProgressMonitor monitor) {
        this.pluginCheckers.stream().forEach(checker -> {
            if (!monitor.isCanceled()) {
                checker.check(monitor);
            }
        });
    }
}

