/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum ReadOnlyAxis {
    PERMISSION,
    DISCRETION;

    private static final Set<ReadOnlyAxis> ANY_AXIS;
    private static final Set<ReadOnlyAxis> PERMISSION_AXES;
    private static final Set<ReadOnlyAxis> DISCRETION_AXES;

    static {
        ANY_AXIS = Sets.immutableEnumSet(EnumSet.allOf(ReadOnlyAxis.class));
        PERMISSION_AXES = Collections.singleton(PERMISSION);
        DISCRETION_AXES = Collections.singleton(DISCRETION);
    }

    public Set<ReadOnlyAxis> singleton() {
        switch (this) {
            case PERMISSION: {
                return PERMISSION_AXES;
            }
            case DISCRETION: {
                return DISCRETION_AXES;
            }
        }
        throw new IllegalStateException("Impossible enumeration value: " + String.valueOf((Object)this));
    }

    public static Set<ReadOnlyAxis> anyAxis() {
        return ANY_AXIS;
    }

    public static Set<ReadOnlyAxis> permissionAxes() {
        return PERMISSION_AXES;
    }

    public static Set<ReadOnlyAxis> discretionAxes() {
        return DISCRETION_AXES;
    }
}

