/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.filter.configuration;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class EReferenceFilterComboBoxDataProvider
implements IComboBoxDataProvider {
    private Object axisElement;
    private IConfigRegistry configRegistry;

    public EReferenceFilterComboBoxDataProvider(IConfigRegistry configRegistry, Object axisElement) {
        this.configRegistry = configRegistry;
        this.axisElement = axisElement;
    }

    public List<?> getValues(int columnIndex, int rowIndex) {
        NattableModelManager tableManager = (NattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        EventList rowElements = tableManager.getHorizontalBasicEventList();
        Assert.isTrue((rowIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((rowIndex < rowElements.size() ? 1 : 0) != 0);
        List columnElements = tableManager.getColumnElementsList();
        Assert.isTrue((columnIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((columnIndex < columnElements.size() ? 1 : 0) != 0);
        Object columnElement = columnElements.get(columnIndex);
        Assert.isTrue((columnElement == this.axisElement ? 1 : 0) != 0);
        Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(NattableConfigAttributes.OBJECT_NAME_AND_PATH_COMPARATOR, DisplayMode.NORMAL, new String[]{"object_name_and_path_comparator_id"});
        TreeSet<Object> uniqueValues = new TreeSet<Object>(comparator);
        for (Object current : rowElements) {
            Object result = CellManagerFactory.INSTANCE.getCrossValue(columnElement, current, (INattableModelManager)tableManager);
            if (result == null) continue;
            if (result instanceof Collection) {
                uniqueValues.addAll((Collection)result);
                continue;
            }
            if (result instanceof String && ((String)result).isEmpty()) continue;
            uniqueValues.add(result);
        }
        return new ArrayList(uniqueValues);
    }
}

