/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.representation.architecture.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.textedit.representation.architecture.Activator;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.ui.internal.modelresource.TextDocumentSharedModelResource;

public abstract class AbstractCreateTextDocumentViewCommand<T extends EObject>
extends RecordingCommand {
    protected final EObject semanticContext;
    protected final EObject graphicalContext;
    protected final boolean openAfterCreation;
    protected final String editorViewName;
    protected T createdEditorView;

    public AbstractCreateTextDocumentViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        super(domain, label);
        this.semanticContext = semanticContext;
        this.graphicalContext = graphicalContext != null ? graphicalContext : semanticContext;
        this.openAfterCreation = openAfterCreation;
        this.editorViewName = editorViewName;
    }

    public AbstractCreateTextDocumentViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, boolean openAfterCreation) {
        this(domain, label, editorViewName, semanticContext, null, openAfterCreation);
    }

    public final T getCreatedEditorView() {
        return this.createdEditorView;
    }

    protected final void attachToResource(EObject modelElement, TextDocument textDocument) {
        ServicesRegistry sReg = this.getServiceRegistry(modelElement);
        if (sReg == null) {
            return;
        }
        ModelSet modelSet = this.getModelSet(sReg);
        if (modelSet == null) {
            return;
        }
        TextDocumentSharedModelResource model = null;
        try {
            model = (TextDocumentSharedModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.textedit.ui.modelresource.TextDocumentSharedModelResource");
        }
        catch (NotFoundException e) {
            Activator.log.error(NLS.bind((String)"The class {0} is not found", (Object)TextDocumentSharedModelResource.class.getName()), (Throwable)e);
            return;
        }
        model.addTextDocument(textDocument);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    private ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("ModelSet not found", (Throwable)e);
            return null;
        }
    }

    private IPageManager getPageManager(ServicesRegistry servicesRegistry) {
        try {
            return (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("IPageManager not found", (Throwable)e);
            return null;
        }
    }

    protected final void openEditor(TextDocument textDocument) {
        ServicesRegistry sReg = this.getServiceRegistry(textDocument.getSemanticContext());
        if (sReg == null) {
            return;
        }
        IPageManager pageManager = this.getPageManager(sReg);
        if (pageManager == null) {
            return;
        }
        pageManager.openPage((Object)textDocument);
    }

    public Collection<?> getResult() {
        if (this.createdEditorView != null) {
            return Collections.singleton(this.createdEditorView);
        }
        return Collections.emptyList();
    }
}

